/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.event;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.qubership.atp.mia.model.impl.FlowData;
import org.qubership.atp.mia.model.impl.event.EventExcelCustomer;
import org.qubership.atp.mia.model.impl.event.EventExcelProjectFive;
import org.qubership.atp.mia.model.impl.event.EventExcelProjectFour;
import org.qubership.atp.mia.model.impl.event.EventExcelProjectOne;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.utils.ExcelParserHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFromExcel {
    private static final Logger log = LoggerFactory.getLogger(EventFromExcel.class);
    public static final String ERROR_MESSAGE = "Please add field and provide path to Excel file in it";
    @Nonnull
    private final XSSFSheet sheet;
    @Nonnull
    private EventExcelCustomer eventExcelCustomer;

    public EventFromExcel(MiaContext miaContext) throws IllegalArgumentException {
        Map<String, String> params = miaContext.getFlowData().getParameters();
        if (!params.containsKey("EventGenerationFile")) {
            throw new IllegalArgumentException("Field with name EventGenerationFile is not specified. Please add field and provide path to Excel file in it");
        }
        this.sheet = ExcelParserHelper.getSheet(miaContext.getUploadsPath().resolve(params.get("EventGenerationFile")), params.get("EventGenerationSheet"));
        this.eventExcelCustomer = this.defineCustomerOfExcelFile(params.get("EventGenerationScenario"), params.get("EventGenerationTestCase"));
        this.saveAttributesIntoFlowData(miaContext.getFlowData());
    }

    private void saveAttributesIntoFlowData(FlowData flowData) {
        this.eventExcelCustomer.getAttrNameAndValue().forEach((name, value) -> {
            flowData.addParameter((String)name, value.toString());
            log.trace("Saved to flowData: {} with value {}", name, value);
        });
    }

    public void removeEventAttributesFromFlowData(FlowData flowData) {
        this.eventExcelCustomer.getAttrNameAndValue().keySet().forEach(flowData::removeParameter);
    }

    private EventExcelCustomer defineCustomerOfExcelFile(@Nullable String scenario, @Nullable String testCase) {
        EventExcelCustomer eventExcel = new EventExcelProjectFive(this.sheet, scenario, testCase);
        if (eventExcel.isCurrentFormat()) {
            log.info("Parse Excel file as Telekom");
            eventExcel.parse();
            return eventExcel;
        }
        eventExcel = new EventExcelProjectFour(this.sheet, scenario, testCase);
        if (eventExcel.isCurrentFormat()) {
            log.info("Parse Excel file as O2UK");
            eventExcel.parse();
            return eventExcel;
        }
        eventExcel = new EventExcelProjectOne(this.sheet, scenario, testCase);
        if (eventExcel.isCurrentFormat()) {
            log.info("Parse Excel file as Project One");
            eventExcel.parse();
            return eventExcel;
        }
        throw new IllegalArgumentException("Customer of Excel file is not defined");
    }
}

