/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.executable;

import clover.com.google.common.base.Strings;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.mia.model.impl.executable.FileMarker;
import org.qubership.atp.mia.model.impl.executable.GeneralModel;
import org.qubership.atp.mia.model.impl.executable.Rest;
import org.qubership.atp.mia.model.impl.executable.Soap;
import org.qubership.atp.mia.model.impl.executable.TestDataParams;
import org.qubership.atp.mia.model.pot.Marker;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Command
extends GeneralModel {
    private static final long serialVersionUID = -4849070705138269312L;
    @Nullable
    private String pathForUpload;
    @Nullable
    private String regexpForFileRetrieve;
    @Nullable
    private String fileExtension;
    @Nullable
    private List<String> namesOfFilesForGeneration;
    @Nullable
    private List<String> ethalonFilesForGeneration;
    @Nullable
    private String delayForGeneration;
    @Nullable
    private List<String> pathsForDownload;
    @Nullable
    private LinkedHashMap<String, String> variablesToExtractFromLog;
    @Nullable
    private Marker marker;
    @Nullable
    private String description;
    @Nullable
    private String warningDescription;
    @Nullable
    private String logFileNameFormat;
    @Nullable
    private String saveGeneratedFilesToParameter;
    @Nullable
    private String charsetForGeneratedFile;
    private boolean displayDownloadedFileContent;
    @Nullable
    private List<String> filesForUpload;
    @Nullable
    private LinkedHashMap<String, String> atpValues;
    @Nullable
    private List<FileMarker> fileMarkers;
    @Nullable
    private transient String toExecute;
    @Nullable
    private TestDataParams testDataParams;
    @Nullable
    private Rest rest;
    @Nullable
    private Soap soap;

    public Command(@Nonnull Command command) {
        this(command.getName(), command.getType(), command.getSystem(), command.getValues());
        this.pathForUpload = command.getPathForUpload();
        this.regexpForFileRetrieve = command.getRegexpForFileRetrieve();
        this.namesOfFilesForGeneration = command.getNamesOfFilesForGeneration();
        this.ethalonFilesForGeneration = command.getEthalonFilesForGeneration();
        this.delayForGeneration = command.getDelayForGeneration();
        this.pathsForDownload = command.getPathsForDownload();
        this.variablesToExtractFromLog = command.getVariablesToExtractFromLog();
        this.marker = command.getMarker();
        this.description = command.getDescription();
        this.warningDescription = command.getWarningDescription();
        this.logFileNameFormat = command.getLogFileNameFormat();
        this.saveGeneratedFilesToParameter = command.getSaveGeneratedFilesToParameter();
        this.charsetForGeneratedFile = command.getCharsetForGeneratedFile();
        this.displayDownloadedFileContent = command.getDisplayDownloadedFileContent();
        this.filesForUpload = command.getFilesForUpload();
        this.fileMarkers = command.getFileMarkers();
        this.toExecute = command.getToExecute();
        this.testDataParams = command.getTestDataParams();
        this.rest = command.getRest();
        this.soap = command.getSoap();
    }

    public Command() {
    }

    public Command(@Nonnull String toExecute) {
        super.setValue(toExecute);
        this.toExecute = toExecute;
    }

    public Command(@Nonnull String name, @Nonnull String type, @Nonnull String system, @Nonnull LinkedHashSet<String> values) {
        super(name, type, system, values);
        if (values != null && !values.isEmpty()) {
            this.toExecute = (String)values.stream().findFirst().get();
        }
    }

    public Command clone() {
        CommandBuilder<?, ?> builder = this.toBuilder();
        builder.values(this.cloneValues());
        if (this.namesOfFilesForGeneration != null) {
            builder.namesOfFilesForGeneration(new ArrayList<String>(this.namesOfFilesForGeneration));
        }
        if (this.ethalonFilesForGeneration != null) {
            builder.ethalonFilesForGeneration(new ArrayList<String>(this.ethalonFilesForGeneration));
        }
        if (this.pathsForDownload != null) {
            builder.pathsForDownload(new ArrayList<String>(this.pathsForDownload));
        }
        if (this.variablesToExtractFromLog != null) {
            builder.variablesToExtractFromLog(new LinkedHashMap<String, String>(this.variablesToExtractFromLog));
        }
        if (this.marker != null) {
            builder.marker(this.marker.clone());
        }
        if (this.filesForUpload != null) {
            builder.filesForUpload(new ArrayList<String>(this.filesForUpload));
        }
        if (this.atpValues != null) {
            builder.atpValues(new LinkedHashMap<String, String>(this.atpValues));
        }
        if (this.fileMarkers != null) {
            builder.fileMarkers(new ArrayList<FileMarker>(this.fileMarkers));
        }
        if (this.testDataParams != null) {
            builder.testDataParams(this.testDataParams.toBuilder().build());
        }
        if (this.rest != null) {
            builder.rest(this.rest.toBuilder().build());
        }
        if (this.soap != null) {
            builder.soap(this.soap.toBuilder().build());
        }
        return builder.build();
    }

    @Override
    public void setValue(String value) {
        super.addValue(value);
        this.toExecute = value;
        this.value = value;
    }

    @Override
    public String getValue() {
        if (this.toExecute != null) {
            return this.toExecute;
        }
        return this.value != null ? this.value : super.getValue();
    }

    @Override
    public void setValues(LinkedHashSet<String> values) {
        if (values != null) {
            values.stream().filter(Objects::nonNull).forEach(x$0 -> super.addValue((String)x$0));
            if (!values.isEmpty()) {
                this.toExecute = (String)values.stream().findFirst().get();
            }
        }
    }

    public Map<String, String> getAtpValues() {
        if (this.atpValues == null) {
            this.setAtpValues(new LinkedHashMap<String, String>());
        }
        return this.atpValues;
    }

    public Charset definedCharsetForGeneratedFile() {
        if (this.charsetForGeneratedFile == null) {
            return StandardCharsets.US_ASCII;
        }
        return Charset.forName(this.charsetForGeneratedFile);
    }

    public String getToExecute() {
        if (this.toExecute != null) {
            return this.toExecute;
        }
        return super.getValue();
    }

    public Command setToExecute(String toExecute) {
        this.toExecute = toExecute;
        return this;
    }

    @Nullable
    public String getFileExtension() {
        return this.fileExtension;
    }

    public Command setFileExtension(@Nullable String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    @Nullable
    public String getPathForUpload() {
        return this.pathForUpload;
    }

    public Command setPathForUpload(@Nullable String pathForUpload) {
        this.pathForUpload = pathForUpload;
        return this;
    }

    @Nullable
    public List<String> getNamesOfFilesForGeneration() {
        return this.namesOfFilesForGeneration;
    }

    public Command setNamesOfFilesForGeneration(@Nullable List<String> namesOfFilesForGeneration) {
        this.namesOfFilesForGeneration = namesOfFilesForGeneration;
        return this;
    }

    @Nullable
    public List<String> getEthalonFilesForGeneration() {
        return this.ethalonFilesForGeneration;
    }

    public Command setEthalonFilesForGeneration(@Nullable List<String> ethalonFilesForGeneration) {
        this.ethalonFilesForGeneration = ethalonFilesForGeneration;
        return this;
    }

    @Nullable
    public String getRegexpForFileRetrieve() {
        return this.regexpForFileRetrieve;
    }

    public Command setRegexpForFileRetrieve(@Nullable String regexpForFileRetrieve) {
        this.regexpForFileRetrieve = regexpForFileRetrieve;
        return this;
    }

    @Nullable
    public String getDelayForGeneration() {
        return this.delayForGeneration;
    }

    public Command setDelayForGeneration(@Nullable String delayForGeneration) {
        this.delayForGeneration = delayForGeneration;
        return this;
    }

    @Nullable
    public List<String> getPathsForDownload() {
        return this.pathsForDownload;
    }

    public Command setPathsForDownload(@Nullable List<String> pathsForDownload) {
        this.pathsForDownload = pathsForDownload;
        return this;
    }

    @Nullable
    public Marker getMarker() {
        return this.marker;
    }

    public Command setMarker(@Nullable Marker marker) {
        this.marker = marker;
        return this;
    }

    @Nullable
    public String getSaveGeneratedFilesToParameter() {
        return this.saveGeneratedFilesToParameter;
    }

    public Command setSaveGeneratedFilesToParameter(@Nullable String saveGeneratedFilesToParameter) {
        this.saveGeneratedFilesToParameter = saveGeneratedFilesToParameter;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public String getWarningDescription() {
        return this.warningDescription;
    }

    public void setWarningDescription(@Nullable String warningDescription) {
        this.warningDescription = warningDescription;
    }

    @Nullable
    public String getLogFileNameFormat() {
        return this.logFileNameFormat;
    }

    public Command setLogFileNameFormat(@Nullable String logFileNameFormat) {
        this.logFileNameFormat = Strings.emptyToNull((String)logFileNameFormat);
        return this;
    }

    @Nullable
    public LinkedHashMap<String, String> getVariablesToExtractFromLog() {
        return this.variablesToExtractFromLog;
    }

    public Command setVariablesToExtractFromLog(@Nullable LinkedHashMap<String, String> variablesToExtractFromLog) {
        this.variablesToExtractFromLog = variablesToExtractFromLog;
        return this;
    }

    @Nullable
    public String getCharsetForGeneratedFile() {
        return this.charsetForGeneratedFile;
    }

    public Command setCharsetForGeneratedFile(@Nullable String charsetForGeneratedFile) {
        this.charsetForGeneratedFile = charsetForGeneratedFile;
        return this;
    }

    public Command setAtpValues(LinkedHashMap<String, String> atpValues) {
        if (atpValues != null) {
            this.atpValues = atpValues;
            this.atpValues.values().forEach(x$0 -> super.addValue((String)x$0));
            if (!atpValues.isEmpty()) {
                this.toExecute = atpValues.values().stream().findFirst().get();
            }
        }
        return this;
    }

    public boolean getDisplayDownloadedFileContent() {
        return this.displayDownloadedFileContent;
    }

    public Command setDisplayDownloadedFileContent(boolean displayDownloadedFileContent) {
        this.displayDownloadedFileContent = displayDownloadedFileContent;
        return this;
    }

    @Nullable
    public List<String> getFilesForUpload() {
        return this.filesForUpload;
    }

    public Command setFilesForUpload(@Nullable List<String> filesForUpload) {
        this.filesForUpload = filesForUpload;
        return this;
    }

    @Nullable
    public List<FileMarker> getFileMarkers() {
        return this.fileMarkers;
    }

    public void setFileMarkers(@Nullable List<FileMarker> fileMarkers) {
        this.fileMarkers = fileMarkers;
    }

    @Nonnull
    public TestDataParams getTestDataParams() {
        return this.testDataParams;
    }

    public void setTestDataParams(@Nonnull TestDataParams testDataParams) {
        this.testDataParams = testDataParams;
    }

    @Nullable
    public Rest getRest() {
        return this.rest;
    }

    public void setRest(@Nullable Rest rest) {
        this.rest = rest;
    }

    @Nullable
    public Soap getSoap() {
        return this.soap;
    }

    public void setSoap(@Nullable Soap soap) {
        this.soap = soap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.getType(), command.getType()) && Objects.equals(this.getSystem(), command.getSystem()) && Objects.equals(this.getValues(), command.getValues()) && Objects.equals(this.atpValues, command.atpValues) && Objects.equals(this.toExecute, command.toExecute) && Objects.equals(this.pathForUpload, command.pathForUpload) && Objects.equals(this.regexpForFileRetrieve, command.regexpForFileRetrieve) && Objects.equals(this.fileExtension, command.fileExtension) && Objects.equals(this.namesOfFilesForGeneration, command.namesOfFilesForGeneration) && Objects.equals(this.ethalonFilesForGeneration, command.ethalonFilesForGeneration) && Objects.equals(this.delayForGeneration, command.delayForGeneration) && Objects.equals(this.variablesToExtractFromLog, command.variablesToExtractFromLog) && Objects.equals(this.marker, command.marker) && Objects.equals(this.pathsForDownload, command.pathsForDownload) && Objects.equals(this.description, command.description) && Objects.equals(this.logFileNameFormat, command.logFileNameFormat) && Objects.equals(this.saveGeneratedFilesToParameter, command.saveGeneratedFilesToParameter) && Objects.equals(this.charsetForGeneratedFile, command.charsetForGeneratedFile) && Objects.equals(this.displayDownloadedFileContent, command.displayDownloadedFileContent) && Objects.equals(this.filesForUpload, command.filesForUpload) && Objects.equals(this.testDataParams, command.testDataParams) && Objects.equals(this.fileMarkers, command.fileMarkers) && Objects.equals(this.rest, command.rest) && Objects.equals(this.soap, command.soap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.getSystem(), this.getValues(), this.atpValues, this.toExecute, this.pathForUpload, this.regexpForFileRetrieve, this.fileExtension, this.namesOfFilesForGeneration, this.ethalonFilesForGeneration, this.delayForGeneration, this.variablesToExtractFromLog, this.marker, this.pathsForDownload, this.description, this.logFileNameFormat, this.saveGeneratedFilesToParameter, this.charsetForGeneratedFile, this.displayDownloadedFileContent, this.filesForUpload, this.fileMarkers, this.testDataParams, this.rest, this.soap);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Command.class.getSimpleName() + "[", "]").add("name='" + this.getName() + "'").add("type='" + this.getType() + "'").add("system='" + this.getSystem() + "'").add("value='" + this.getValue() + "'").add("values='" + this.getValues() + "'").add("atpValues=" + this.atpValues + "'").add("toExecute=" + this.toExecute + "'").add("pathForUpload='" + this.pathForUpload + "'").add("regexpForFileRetrieve='" + this.regexpForFileRetrieve + "'").add("fileExtension='" + this.fileExtension + "'").add("namesOfFilesForGeneration=" + this.namesOfFilesForGeneration + "'").add("ethalonFilesForGeneration=" + this.ethalonFilesForGeneration + "'").add("delayForGeneration='" + this.delayForGeneration + "'").add("pathsForDownload=" + this.pathsForDownload + "'").add("variablesToExtractFromLog=" + this.variablesToExtractFromLog + "'").add("marker=" + this.marker + "'").add("description=" + this.description + "'").add("logFileNameFormat=" + this.logFileNameFormat + "'").add("saveGeneratedFilesToParameter='" + this.saveGeneratedFilesToParameter + "'").add("charsetForGeneratedFile='" + this.charsetForGeneratedFile + "'").add("displayDownloadedFileContent='" + this.displayDownloadedFileContent + "'").add("fileForUpload='" + this.filesForUpload + "'").add("fileMarkers='" + this.fileMarkers + "'").add("rest='" + this.rest + "'").add("testDataParams='" + this.testDataParams + "'").add("soap='" + this.soap + "'").toString();
    }

    protected Command(CommandBuilder<?, ?> b) {
        super(b);
        this.pathForUpload = ((CommandBuilder)b).pathForUpload;
        this.regexpForFileRetrieve = ((CommandBuilder)b).regexpForFileRetrieve;
        this.fileExtension = ((CommandBuilder)b).fileExtension;
        this.namesOfFilesForGeneration = ((CommandBuilder)b).namesOfFilesForGeneration;
        this.ethalonFilesForGeneration = ((CommandBuilder)b).ethalonFilesForGeneration;
        this.delayForGeneration = ((CommandBuilder)b).delayForGeneration;
        this.pathsForDownload = ((CommandBuilder)b).pathsForDownload;
        this.variablesToExtractFromLog = ((CommandBuilder)b).variablesToExtractFromLog;
        this.marker = ((CommandBuilder)b).marker;
        this.description = ((CommandBuilder)b).description;
        this.warningDescription = ((CommandBuilder)b).warningDescription;
        this.logFileNameFormat = ((CommandBuilder)b).logFileNameFormat;
        this.saveGeneratedFilesToParameter = ((CommandBuilder)b).saveGeneratedFilesToParameter;
        this.charsetForGeneratedFile = ((CommandBuilder)b).charsetForGeneratedFile;
        this.displayDownloadedFileContent = ((CommandBuilder)b).displayDownloadedFileContent;
        this.filesForUpload = ((CommandBuilder)b).filesForUpload;
        this.atpValues = ((CommandBuilder)b).atpValues;
        this.fileMarkers = ((CommandBuilder)b).fileMarkers;
        this.toExecute = ((CommandBuilder)b).toExecute;
        this.testDataParams = ((CommandBuilder)b).testDataParams;
        this.rest = ((CommandBuilder)b).rest;
        this.soap = ((CommandBuilder)b).soap;
    }

    public static CommandBuilder<?, ?> builder() {
        return new CommandBuilderImpl();
    }

    public CommandBuilder<?, ?> toBuilder() {
        return new CommandBuilderImpl().$fillValuesFrom(this);
    }

    public Command(@Nullable String pathForUpload, @Nullable String regexpForFileRetrieve, @Nullable String fileExtension, @Nullable List<String> namesOfFilesForGeneration, @Nullable List<String> ethalonFilesForGeneration, @Nullable String delayForGeneration, @Nullable List<String> pathsForDownload, @Nullable LinkedHashMap<String, String> variablesToExtractFromLog, @Nullable Marker marker, @Nullable String description, @Nullable String warningDescription, @Nullable String logFileNameFormat, @Nullable String saveGeneratedFilesToParameter, @Nullable String charsetForGeneratedFile, boolean displayDownloadedFileContent, @Nullable List<String> filesForUpload, @Nullable LinkedHashMap<String, String> atpValues, @Nullable List<FileMarker> fileMarkers, @Nullable String toExecute, @Nullable TestDataParams testDataParams, @Nullable Rest rest, @Nullable Soap soap) {
        this.pathForUpload = pathForUpload;
        this.regexpForFileRetrieve = regexpForFileRetrieve;
        this.fileExtension = fileExtension;
        this.namesOfFilesForGeneration = namesOfFilesForGeneration;
        this.ethalonFilesForGeneration = ethalonFilesForGeneration;
        this.delayForGeneration = delayForGeneration;
        this.pathsForDownload = pathsForDownload;
        this.variablesToExtractFromLog = variablesToExtractFromLog;
        this.marker = marker;
        this.description = description;
        this.warningDescription = warningDescription;
        this.logFileNameFormat = logFileNameFormat;
        this.saveGeneratedFilesToParameter = saveGeneratedFilesToParameter;
        this.charsetForGeneratedFile = charsetForGeneratedFile;
        this.displayDownloadedFileContent = displayDownloadedFileContent;
        this.filesForUpload = filesForUpload;
        this.atpValues = atpValues;
        this.fileMarkers = fileMarkers;
        this.toExecute = toExecute;
        this.testDataParams = testDataParams;
        this.rest = rest;
        this.soap = soap;
    }

    public static abstract class CommandBuilder<C extends Command, B extends CommandBuilder<C, B>>
    extends GeneralModel.GeneralModelBuilder<C, B> {
        private String pathForUpload;
        private String regexpForFileRetrieve;
        private String fileExtension;
        private List<String> namesOfFilesForGeneration;
        private List<String> ethalonFilesForGeneration;
        private String delayForGeneration;
        private List<String> pathsForDownload;
        private LinkedHashMap<String, String> variablesToExtractFromLog;
        private Marker marker;
        private String description;
        private String warningDescription;
        private String logFileNameFormat;
        private String saveGeneratedFilesToParameter;
        private String charsetForGeneratedFile;
        private boolean displayDownloadedFileContent;
        private List<String> filesForUpload;
        private LinkedHashMap<String, String> atpValues;
        private List<FileMarker> fileMarkers;
        private String toExecute;
        private TestDataParams testDataParams;
        private Rest rest;
        private Soap soap;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CommandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Command instance, CommandBuilder<?, ?> b) {
            b.pathForUpload(instance.pathForUpload);
            b.regexpForFileRetrieve(instance.regexpForFileRetrieve);
            b.fileExtension(instance.fileExtension);
            b.namesOfFilesForGeneration(instance.namesOfFilesForGeneration);
            b.ethalonFilesForGeneration(instance.ethalonFilesForGeneration);
            b.delayForGeneration(instance.delayForGeneration);
            b.pathsForDownload(instance.pathsForDownload);
            b.variablesToExtractFromLog(instance.variablesToExtractFromLog);
            b.marker(instance.marker);
            b.description(instance.description);
            b.warningDescription(instance.warningDescription);
            b.logFileNameFormat(instance.logFileNameFormat);
            b.saveGeneratedFilesToParameter(instance.saveGeneratedFilesToParameter);
            b.charsetForGeneratedFile(instance.charsetForGeneratedFile);
            b.displayDownloadedFileContent(instance.displayDownloadedFileContent);
            b.filesForUpload(instance.filesForUpload);
            b.atpValues(instance.atpValues);
            b.fileMarkers(instance.fileMarkers);
            b.toExecute(instance.toExecute);
            b.testDataParams(instance.testDataParams);
            b.rest(instance.rest);
            b.soap(instance.soap);
        }

        public B pathForUpload(@Nullable String pathForUpload) {
            this.pathForUpload = pathForUpload;
            return (B)this.self();
        }

        public B regexpForFileRetrieve(@Nullable String regexpForFileRetrieve) {
            this.regexpForFileRetrieve = regexpForFileRetrieve;
            return (B)this.self();
        }

        public B fileExtension(@Nullable String fileExtension) {
            this.fileExtension = fileExtension;
            return (B)this.self();
        }

        public B namesOfFilesForGeneration(@Nullable List<String> namesOfFilesForGeneration) {
            this.namesOfFilesForGeneration = namesOfFilesForGeneration;
            return (B)this.self();
        }

        public B ethalonFilesForGeneration(@Nullable List<String> ethalonFilesForGeneration) {
            this.ethalonFilesForGeneration = ethalonFilesForGeneration;
            return (B)this.self();
        }

        public B delayForGeneration(@Nullable String delayForGeneration) {
            this.delayForGeneration = delayForGeneration;
            return (B)this.self();
        }

        public B pathsForDownload(@Nullable List<String> pathsForDownload) {
            this.pathsForDownload = pathsForDownload;
            return (B)this.self();
        }

        public B variablesToExtractFromLog(@Nullable LinkedHashMap<String, String> variablesToExtractFromLog) {
            this.variablesToExtractFromLog = variablesToExtractFromLog;
            return (B)this.self();
        }

        public B marker(@Nullable Marker marker) {
            this.marker = marker;
            return (B)this.self();
        }

        public B description(@Nullable String description) {
            this.description = description;
            return (B)this.self();
        }

        public B warningDescription(@Nullable String warningDescription) {
            this.warningDescription = warningDescription;
            return (B)this.self();
        }

        public B logFileNameFormat(@Nullable String logFileNameFormat) {
            this.logFileNameFormat = logFileNameFormat;
            return (B)this.self();
        }

        public B saveGeneratedFilesToParameter(@Nullable String saveGeneratedFilesToParameter) {
            this.saveGeneratedFilesToParameter = saveGeneratedFilesToParameter;
            return (B)this.self();
        }

        public B charsetForGeneratedFile(@Nullable String charsetForGeneratedFile) {
            this.charsetForGeneratedFile = charsetForGeneratedFile;
            return (B)this.self();
        }

        public B displayDownloadedFileContent(boolean displayDownloadedFileContent) {
            this.displayDownloadedFileContent = displayDownloadedFileContent;
            return (B)this.self();
        }

        public B filesForUpload(@Nullable List<String> filesForUpload) {
            this.filesForUpload = filesForUpload;
            return (B)this.self();
        }

        public B atpValues(@Nullable LinkedHashMap<String, String> atpValues) {
            this.atpValues = atpValues;
            return (B)this.self();
        }

        public B fileMarkers(@Nullable List<FileMarker> fileMarkers) {
            this.fileMarkers = fileMarkers;
            return (B)this.self();
        }

        public B toExecute(@Nullable String toExecute) {
            this.toExecute = toExecute;
            return (B)this.self();
        }

        public B testDataParams(@Nullable TestDataParams testDataParams) {
            this.testDataParams = testDataParams;
            return (B)this.self();
        }

        public B rest(@Nullable Rest rest) {
            this.rest = rest;
            return (B)this.self();
        }

        public B soap(@Nullable Soap soap) {
            this.soap = soap;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Command.CommandBuilder(super=" + super.toString() + ", pathForUpload=" + this.pathForUpload + ", regexpForFileRetrieve=" + this.regexpForFileRetrieve + ", fileExtension=" + this.fileExtension + ", namesOfFilesForGeneration=" + this.namesOfFilesForGeneration + ", ethalonFilesForGeneration=" + this.ethalonFilesForGeneration + ", delayForGeneration=" + this.delayForGeneration + ", pathsForDownload=" + this.pathsForDownload + ", variablesToExtractFromLog=" + this.variablesToExtractFromLog + ", marker=" + this.marker + ", description=" + this.description + ", warningDescription=" + this.warningDescription + ", logFileNameFormat=" + this.logFileNameFormat + ", saveGeneratedFilesToParameter=" + this.saveGeneratedFilesToParameter + ", charsetForGeneratedFile=" + this.charsetForGeneratedFile + ", displayDownloadedFileContent=" + this.displayDownloadedFileContent + ", filesForUpload=" + this.filesForUpload + ", atpValues=" + this.atpValues + ", fileMarkers=" + this.fileMarkers + ", toExecute=" + this.toExecute + ", testDataParams=" + this.testDataParams + ", rest=" + this.rest + ", soap=" + this.soap + ")";
        }
    }

    private static final class CommandBuilderImpl
    extends CommandBuilder<Command, CommandBuilderImpl> {
        private CommandBuilderImpl() {
        }

        @Override
        protected CommandBuilderImpl self() {
            return this;
        }

        @Override
        public Command build() {
            return new Command(this);
        }
    }
}

