/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.generation;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.qubership.atp.mia.exceptions.testdata.MatrixEthalonReadFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixEthalonWriteFailException;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.impl.VariableFormat;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;
    private final Path pathToEthalonFile;
    private final String fileExtension;
    private final Charset charset;
    private final String fileName;
    private final String generationFileName;
    private String content;
    private Path generationFile;

    public Template(MiaContext miaContext, MiaFileService miaFileService, String pathToEthalonFile, String generationFileName, String fileExtension, Charset charset) {
        String sanitizedName;
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
        this.pathToEthalonFile = miaContext.getProjectFilePath().resolve(Template.sanitizePathTraversal(pathToEthalonFile)).normalize();
        this.fileName = sanitizedName = Template.sanitizePathTraversal(generationFileName);
        this.generationFileName = sanitizedName + (fileExtension != null ? fileExtension : "");
        this.fileExtension = fileExtension;
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
    }

    private static String sanitizePathTraversal(String fileName) {
        Path p = Paths.get(fileName, new String[0]);
        return p.getFileName().toString();
    }

    public void evaluateFile() {
        this.evaluateContent(this.miaContext.getFlowData().getParameters());
        this.writeContent();
    }

    private String readContent() {
        try {
            this.miaFileService.getFile(this.pathToEthalonFile.toFile());
            this.content = new String(Files.readAllBytes(this.pathToEthalonFile), this.charset);
            this.content = this.miaContext.evaluate(this.content);
            return this.content;
        }
        catch (IOException e) {
            throw new MatrixEthalonReadFailException(this.pathToEthalonFile.toString(), e);
        }
    }

    public String getContent() {
        return this.content == null ? this.readContent() : this.content;
    }

    public String evaluateContent(Map<String, String> additionalParams) {
        this.getContent();
        additionalParams.put("CURRENT_TEMPLATE_FILE_NAME", this.fileName);
        additionalParams.put("CURRENT_TEMPLATE_FILE_EXTENSION", this.fileExtension);
        additionalParams.put("CURRENT_TEMPLATE_FILE_FULL_NAME", this.generationFileName);
        this.content = this.miaContext.evaluate(this.content, additionalParams);
        return this.content;
    }

    public void replaceContent(String from, String to) {
        if (from != null && !from.isEmpty() && to != null) {
            if (this.content == null) {
                this.readContent();
            }
            this.content = this.content.replaceFirst(from, to);
        }
    }

    public void evaluateTemplate(Command command, CommonConfiguration commonConf, Map<String, String> params) {
        String paramInTemplate = command.getTestDataParams().getEventParameterInTemplate();
        String eventTemplate = this.miaContext.evaluate(command.getTestDataParams().getEventTemplate(), params);
        VariableFormat varFormat = new VariableFormat(commonConf.getVariableFormat());
        String neededParamInTemplate = varFormat.getVariableAccordingFormat(paramInTemplate);
        this.replaceContent(neededParamInTemplate, eventTemplate + "\n" + neededParamInTemplate);
    }

    public File getFile() {
        if (this.generationFile == null) {
            this.evaluateFile();
        }
        return this.generationFile.toFile();
    }

    public void writeContent() {
        try {
            this.generationFile = this.miaContext.getLogPath().resolve(this.generationFileName);
            log.trace("Write content into {} file:\n{}", (Object)this.generationFile, (Object)this.content);
            Files.write(this.generationFile, this.content.getBytes(this.charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MatrixEthalonWriteFailException(this.generationFile, e);
        }
    }

    public String getFileName() {
        return this.generationFileName;
    }
}

