/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.macros;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.qubership.atp.mia.model.impl.macros.MacroRegistryImpl;
import org.qubership.atp.mia.model.impl.macros.Macros;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacrosRegistrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacrosRegistrator.class);

    public Map<Class<Macros>, Macros> register() {
        List<Macros> macroses = new Reflections("org.qubership.atp.mia", new Scanner[0]).getSubTypesOf(Macros.class).stream().map(this::instantiate).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        macroses.forEach(MacroRegistryImpl::registerMacros);
        return macroses.stream().collect(Collectors.toMap(m -> m.getClass(), m -> m));
    }

    private <T extends Macros> Optional<T> instantiate(Class<T> macrosClass) {
        try {
            Macros macros = (Macros)macrosClass.newInstance();
            return Optional.of(macros);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create macros with abstract module: " + macrosClass, (Throwable)e);
            return Optional.empty();
        }
    }
}

