/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.macros.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.qubership.atp.mia.exceptions.macrosandevaluations.MacrosIncorrectDateFormatException;
import org.qubership.atp.mia.exceptions.macrosandevaluations.MacrosIncorrectDateInputException;
import org.qubership.atp.mia.model.impl.macros.Macros;
import org.qubership.atp.mia.model.impl.macros.MacrosType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMacros
extends Macros<String> {
    private static final Logger log = LoggerFactory.getLogger(DateMacros.class);

    public DateMacros() {
        super(MacrosType.Date_Formatter.name());
    }

    @Override
    public String evaluate(String[] inputs) {
        if (inputs.length != 3) {
            throw new MacrosIncorrectDateInputException();
        }
        String currentDateVal = inputs[0].trim();
        Locale locale = Locale.getDefault();
        SimpleDateFormat currentFormat = new SimpleDateFormat(inputs[1].trim(), locale);
        SimpleDateFormat newFormat = new SimpleDateFormat(inputs[2].trim(), locale);
        try {
            Date date = currentFormat.parse(currentDateVal);
            return newFormat.format(date);
        }
        catch (ParseException e) {
            throw new MacrosIncorrectDateFormatException(currentDateVal, currentFormat, e);
        }
    }
}

