/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.request;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.impl.request.ProcessRequest;

public class CompoundRequest {
    String name;
    List<ProcessRequest> processList;

    public static CompoundRequest fromCompoundConfiguration(CompoundConfiguration compound) {
        ArrayList<ProcessRequest> processList = compound.getProcesses() == null ? new ArrayList<ProcessRequest>() : compound.getProcesses().stream().map(p -> ProcessRequest.fromProcessConfiguration(p)).collect(Collectors.toList());
        return new CompoundRequest(compound.getName(), processList);
    }

    public static CompoundRequestBuilder builder() {
        return new CompoundRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<ProcessRequest> getProcessList() {
        return this.processList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProcessList(List<ProcessRequest> processList) {
        this.processList = processList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompoundRequest)) {
            return false;
        }
        CompoundRequest other = (CompoundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ProcessRequest> this$processList = this.getProcessList();
        List<ProcessRequest> other$processList = other.getProcessList();
        return !(this$processList == null ? other$processList != null : !((Object)this$processList).equals(other$processList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompoundRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ProcessRequest> $processList = this.getProcessList();
        result = result * 59 + ($processList == null ? 43 : ((Object)$processList).hashCode());
        return result;
    }

    public String toString() {
        return "CompoundRequest(name=" + this.getName() + ", processList=" + this.getProcessList() + ")";
    }

    public CompoundRequest() {
    }

    public CompoundRequest(String name, List<ProcessRequest> processList) {
        this.name = name;
        this.processList = processList;
    }

    public static class CompoundRequestBuilder {
        private String name;
        private List<ProcessRequest> processList;

        CompoundRequestBuilder() {
        }

        public CompoundRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CompoundRequestBuilder processList(List<ProcessRequest> processList) {
            this.processList = processList;
            return this;
        }

        public CompoundRequest build() {
            return new CompoundRequest(this.name, this.processList);
        }

        public String toString() {
            return "CompoundRequest.CompoundRequestBuilder(name=" + this.name + ", processList=" + this.processList + ")";
        }
    }
}

