/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata;

import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.qubership.atp.mia.model.impl.testdata.MainSheetRecord;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbookStyles;
import org.qubership.atp.mia.model.impl.testdata.parsed.Description;
import org.qubership.atp.mia.model.impl.testdata.parsed.Scenario;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidatedParameters;

public class MainSheet {
    public static final String MAIN_SHEET_NAME = "Main";
    private List<MainSheetRecord> records;
    private LinkedList<Scenario> scenarios;

    public void addScenario(Scenario scenario) {
        if (this.scenarios == null) {
            this.scenarios = new LinkedList();
        }
        this.scenarios.add(scenario);
    }

    public void write(TestDataWorkbookStyles wb) {
        SXSSFSheet sheet = wb.getWorkbook().createSheet(MAIN_SHEET_NAME);
        Row hRowBefore = sheet.createRow(12);
        Row hRow = sheet.createRow(13);
        Cell cellSce = hRowBefore.createCell(0);
        cellSce.setCellValue("Scenario");
        cellSce.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        sheet.addMergedRegion(new CellRangeAddress(12, 13, 0, 0));
        Cell cellDescr = hRowBefore.createCell(1);
        cellDescr.setCellValue("Description");
        cellDescr.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        sheet.addMergedRegion(new CellRangeAddress(12, 13, 1, 1));
        Holder rowNum = new Holder((Object)13);
        Holder cellNum = new Holder((Object)1);
        if (this.scenarios.size() > 0 && this.scenarios.get(0).getDescriptions().size() > 0) {
            Cell cell;
            int firstCellNumber;
            Description descr = this.findDescriptionToWriteHeader(true, false, false, false);
            if (descr != null) {
                descr.getEventParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    hRow.createCell(((Integer)cellNum.value).intValue()).setCellValue(k);
                });
                firstCellNumber = (Integer)cellNum.value - descr.getEventParams().size() + 1;
                cell = hRowBefore.createCell(firstCellNumber);
                cell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
                cell.setCellValue("Event parameters");
                if (firstCellNumber < (Integer)cellNum.value) {
                    sheet.addMergedRegion(new CellRangeAddress((Integer)rowNum.value - 1, (Integer)rowNum.value - 1, firstCellNumber, ((Integer)cellNum.value).intValue()));
                }
            }
            if ((descr = this.findDescriptionToWriteHeader(false, true, false, false)) != null) {
                descr.getOtherParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    hRow.createCell(((Integer)cellNum.value).intValue()).setCellValue(k);
                });
                firstCellNumber = (Integer)cellNum.value - descr.getOtherParams().size() + 1;
                cell = hRowBefore.createCell(firstCellNumber);
                cell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
                cell.setCellValue("Other parameters");
                if (firstCellNumber < (Integer)cellNum.value) {
                    sheet.addMergedRegion(new CellRangeAddress((Integer)rowNum.value - 1, (Integer)rowNum.value - 1, firstCellNumber, ((Integer)cellNum.value).intValue()));
                }
            }
            if ((descr = this.findDescriptionToWriteHeader(false, false, true, false)) != null) {
                descr.getValidationParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    hRow.createCell(((Integer)cellNum.value).intValue()).setCellValue(k);
                });
                firstCellNumber = (Integer)cellNum.value - descr.getValidationParams().size() + 1;
                cell = hRowBefore.createCell(firstCellNumber);
                cell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
                cell.setCellValue("Parameters to validate");
                if (firstCellNumber < (Integer)cellNum.value) {
                    sheet.addMergedRegion(new CellRangeAddress((Integer)rowNum.value - 1, (Integer)rowNum.value - 1, firstCellNumber, ((Integer)cellNum.value).intValue()));
                }
            }
            if ((descr = this.findDescriptionToWriteHeader(false, false, false, true)) != null) {
                descr.getValidatedParams().forEach(v -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    hRow.createCell(((Integer)cellNum.value).intValue()).setCellValue(v.getKey());
                });
                firstCellNumber = (Integer)cellNum.value - descr.getValidatedParams().size() + 1;
                cell = hRowBefore.createCell(firstCellNumber);
                cell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
                cell.setCellValue("Validated parameters");
                if (firstCellNumber < (Integer)cellNum.value) {
                    sheet.addMergedRegion(new CellRangeAddress((Integer)rowNum.value - 1, (Integer)rowNum.value - 1, firstCellNumber, ((Integer)cellNum.value).intValue()));
                }
            }
            cellNum.value = (Integer)cellNum.value + 1;
            Cell statusCell = hRowBefore.createCell(((Integer)cellNum.value).intValue());
            statusCell.setCellValue("VALIDATION STATUS");
            statusCell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
            sheet.addMergedRegion(new CellRangeAddress((Integer)rowNum.value - 1, ((Integer)rowNum.value).intValue(), ((Integer)cellNum.value).intValue(), ((Integer)cellNum.value).intValue()));
            this.scenarios.forEach(arg_0 -> MainSheet.lambda$write$9(cellNum, (Sheet)sheet, rowNum, wb, arg_0));
        }
    }

    private Description findDescriptionToWriteHeader(boolean isEvent, boolean isOther, boolean isValidation, boolean isValidated) {
        Description descr = null;
        block0: for (Scenario s : this.scenarios) {
            if (descr != null) break;
            if (s.getDescriptions() == null) continue;
            for (Description d : s.getDescriptions()) {
                if (isEvent && d.getEventParams() != null && d.getEventParams().size() > 0) {
                    descr = d;
                    continue block0;
                }
                if (isOther && d.getOtherParams() != null && d.getOtherParams().size() > 0) {
                    descr = d;
                    continue block0;
                }
                if (isValidation && d.getValidationParams() != null && d.getValidationParams().size() > 0) {
                    descr = d;
                    continue block0;
                }
                if (!isValidated || d.getValidatedParams() == null || d.getValidatedParams().size() <= 0) continue;
                descr = d;
                continue block0;
            }
        }
        return descr;
    }

    public List<MainSheetRecord> getRecords() {
        return this.records;
    }

    public LinkedList<Scenario> getScenarios() {
        return this.scenarios;
    }

    public void setRecords(List<MainSheetRecord> records) {
        this.records = records;
    }

    public void setScenarios(LinkedList<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainSheet)) {
            return false;
        }
        MainSheet other = (MainSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MainSheetRecord> this$records = this.getRecords();
        List<MainSheetRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        LinkedList<Scenario> this$scenarios = this.getScenarios();
        LinkedList<Scenario> other$scenarios = other.getScenarios();
        return !(this$scenarios == null ? other$scenarios != null : !((Object)this$scenarios).equals(other$scenarios));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MainSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MainSheetRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        LinkedList<Scenario> $scenarios = this.getScenarios();
        result = result * 59 + ($scenarios == null ? 43 : ((Object)$scenarios).hashCode());
        return result;
    }

    public String toString() {
        return "MainSheet(records=" + this.getRecords() + ", scenarios=" + this.getScenarios() + ")";
    }

    private static /* synthetic */ void lambda$write$9(Holder cellNum, Sheet sheet, Holder rowNum, TestDataWorkbookStyles wb, Scenario s) {
        cellNum.value = -1;
        rowNum.value = (Integer)rowNum.value + 1;
        cellNum.value = (Integer)cellNum.value + 1;
        sheet.createRow(((Integer)rowNum.value).intValue()).createCell(((Integer)cellNum.value).intValue()).setCellValue(s.getName());
        s.getDescriptions().forEach(d -> {
            rowNum.value = (Integer)rowNum.value + 1;
            Row row = sheet.createRow(((Integer)rowNum.value).intValue());
            cellNum.value = 0;
            cellNum.value = (Integer)cellNum.value + 1;
            row.createCell(((Integer)cellNum.value).intValue()).setCellValue(d.getName());
            if (d.getEventParams() != null && d.getEventParams().size() > 0) {
                d.getEventParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    row.createCell(((Integer)cellNum.value).intValue()).setCellValue(v);
                });
            }
            if (d.getOtherParams() != null && d.getOtherParams().size() > 0) {
                d.getOtherParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    row.createCell(((Integer)cellNum.value).intValue()).setCellValue(v);
                });
            }
            if (d.getValidationParams() != null && d.getValidationParams().size() > 0) {
                d.getValidationParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    row.createCell(((Integer)cellNum.value).intValue()).setCellValue(v);
                });
            }
            if (d.getValidatedParams() != null && d.getValidatedParams().size() > 0) {
                d.getValidatedParams().forEach(v -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    Cell cell = row.createCell(((Integer)cellNum.value).intValue());
                    if (v.getState() != null) {
                        cell.setCellStyle(wb.getCellStyle(v.getState()));
                    }
                    cell.setCellValue(v.getValue());
                });
            }
            if (d.isValidated()) {
                cellNum.value = (Integer)cellNum.value + 1;
                Cell cell = row.createCell(((Integer)cellNum.value).intValue());
                cell.setCellStyle(wb.getCellStyle(d.isStatus() ? ValidatedParameters.State.PASSED : ValidatedParameters.State.FAILED));
                cell.setCellValue(d.isStatus() ? "SUCCESS" : "FAILED");
            }
        });
    }
}

