/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata;

import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.qubership.atp.mia.model.impl.testdata.QueriesSheetRecord;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbookStyles;
import org.qubership.atp.mia.model.impl.testdata.parsed.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueriesSheet {
    private static final Logger log = LoggerFactory.getLogger(QueriesSheet.class);
    public static final String QUERIES_SHEET_NAME = "Validation Queries";
    private List<QueriesSheetRecord> records;
    private LinkedList<Query> queries;

    public void addQuery(Query query) {
        if (this.queries == null) {
            this.queries = new LinkedList();
        }
        this.queries.add(query);
    }

    public void write(TestDataWorkbookStyles wb) {
        SXSSFSheet sheet = wb.getWorkbook().createSheet(QUERIES_SHEET_NAME);
        Holder rowNum = new Holder((Object)0);
        Row headerRow = sheet.createRow(((Integer)rowNum.value).intValue());
        Cell headerCell = headerRow.createCell(0);
        headerCell.setCellValue("Query");
        headerCell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("Column to validate");
        headerCell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        headerCell = headerRow.createCell(2);
        headerCell.setCellValue("Validated column");
        headerCell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue("Type");
        headerCell.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        if (this.queries != null && this.queries.size() > 0) {
            this.queries.forEach(arg_0 -> QueriesSheet.lambda$write$1((Sheet)sheet, rowNum, arg_0));
        }
    }

    public List<QueriesSheetRecord> getRecords() {
        return this.records;
    }

    public LinkedList<Query> getQueries() {
        return this.queries;
    }

    public void setRecords(List<QueriesSheetRecord> records) {
        this.records = records;
    }

    public void setQueries(LinkedList<Query> queries) {
        this.queries = queries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueriesSheet)) {
            return false;
        }
        QueriesSheet other = (QueriesSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<QueriesSheetRecord> this$records = this.getRecords();
        List<QueriesSheetRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        LinkedList<Query> this$queries = this.getQueries();
        LinkedList<Query> other$queries = other.getQueries();
        return !(this$queries == null ? other$queries != null : !((Object)this$queries).equals(other$queries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueriesSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<QueriesSheetRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        LinkedList<Query> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : ((Object)$queries).hashCode());
        return result;
    }

    public String toString() {
        return "QueriesSheet(records=" + this.getRecords() + ", queries=" + this.getQueries() + ")";
    }

    private static /* synthetic */ void lambda$write$1(Sheet sheet, Holder rowNum, Query q) {
        rowNum.value = (Integer)rowNum.value + 1;
        Holder row = new Holder((Object)sheet.createRow(((Integer)rowNum.value).intValue()));
        ((Row)row.value).createCell(0).setCellValue(q.getQuery());
        ((Row)row.value).createCell(3).setCellValue(q.getType().toString());
        if (q.getValidateValue() != null && q.getValidateValue().size() > 0) {
            int finalRowNum = (Integer)rowNum.value + q.getValidateValue().size() - 1;
            if (finalRowNum > (Integer)rowNum.value) {
                sheet.addMergedRegion(new CellRangeAddress(((Integer)rowNum.value).intValue(), finalRowNum, 0, 0));
                sheet.addMergedRegion(new CellRangeAddress(((Integer)rowNum.value).intValue(), finalRowNum, 3, 3));
            }
            q.getValidateValue().forEach(validateValue -> {
                ((Row)row.value).createCell(1).setCellValue(validateValue.getValidateName());
                ((Row)row.value).createCell(2).setCellValue(validateValue.getValidatedName());
                rowNum.value = (Integer)rowNum.value + 1;
                row.value = sheet.createRow(((Integer)rowNum.value).intValue());
            });
        }
    }
}

