/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.qubership.atp.mia.model.impl.testdata.MainSheetRecord;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbookStyles;
import org.qubership.atp.mia.model.impl.testdata.parsed.Scenario;

public class TestDataSheet {
    public static final String TEST_DATA_SHEET_NAME = "Test Data";
    private List<MainSheetRecord> records;
    private LinkedList<Scenario> scenarios;

    public void addScenario(Scenario scenario) {
        if (this.scenarios == null) {
            this.scenarios = new LinkedList();
        }
        this.scenarios.add(scenario);
    }

    public void write(TestDataWorkbookStyles wb) {
        SXSSFSheet sheet = wb.getWorkbook().createSheet(TEST_DATA_SHEET_NAME);
        Holder rowNum = new Holder((Object)-1);
        Holder cellNum = new Holder((Object)-1);
        rowNum.value = (Integer)rowNum.value + 1;
        Row headerRow = sheet.createRow(((Integer)rowNum.value).intValue());
        cellNum.value = (Integer)cellNum.value + 1;
        Cell cellSce = headerRow.createCell(((Integer)cellNum.value).intValue());
        cellSce.setCellValue("Scenario");
        cellSce.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        cellNum.value = (Integer)cellNum.value + 1;
        Cell cellDescr = headerRow.createCell(((Integer)cellNum.value).intValue());
        cellDescr.setCellValue("Description");
        cellDescr.setCellStyle(wb.getCellStyle(IndexedColors.YELLOW));
        if (this.scenarios != null && this.scenarios.size() > 0 && this.scenarios.get(0).getDescriptions().size() > 0) {
            LinkedHashMap<String, String> params = this.scenarios.get(0).getDescriptions().get(0).getOtherParams();
            if (params.size() > 0) {
                params.forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    Cell cell = headerRow.createCell(((Integer)cellNum.value).intValue());
                    cell.setCellValue(k);
                    cell.setCellStyle(wb.getCellStyle(IndexedColors.GREY_25_PERCENT));
                });
            }
            this.scenarios.forEach(arg_0 -> TestDataSheet.lambda$write$3(cellNum, (Sheet)sheet, rowNum, arg_0));
        }
    }

    public List<MainSheetRecord> getRecords() {
        return this.records;
    }

    public LinkedList<Scenario> getScenarios() {
        return this.scenarios;
    }

    public void setRecords(List<MainSheetRecord> records) {
        this.records = records;
    }

    public void setScenarios(LinkedList<Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataSheet)) {
            return false;
        }
        TestDataSheet other = (TestDataSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MainSheetRecord> this$records = this.getRecords();
        List<MainSheetRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        LinkedList<Scenario> this$scenarios = this.getScenarios();
        LinkedList<Scenario> other$scenarios = other.getScenarios();
        return !(this$scenarios == null ? other$scenarios != null : !((Object)this$scenarios).equals(other$scenarios));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataSheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MainSheetRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        LinkedList<Scenario> $scenarios = this.getScenarios();
        result = result * 59 + ($scenarios == null ? 43 : ((Object)$scenarios).hashCode());
        return result;
    }

    public String toString() {
        return "TestDataSheet(records=" + this.getRecords() + ", scenarios=" + this.getScenarios() + ")";
    }

    private static /* synthetic */ void lambda$write$3(Holder cellNum, Sheet sheet, Holder rowNum, Scenario s) {
        cellNum.value = -1;
        rowNum.value = (Integer)rowNum.value + 1;
        cellNum.value = (Integer)cellNum.value + 1;
        sheet.createRow(((Integer)rowNum.value).intValue()).createCell(((Integer)cellNum.value).intValue()).setCellValue(s.getName());
        s.getDescriptions().forEach(d -> {
            rowNum.value = (Integer)rowNum.value + 1;
            Row row = sheet.createRow(((Integer)rowNum.value).intValue());
            cellNum.value = 0;
            cellNum.value = (Integer)cellNum.value + 1;
            row.createCell(((Integer)cellNum.value).intValue()).setCellValue(d.getName());
            if (d.getOtherParams().size() > 0) {
                d.getOtherParams().forEach((k, v) -> {
                    cellNum.value = (Integer)cellNum.value + 1;
                    row.createCell(((Integer)cellNum.value).intValue()).setCellValue(v);
                });
            }
        });
    }
}

