/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata;

import java.util.HashMap;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidatedParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataWorkbookStyles
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TestDataWorkbookStyles.class);
    private final SXSSFWorkbook workbook;
    private HashMap<IndexedColors, CellStyle> styles;

    public CellStyle getCellStyle(ValidatedParameters.State isPassed) {
        return this.getCellStyle(isPassed.toString().equals("PASSED") ? IndexedColors.GREEN : (isPassed.toString().equals("FAILED") ? IndexedColors.RED : IndexedColors.GREY_40_PERCENT));
    }

    public CellStyle getCellStyle(IndexedColors fillColor) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        if (!this.styles.containsKey(fillColor)) {
            CellStyle style = this.workbook.createCellStyle();
            style.setFillForegroundColor(fillColor.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styles.put(fillColor, style);
        }
        return this.styles.get(fillColor);
    }

    @Override
    public void close() throws Exception {
        this.workbook.dispose();
    }

    public TestDataWorkbookStyles(SXSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public SXSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public HashMap<IndexedColors, CellStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(HashMap<IndexedColors, CellStyle> styles) {
        this.styles = styles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestDataWorkbookStyles)) {
            return false;
        }
        TestDataWorkbookStyles other = (TestDataWorkbookStyles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SXSSFWorkbook this$workbook = this.getWorkbook();
        SXSSFWorkbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        HashMap<IndexedColors, CellStyle> this$styles = this.getStyles();
        HashMap<IndexedColors, CellStyle> other$styles = other.getStyles();
        return !(this$styles == null ? other$styles != null : !((Object)this$styles).equals(other$styles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestDataWorkbookStyles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SXSSFWorkbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        HashMap<IndexedColors, CellStyle> $styles = this.getStyles();
        result = result * 59 + ($styles == null ? 43 : ((Object)$styles).hashCode());
        return result;
    }

    public String toString() {
        return "TestDataWorkbookStyles(workbook=" + this.getWorkbook() + ", styles=" + this.getStyles() + ")";
    }
}

