/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata.parsed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbook;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidatedParameters;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Description {
    private static final Logger log = LoggerFactory.getLogger(Description.class);
    private String name;
    private LinkedHashMap<String, String> eventParams;
    private LinkedHashMap<String, String> validationParams;
    private LinkedList<ValidatedParameters> validatedParams;
    private LinkedHashMap<String, String> otherParams;
    private boolean status = false;
    private boolean validated = false;
    private boolean onMainSheet = true;

    public Description(String name, boolean onMainSheet, Map<String, String> params, MiaContext miaContext) {
        this(name, onMainSheet, params, miaContext, true);
    }

    public Description(String name, Map<String, String> params, MiaContext miaContext) {
        this(name, true, params, miaContext, true);
    }

    public Description(String name, boolean onMainSheet, Map<String, String> params, MiaContext miaContext, boolean isSort) {
        this.name = name;
        this.onMainSheet = onMainSheet;
        if (isSort) {
            params.forEach((k, v) -> {
                String key = k.toUpperCase();
                String value = miaContext.evaluate((String)v);
                if (key.startsWith("EVENT_")) {
                    this.addEventParam(key, value);
                } else if (key.startsWith("VALIDATE_")) {
                    this.addValidationParam(key, value);
                } else if (key.startsWith("VALIDATED_")) {
                    this.addValidatedParam(key, value);
                } else {
                    this.addOtherParam(key, value);
                }
            });
        } else {
            this.otherParams = new LinkedHashMap();
            this.otherParams.putAll(params);
        }
    }

    private void addEventParam(String key, String value) {
        if (this.eventParams == null) {
            this.eventParams = new LinkedHashMap();
        }
        this.eventParams.put(key, value);
    }

    private void addValidationParam(String key, String value) {
        if (this.validationParams == null) {
            this.validationParams = new LinkedHashMap();
        }
        this.validationParams.put(key, value);
    }

    public void addValidatedParam(String key, String value) {
        if (this.validatedParams == null) {
            this.validatedParams = new LinkedList();
        }
        this.validatedParams.add(new ValidatedParameters(key, value));
    }

    public void updateValidatedParam(String key, String value, ValidatedParameters.State state, String expectedValue) {
        if (this.validatedParams == null || !this.validatedParams.stream().anyMatch(v -> v.getKey().equals(key))) {
            this.addValidatedParam(key, value);
        }
        ValidatedParameters validParam = this.validatedParams.stream().filter(v -> v.getKey().equals(key)).findAny().get();
        if (ValidatedParameters.State.FAILED == state) {
            value = "[AR : " + value + "]\n[ER : " + expectedValue + "]";
        }
        log.debug("Set validated param '{}' with value '{}' and state '{}'", new Object[]{key, value, state});
        validParam.setValue(value);
        validParam.setState(state);
    }

    private void addOtherParam(String key, String value) {
        if (this.otherParams == null) {
            this.otherParams = new LinkedHashMap();
        }
        if (Strings.isEmpty((CharSequence)value)) {
            this.otherParams.putIfAbsent(key, value);
        } else {
            this.otherParams.put(key, value);
        }
    }

    public void addOtherParam(String key, String value, TestDataWorkbook testDataWorkbook) {
        if (this.otherParams == null) {
            this.otherParams = new LinkedHashMap();
        }
        this.otherParams.put(key, value);
        if (this.onMainSheet) {
            testDataWorkbook.getMainSheet().getScenarios().forEach(s -> s.getDescriptions().forEach(d -> d.addOtherParam(key, "")));
        } else {
            testDataWorkbook.getTestDataSheet().getScenarios().forEach(s -> s.getDescriptions().forEach(d -> d.addOtherParam(key, "")));
        }
    }

    public LinkedHashMap<String, String> getAllParams() {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        if (this.eventParams != null) {
            returnMap.putAll(this.eventParams);
        }
        if (this.validationParams != null) {
            returnMap.putAll(this.validationParams);
        }
        if (this.otherParams != null) {
            returnMap.putAll(this.otherParams);
        }
        return returnMap;
    }

    public boolean isPassed() {
        if (!this.validated) {
            this.status = this.validatedParams.stream().allMatch(vp -> ValidatedParameters.State.PASSED == vp.getState() || ValidatedParameters.State.SKIPPED == vp.getState());
            this.validated = true;
        }
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public LinkedHashMap<String, String> getEventParams() {
        return this.eventParams;
    }

    public LinkedHashMap<String, String> getValidationParams() {
        return this.validationParams;
    }

    public LinkedList<ValidatedParameters> getValidatedParams() {
        return this.validatedParams;
    }

    public LinkedHashMap<String, String> getOtherParams() {
        return this.otherParams;
    }

    public boolean isStatus() {
        return this.status;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public boolean isOnMainSheet() {
        return this.onMainSheet;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEventParams(LinkedHashMap<String, String> eventParams) {
        this.eventParams = eventParams;
    }

    public void setValidationParams(LinkedHashMap<String, String> validationParams) {
        this.validationParams = validationParams;
    }

    public void setValidatedParams(LinkedList<ValidatedParameters> validatedParams) {
        this.validatedParams = validatedParams;
    }

    public void setOtherParams(LinkedHashMap<String, String> otherParams) {
        this.otherParams = otherParams;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public void setOnMainSheet(boolean onMainSheet) {
        this.onMainSheet = onMainSheet;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Description)) {
            return false;
        }
        Description other = (Description)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        if (this.isValidated() != other.isValidated()) {
            return false;
        }
        if (this.isOnMainSheet() != other.isOnMainSheet()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LinkedHashMap<String, String> this$eventParams = this.getEventParams();
        LinkedHashMap<String, String> other$eventParams = other.getEventParams();
        if (this$eventParams == null ? other$eventParams != null : !((Object)this$eventParams).equals(other$eventParams)) {
            return false;
        }
        LinkedHashMap<String, String> this$validationParams = this.getValidationParams();
        LinkedHashMap<String, String> other$validationParams = other.getValidationParams();
        if (this$validationParams == null ? other$validationParams != null : !((Object)this$validationParams).equals(other$validationParams)) {
            return false;
        }
        LinkedList<ValidatedParameters> this$validatedParams = this.getValidatedParams();
        LinkedList<ValidatedParameters> other$validatedParams = other.getValidatedParams();
        if (this$validatedParams == null ? other$validatedParams != null : !((Object)this$validatedParams).equals(other$validatedParams)) {
            return false;
        }
        LinkedHashMap<String, String> this$otherParams = this.getOtherParams();
        LinkedHashMap<String, String> other$otherParams = other.getOtherParams();
        return !(this$otherParams == null ? other$otherParams != null : !((Object)this$otherParams).equals(other$otherParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Description;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStatus() ? 79 : 97);
        result = result * 59 + (this.isValidated() ? 79 : 97);
        result = result * 59 + (this.isOnMainSheet() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LinkedHashMap<String, String> $eventParams = this.getEventParams();
        result = result * 59 + ($eventParams == null ? 43 : ((Object)$eventParams).hashCode());
        LinkedHashMap<String, String> $validationParams = this.getValidationParams();
        result = result * 59 + ($validationParams == null ? 43 : ((Object)$validationParams).hashCode());
        LinkedList<ValidatedParameters> $validatedParams = this.getValidatedParams();
        result = result * 59 + ($validatedParams == null ? 43 : ((Object)$validatedParams).hashCode());
        LinkedHashMap<String, String> $otherParams = this.getOtherParams();
        result = result * 59 + ($otherParams == null ? 43 : ((Object)$otherParams).hashCode());
        return result;
    }

    public String toString() {
        return "Description(name=" + this.getName() + ", eventParams=" + this.getEventParams() + ", validationParams=" + this.getValidationParams() + ", validatedParams=" + this.getValidatedParams() + ", otherParams=" + this.getOtherParams() + ", status=" + this.isStatus() + ", validated=" + this.isValidated() + ", onMainSheet=" + this.isOnMainSheet() + ")";
    }
}

