/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata.parsed;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.testdata.parsed.ValidateValue;
import org.qubership.atp.mia.model.pot.db.DbType;
import org.qubership.atp.mia.model.pot.db.table.DbTable;

public class Query {
    private final String query;
    private LinkedHashSet<ValidateValue> validateValue;
    private DbType type;

    public Query(String query, String type) {
        this.query = query;
        try {
            this.type = DbType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.type = DbType.ORACLE;
        }
        this.validateValue = new LinkedHashSet();
    }

    public void addValidateValue(String validateName, String validatedName) {
        if (this.validateValue == null) {
            this.validateValue = new LinkedHashSet();
        }
        this.validateValue.add(new ValidateValue(validateName.toUpperCase(), validatedName.toUpperCase()));
    }

    public void updateResultsFromListCommandResponses(List<CommandResponse> commandResponses) {
        if (commandResponses == null || commandResponses.size() < 1 || commandResponses.get(0).getSqlResponse() == null || commandResponses.get(0).getSqlResponse().getData() == null) {
            this.validateValue.stream().filter(v -> v.getValue() == null).forEach(v -> v.setValue("ERROR: NO QUERY RESULT"));
        } else {
            DbTable table = commandResponses.get(0).getSqlResponse().getData();
            for (int colId = 0; colId < table.getColumns().size(); ++colId) {
                String colName = table.getColumns().get(colId);
                String colValue = table.getData() != null && table.getData().size() > 0 && table.getData().get(0).size() >= colId ? table.getData().get(0).get(colId) : "ERROR: NO COLUMN RESULT";
                Optional<ValidateValue> validation = this.validateValue.stream().filter(v -> v.getValidatedName().equalsIgnoreCase(colName)).findAny();
                if (!validation.isPresent()) continue;
                validation.get().setValue(colValue);
            }
            this.validateValue.stream().filter(v -> v.getValue() == null).forEach(v -> v.setValue("ERROR: COLUMN NOT PRESENT IN QUERY"));
        }
    }

    public void updateResultsWithString(String string) {
        this.validateValue.stream().filter(v -> v.getValue() == null).forEach(v -> v.setValue(string));
    }

    public String getQuery() {
        return this.query;
    }

    public LinkedHashSet<ValidateValue> getValidateValue() {
        return this.validateValue;
    }

    public DbType getType() {
        return this.type;
    }

    public void setValidateValue(LinkedHashSet<ValidateValue> validateValue) {
        this.validateValue = validateValue;
    }

    public void setType(DbType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        LinkedHashSet<ValidateValue> this$validateValue = this.getValidateValue();
        LinkedHashSet<ValidateValue> other$validateValue = other.getValidateValue();
        if (this$validateValue == null ? other$validateValue != null : !((Object)this$validateValue).equals(other$validateValue)) {
            return false;
        }
        DbType this$type = this.getType();
        DbType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        LinkedHashSet<ValidateValue> $validateValue = this.getValidateValue();
        result = result * 59 + ($validateValue == null ? 43 : ((Object)$validateValue).hashCode());
        DbType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Query(query=" + this.getQuery() + ", validateValue=" + this.getValidateValue() + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

