/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.impl.testdata.parsed;

import java.util.LinkedList;
import org.qubership.atp.mia.model.impl.testdata.parsed.Description;

public class Scenario {
    private final String name;
    private LinkedList<Description> descriptions;

    public Scenario(String name) {
        this.name = name;
        this.descriptions = new LinkedList();
    }

    public void addDescription(Description description) {
        if (this.descriptions == null) {
            this.descriptions = new LinkedList();
        }
        this.descriptions.add(description);
    }

    public long getPassedValidatedNumber() {
        return this.descriptions.stream().filter(Description::isPassed).count();
    }

    public long getFailedValidatedNumber() {
        return (long)this.descriptions.size() - this.descriptions.stream().filter(Description::isPassed).count();
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(LinkedList<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        LinkedList<Description> this$descriptions = this.getDescriptions();
        LinkedList<Description> other$descriptions = other.getDescriptions();
        return !(this$descriptions == null ? other$descriptions != null : !((Object)this$descriptions).equals(other$descriptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        LinkedList<Description> $descriptions = this.getDescriptions();
        result = result * 59 + ($descriptions == null ? 43 : ((Object)$descriptions).hashCode());
        return result;
    }

    public String toString() {
        return "Scenario(name=" + this.getName() + ", descriptions=" + this.getDescriptions() + ")";
    }
}

