/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.mia.exceptions.responseerrors.MarkerRegexException;
import org.qubership.atp.mia.model.pot.Statuses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Marker
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Marker.class);
    private static final long serialVersionUID = -8129637806434896234L;
    @Nullable
    private List<String> passedMarkerForLog;
    @Nullable
    private List<String> failedMarkersForLog;
    @Nullable
    private List<String> warnMarkersForLog;
    private boolean failWhenNoPassedMarkersFound;

    public Marker clone() {
        MarkerBuilder builder = this.toBuilder();
        if (this.passedMarkerForLog != null) {
            builder.passedMarkerForLog(new ArrayList<String>(this.passedMarkerForLog));
        }
        if (this.failedMarkersForLog != null) {
            builder.failedMarkersForLog(new ArrayList<String>(this.failedMarkersForLog));
        }
        if (this.warnMarkersForLog != null) {
            builder.warnMarkersForLog(new ArrayList<String>(this.warnMarkersForLog));
        }
        return builder.build();
    }

    public Statuses checkLineForMarker(String line) {
        Statuses status = Statuses.UNKNOWN;
        if (this.failedMarkersForLog != null && this.failedMarkersForLog.stream().anyMatch(marker -> this.checkLineWithMarker((String)marker, line, "failed"))) {
            status = Statuses.FAIL;
        }
        if (!status.equals((Object)Statuses.FAIL) && this.warnMarkersForLog != null && this.warnMarkersForLog.stream().anyMatch(marker -> this.checkLineWithMarker((String)marker, line, "warn"))) {
            status = Statuses.WARNING;
        }
        if (!status.equals((Object)Statuses.FAIL) && !status.equals((Object)Statuses.WARNING) && this.passedMarkerForLog != null && this.passedMarkerForLog.stream().anyMatch(marker -> this.checkLineWithMarker((String)marker, line, "passed"))) {
            status = Statuses.SUCCESS;
        }
        return status;
    }

    private boolean checkLineWithMarker(String marker, String line, String markerType) {
        if (!Strings.isBlank((String)marker)) {
            try {
                return Pattern.compile(marker).matcher(line).find();
            }
            catch (PatternSyntaxException e) {
                throw new MarkerRegexException(markerType, marker);
            }
        }
        return false;
    }

    public static MarkerBuilder builder() {
        return new MarkerBuilder();
    }

    public MarkerBuilder toBuilder() {
        return new MarkerBuilder().passedMarkerForLog(this.passedMarkerForLog).failedMarkersForLog(this.failedMarkersForLog).warnMarkersForLog(this.warnMarkersForLog).failWhenNoPassedMarkersFound(this.failWhenNoPassedMarkersFound);
    }

    @Nullable
    public List<String> getPassedMarkerForLog() {
        return this.passedMarkerForLog;
    }

    @Nullable
    public List<String> getFailedMarkersForLog() {
        return this.failedMarkersForLog;
    }

    @Nullable
    public List<String> getWarnMarkersForLog() {
        return this.warnMarkersForLog;
    }

    public boolean isFailWhenNoPassedMarkersFound() {
        return this.failWhenNoPassedMarkersFound;
    }

    public void setPassedMarkerForLog(@Nullable List<String> passedMarkerForLog) {
        this.passedMarkerForLog = passedMarkerForLog;
    }

    public void setFailedMarkersForLog(@Nullable List<String> failedMarkersForLog) {
        this.failedMarkersForLog = failedMarkersForLog;
    }

    public void setWarnMarkersForLog(@Nullable List<String> warnMarkersForLog) {
        this.warnMarkersForLog = warnMarkersForLog;
    }

    public void setFailWhenNoPassedMarkersFound(boolean failWhenNoPassedMarkersFound) {
        this.failWhenNoPassedMarkersFound = failWhenNoPassedMarkersFound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFailWhenNoPassedMarkersFound() != other.isFailWhenNoPassedMarkersFound()) {
            return false;
        }
        List<String> this$passedMarkerForLog = this.getPassedMarkerForLog();
        List<String> other$passedMarkerForLog = other.getPassedMarkerForLog();
        if (this$passedMarkerForLog == null ? other$passedMarkerForLog != null : !((Object)this$passedMarkerForLog).equals(other$passedMarkerForLog)) {
            return false;
        }
        List<String> this$failedMarkersForLog = this.getFailedMarkersForLog();
        List<String> other$failedMarkersForLog = other.getFailedMarkersForLog();
        if (this$failedMarkersForLog == null ? other$failedMarkersForLog != null : !((Object)this$failedMarkersForLog).equals(other$failedMarkersForLog)) {
            return false;
        }
        List<String> this$warnMarkersForLog = this.getWarnMarkersForLog();
        List<String> other$warnMarkersForLog = other.getWarnMarkersForLog();
        return !(this$warnMarkersForLog == null ? other$warnMarkersForLog != null : !((Object)this$warnMarkersForLog).equals(other$warnMarkersForLog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Marker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFailWhenNoPassedMarkersFound() ? 79 : 97);
        List<String> $passedMarkerForLog = this.getPassedMarkerForLog();
        result = result * 59 + ($passedMarkerForLog == null ? 43 : ((Object)$passedMarkerForLog).hashCode());
        List<String> $failedMarkersForLog = this.getFailedMarkersForLog();
        result = result * 59 + ($failedMarkersForLog == null ? 43 : ((Object)$failedMarkersForLog).hashCode());
        List<String> $warnMarkersForLog = this.getWarnMarkersForLog();
        result = result * 59 + ($warnMarkersForLog == null ? 43 : ((Object)$warnMarkersForLog).hashCode());
        return result;
    }

    public String toString() {
        return "Marker(passedMarkerForLog=" + this.getPassedMarkerForLog() + ", failedMarkersForLog=" + this.getFailedMarkersForLog() + ", warnMarkersForLog=" + this.getWarnMarkersForLog() + ", failWhenNoPassedMarkersFound=" + this.isFailWhenNoPassedMarkersFound() + ")";
    }

    public Marker(@Nullable List<String> passedMarkerForLog, @Nullable List<String> failedMarkersForLog, @Nullable List<String> warnMarkersForLog, boolean failWhenNoPassedMarkersFound) {
        this.passedMarkerForLog = passedMarkerForLog;
        this.failedMarkersForLog = failedMarkersForLog;
        this.warnMarkersForLog = warnMarkersForLog;
        this.failWhenNoPassedMarkersFound = failWhenNoPassedMarkersFound;
    }

    public Marker() {
    }

    public static class MarkerBuilder {
        private List<String> passedMarkerForLog;
        private List<String> failedMarkersForLog;
        private List<String> warnMarkersForLog;
        private boolean failWhenNoPassedMarkersFound;

        MarkerBuilder() {
        }

        public MarkerBuilder passedMarkerForLog(@Nullable List<String> passedMarkerForLog) {
            this.passedMarkerForLog = passedMarkerForLog;
            return this;
        }

        public MarkerBuilder failedMarkersForLog(@Nullable List<String> failedMarkersForLog) {
            this.failedMarkersForLog = failedMarkersForLog;
            return this;
        }

        public MarkerBuilder warnMarkersForLog(@Nullable List<String> warnMarkersForLog) {
            this.warnMarkersForLog = warnMarkersForLog;
            return this;
        }

        public MarkerBuilder failWhenNoPassedMarkersFound(boolean failWhenNoPassedMarkersFound) {
            this.failWhenNoPassedMarkersFound = failWhenNoPassedMarkersFound;
            return this;
        }

        public Marker build() {
            return new Marker(this.passedMarkerForLog, this.failedMarkersForLog, this.warnMarkersForLog, this.failWhenNoPassedMarkersFound);
        }

        public String toString() {
            return "Marker.MarkerBuilder(passedMarkerForLog=" + this.passedMarkerForLog + ", failedMarkersForLog=" + this.failedMarkersForLog + ", warnMarkersForLog=" + this.warnMarkersForLog + ", failWhenNoPassedMarkersFound=" + this.failWhenNoPassedMarkersFound + ")";
        }
    }
}

