/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlUpdateQueryFailException;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.SqlUtils;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAnswer {
    private static final Logger log = LoggerFactory.getLogger(DbAnswer.class);
    private final boolean status;
    private ResultSet resultSet;
    private int updateCount;

    public DbAnswer(boolean status, CallableStatement statement) throws SQLException {
        this.status = status;
        try {
            if (status) {
                this.resultSet = statement.getResultSet();
            } else {
                this.updateCount = statement.getUpdateCount();
            }
        }
        catch (SQLException e) {
            log.error("Error during getResults from statement.", (Throwable)e);
            throw e;
        }
    }

    public DbAnswer(boolean status, int updateCount) {
        this.status = status;
        this.updateCount = updateCount;
    }

    public void updateSqlResponse(SqlResponse response) {
        if (this.status && this.resultSet != null) {
            try {
                DbTable dbTable = SqlUtils.resultSetToDbTable(this.resultSet);
                response.setData(dbTable);
                response.setRecords(dbTable.getData().size());
            }
            catch (SQLException e) {
                throw new SqlUpdateQueryFailException(e);
            }
        } else {
            response.setDescription("Affected rows: " + this.updateCount);
        }
    }

    public boolean isStatus() {
        return this.status;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }
}

