/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.model.pot.db.table.TableMarkerResult;
import org.qubership.atp.mia.service.MiaContext;

public class SqlResponse {
    private DbTable data;
    private String tableName;
    private String query;
    private String description;
    private int records;
    private String limitRecordsMessage;
    @Nullable
    private TableMarkerResult tableMarkerResult;
    @Nullable
    private String internalPathToFile;
    private Link link;
    private boolean saveToWordFile = true;
    private boolean saveToZipFile = false;
    private Map<String, String> connectionInfo;

    public SqlResponse() {
    }

    public SqlResponse(Server server) {
        this.addConnectionInfo(server);
    }

    @Nullable
    public TableMarkerResult getTableMarkerResult() {
        return this.tableMarkerResult;
    }

    public void setTableMarkerResult(@Nullable TableMarkerResult tableMarkerResult) {
        this.tableMarkerResult = tableMarkerResult;
    }

    @Nullable
    public String getInternalPathToFile() {
        return this.internalPathToFile;
    }

    public void setInternalPathToFile(@Nullable String internalPathToFile, MiaContext miaContext) {
        this.internalPathToFile = internalPathToFile;
        if (internalPathToFile != null) {
            this.link = MiaContext.getLogLinkOnUi(internalPathToFile);
        }
    }

    public void addConnectionInfo(Server server) {
        if (server != null) {
            if (this.connectionInfo == null) {
                this.connectionInfo = new HashMap<String, String>();
            }
            this.connectionInfo.put("connection string", server.getProperty("jdbc_url"));
            this.connectionInfo.put("user", server.getUser());
        }
    }

    public DbTable getData() {
        return this.data;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQuery() {
        return this.query;
    }

    public String getDescription() {
        return this.description;
    }

    public int getRecords() {
        return this.records;
    }

    public String getLimitRecordsMessage() {
        return this.limitRecordsMessage;
    }

    public Link getLink() {
        return this.link;
    }

    public boolean isSaveToWordFile() {
        return this.saveToWordFile;
    }

    public boolean isSaveToZipFile() {
        return this.saveToZipFile;
    }

    public Map<String, String> getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setData(DbTable data) {
        this.data = data;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRecords(int records) {
        this.records = records;
    }

    public void setLimitRecordsMessage(String limitRecordsMessage) {
        this.limitRecordsMessage = limitRecordsMessage;
    }

    public void setInternalPathToFile(@Nullable String internalPathToFile) {
        this.internalPathToFile = internalPathToFile;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    public void setSaveToWordFile(boolean saveToWordFile) {
        this.saveToWordFile = saveToWordFile;
    }

    public void setSaveToZipFile(boolean saveToZipFile) {
        this.saveToZipFile = saveToZipFile;
    }

    public void setConnectionInfo(Map<String, String> connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlResponse)) {
            return false;
        }
        SqlResponse other = (SqlResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecords() != other.getRecords()) {
            return false;
        }
        if (this.isSaveToWordFile() != other.isSaveToWordFile()) {
            return false;
        }
        if (this.isSaveToZipFile() != other.isSaveToZipFile()) {
            return false;
        }
        DbTable this$data = this.getData();
        DbTable other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$limitRecordsMessage = this.getLimitRecordsMessage();
        String other$limitRecordsMessage = other.getLimitRecordsMessage();
        if (this$limitRecordsMessage == null ? other$limitRecordsMessage != null : !this$limitRecordsMessage.equals(other$limitRecordsMessage)) {
            return false;
        }
        TableMarkerResult this$tableMarkerResult = this.getTableMarkerResult();
        TableMarkerResult other$tableMarkerResult = other.getTableMarkerResult();
        if (this$tableMarkerResult == null ? other$tableMarkerResult != null : !((Object)this$tableMarkerResult).equals(other$tableMarkerResult)) {
            return false;
        }
        String this$internalPathToFile = this.getInternalPathToFile();
        String other$internalPathToFile = other.getInternalPathToFile();
        if (this$internalPathToFile == null ? other$internalPathToFile != null : !this$internalPathToFile.equals(other$internalPathToFile)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        Map<String, String> this$connectionInfo = this.getConnectionInfo();
        Map<String, String> other$connectionInfo = other.getConnectionInfo();
        return !(this$connectionInfo == null ? other$connectionInfo != null : !((Object)this$connectionInfo).equals(other$connectionInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRecords();
        result = result * 59 + (this.isSaveToWordFile() ? 79 : 97);
        result = result * 59 + (this.isSaveToZipFile() ? 79 : 97);
        DbTable $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $limitRecordsMessage = this.getLimitRecordsMessage();
        result = result * 59 + ($limitRecordsMessage == null ? 43 : $limitRecordsMessage.hashCode());
        TableMarkerResult $tableMarkerResult = this.getTableMarkerResult();
        result = result * 59 + ($tableMarkerResult == null ? 43 : ((Object)$tableMarkerResult).hashCode());
        String $internalPathToFile = this.getInternalPathToFile();
        result = result * 59 + ($internalPathToFile == null ? 43 : $internalPathToFile.hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        Map<String, String> $connectionInfo = this.getConnectionInfo();
        result = result * 59 + ($connectionInfo == null ? 43 : ((Object)$connectionInfo).hashCode());
        return result;
    }

    public String toString() {
        return "SqlResponse(data=" + this.getData() + ", tableName=" + this.getTableName() + ", query=" + this.getQuery() + ", description=" + this.getDescription() + ", records=" + this.getRecords() + ", limitRecordsMessage=" + this.getLimitRecordsMessage() + ", tableMarkerResult=" + this.getTableMarkerResult() + ", internalPathToFile=" + this.getInternalPathToFile() + ", link=" + this.getLink() + ", saveToWordFile=" + this.isSaveToWordFile() + ", saveToZipFile=" + this.isSaveToZipFile() + ", connectionInfo=" + this.getConnectionInfo() + ")";
    }
}

