/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlParseResultFailException;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtils {
    private static final Logger log = LoggerFactory.getLogger(SqlUtils.class);

    public static DbTable resultSetToDbTable(ResultSet rs) throws SQLException {
        return SqlUtils.resultSetToDbTable(rs, 0);
    }

    public static DbTable resultSetToDbTable(ResultSet rs, int limitRecords) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsCount = rsmd.getColumnCount();
        ArrayList headers = Lists.newArrayListWithExpectedSize((int)columnsCount);
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String columnName = rsmd.getColumnName(i);
            headers.add(columnName);
        }
        return new DbTable(headers, Utils.streamOf(new RsIter(rs, columnsCount)).limit(limitRecords > 0 ? (long)limitRecords : Long.MAX_VALUE).collect(Collectors.toList()));
    }

    private static class RsIter
    extends AbstractIterator<List<String>> {
        private final ResultSet rs;
        private final int columnsCount;

        private RsIter(ResultSet rs, int columnsCount) {
            this.rs = rs;
            this.columnsCount = columnsCount;
        }

        protected List<String> computeNext() {
            try {
                if (this.rs.next()) {
                    ArrayList row = Lists.newArrayListWithExpectedSize((int)this.columnsCount);
                    for (int i = 1; i <= this.columnsCount; ++i) {
                        row.add(Objects.toString(this.rs.getObject(i)));
                    }
                    return row;
                }
                return (List)this.endOfData();
            }
            catch (SQLException e) {
                throw new SqlParseResultFailException(e);
            }
        }
    }
}

