/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db.table;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.mia.model.pot.db.table.TableDeserializer;
import org.qubership.atp.mia.model.pot.db.table.TableSerializer;

@JsonSerialize(using=TableSerializer.class)
@JsonDeserialize(using=TableDeserializer.class)
public class DbTable {
    private List<String> columns;
    private List<List<String>> data;
    private int actualDataSizeBeforeLimit;

    public DbTable(List<String> columns, List<List<String>> data) {
        this.columns = columns;
        this.data = data;
    }

    public DbTable(Collection<String> headers, Stream<List<String>> rows) {
        this.columns = Lists.newArrayList(headers);
        this.data = rows.collect(Collectors.toList());
    }

    public void addData(List<String> data) {
        if (this.data == null) {
            this.data = new ArrayList<List<String>>();
        }
        this.data.add(data);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<List<String>> getData() {
        return this.data;
    }

    public int getActualDataSizeBeforeLimit() {
        return this.actualDataSizeBeforeLimit;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setData(List<List<String>> data) {
        this.data = data;
    }

    public void setActualDataSizeBeforeLimit(int actualDataSizeBeforeLimit) {
        this.actualDataSizeBeforeLimit = actualDataSizeBeforeLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbTable)) {
            return false;
        }
        DbTable other = (DbTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getActualDataSizeBeforeLimit() != other.getActualDataSizeBeforeLimit()) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<List<String>> this$data = this.getData();
        List<List<String>> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getActualDataSizeBeforeLimit();
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<List<String>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "DbTable(columns=" + this.getColumns() + ", data=" + this.getData() + ", actualDataSizeBeforeLimit=" + this.getActualDataSizeBeforeLimit() + ")";
    }

    public DbTable() {
    }
}

