/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.db.table;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import org.qubership.atp.mia.model.pot.db.table.DbTable;

public class TableSerializer
extends JsonSerializer<DbTable> {
    public void serialize(DbTable table, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        this.buildHeader(jsonGenerator, table.getColumns());
        this.buildBody(jsonGenerator, table.getData());
        jsonGenerator.writeEndObject();
    }

    private void buildHeader(JsonGenerator jsonGenerator, List<String> columns) throws IOException {
        jsonGenerator.writeFieldName("header");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("rows");
        jsonGenerator.writeStartArray();
        this.buildColumns(jsonGenerator, columns);
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private void buildBody(JsonGenerator jsonGenerator, List<List<String>> rows) throws IOException {
        jsonGenerator.writeFieldName("body");
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("rows");
        jsonGenerator.writeStartArray();
        for (List<String> row : rows) {
            this.buildColumns(jsonGenerator, row);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private void buildColumns(JsonGenerator jsonGenerator, List<String> columns) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("columns");
        jsonGenerator.writeStartArray();
        for (String column : columns) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("value", column);
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

