/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.model.pot.entity;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.pot.entity.PotExecutionStep;

@Entity
@Table(name="pot_session")
public class PotSession {
    @Id
    @Column(name="id", nullable=false, updatable=false)
    private UUID id;
    @OneToMany(mappedBy="potSession", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private final List<PotExecutionStep> potExecutionSteps = new ArrayList<PotExecutionStep>();
    @Column(name="created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());
    @Column(name="created_by")
    private String createdBy;
    @Column(name="project_id", nullable=false, updatable=false)
    private UUID projectId;

    public PotSession(UUID id, ProjectConfiguration projectConfiguration, String user) {
        this.id = id;
        this.projectId = projectConfiguration.getProjectId();
        this.createdBy = user;
    }

    public PotSession addExecutionStep(PotExecutionStep potExecutionStep) {
        this.potExecutionSteps.add(potExecutionStep);
        potExecutionStep.setPotSession(this);
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public List<PotExecutionStep> getPotExecutionSteps() {
        return this.potExecutionSteps;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public PotSession() {
    }
}

