/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.driver;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.mia.exceptions.businesslogic.sql.SqlFirstValueNotPresentException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.pot.db.DbAnswer;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;

public interface QueryDriver<T extends AutoCloseable> {
    default public void close(T closeable) {
        Utils.closeQuietly(closeable);
    }

    public T create(Server var1);

    default public SqlResponse executeQuery(Server server, String query, String tableName, boolean saveToWordFile, boolean saveToZipFile, int dbExecutionRecordsLimit) {
        DbTable dbTable = this.executeQuery(server, query, dbExecutionRecordsLimit);
        SqlResponse sqlResponse = new SqlResponse(server);
        sqlResponse.setQuery(query);
        sqlResponse.setData(dbTable);
        sqlResponse.setRecords(dbTable.getData().size());
        sqlResponse.setTableName(tableName);
        sqlResponse.setSaveToWordFile(saveToWordFile);
        sqlResponse.setSaveToZipFile(saveToZipFile);
        if (dbTable.getActualDataSizeBeforeLimit() > dbExecutionRecordsLimit) {
            sqlResponse.setLimitRecordsMessage("The number of returned rows exceeds the maximum allowed number of " + dbExecutionRecordsLimit + " rows");
        }
        return sqlResponse;
    }

    public DbTable executeQuery(Server var1, String var2);

    public DbTable executeQuery(Server var1, String var2, int var3);

    default public String executeQueryAndGetFirstValue(Server server, String query) {
        try {
            DbTable table = this.executeQuery(server, query, 0);
            return table.getData().get(0).get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SqlFirstValueNotPresentException(query);
        }
    }

    public int executeUpdate(Server var1, String var2);

    public DbAnswer executeStoredProcedure(Server var1, String var2);

    public String getDriverType();

    default public int getExecutionTimeout(int executionTimeout, Server server) {
        int timeout = executionTimeout < 1 ? 30 : executionTimeout;
        return server.getTimeoutExecute(timeout, 600);
    }

    default public LoadingCache<Server, T> initPool(final Logger log, int expireAfter) {
        long expireTimeout = expireAfter < 1 ? 30000L : (long)expireAfter;
        return CacheBuilder.newBuilder().expireAfterAccess(expireTimeout, TimeUnit.MILLISECONDS).removalListener(notification -> {
            log.info(this.getDriverType() + " connection released for {}", notification.getKey());
            this.close((AutoCloseable)notification.getValue());
        }).build(new CacheLoader<Server, T>(){

            public T load(Server key) {
                log.debug(QueryDriver.this.getDriverType() + " connection added for {}", (Object)key);
                return QueryDriver.this.create(key);
            }
        });
    }

    default public void initPoolCleanUp(Logger log, LoadingCache<Server, T> cache, long cleanUpTimeout) {
        long timeout = cleanUpTimeout < 1L ? 30000L : cleanUpTimeout;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            Thread.currentThread().setName("mia_clean" + this.getDriverType() + "Pool");
            long cacheSizeBefore = cache.size();
            cache.cleanUp();
            log.info("Clean {} cache finished. Size before {} and after {}", new Object[]{this.getDriverType(), cacheSizeBefore, cache.size()});
        }, 0L, timeout, TimeUnit.MILLISECONDS);
    }

    public long poolSize();
}

