/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.gridfs;

import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.repo.gridfs.GridFsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class GridFsRepositoryImpl
implements GridFsRepository {
    private static final Logger log = LoggerFactory.getLogger(GridFsRepositoryImpl.class);
    private final GridFSBucket gridFsBucket;
    @Value(value="${gridfs.clean.period.days:14}")
    private long daysToClean;

    @Override
    public void cleanDb() {
        long dayInMs = 86400000L;
        Date dateDaysAgo = new Date(System.currentTimeMillis() - this.daysToClean * dayInMs);
        this.gridFsBucket.find().filter(Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.in((String)"metadata.fileType", (Object[])new String[]{ProjectFileType.MIA_FILE_TYPE_LOG.toString(), ProjectFileType.MIA_FILE_TYPE_UPLOAD.toString()}), Filters.in((String)"metadata.type", (Object[])new String[]{"log"})}), Filters.lt((String)"uploadDate", (Object)dateDaysAgo)})).map(GridFSFile::getId).forEach(arg_0 -> ((GridFSBucket)this.gridFsBucket).delete(arg_0));
    }

    @Override
    public boolean exist(ProjectFile projectFile) {
        log.debug("Check file '{}' exist", (Object)projectFile);
        return this.gridFsBucket.find(Filters.eq((String)"_id", (Object)new ObjectId(projectFile.getGridFsObjectId()))).first() != null;
    }

    @Override
    public void findAndDeleteObsoleteProjectFiles(UUID projectId, List<String> excludeIds) {
        log.debug("Find all project files for project '{}'", (Object)projectId);
        this.gridFsBucket.find().filter(Filters.and((Bson[])new Bson[]{Filters.eq((String)"metadata.fileType", (Object)ProjectFileType.MIA_FILE_TYPE_PROJECT.toString()), Filters.eq((String)"metadata.projectId", (Object)projectId.toString()), Filters.nin((String)"_id", excludeIds)})).forEach(f -> {
            if (!excludeIds.contains(f.getObjectId().toString())) {
                this.gridFsBucket.delete(f.getObjectId());
            }
        });
    }

    @Override
    public Optional<InputStream> get(FileMetaData fileData) {
        log.debug("Getting file {}", (Object)fileData.getFileName());
        GridFSFile file = this.getGridFsFile(fileData);
        if (file == null) {
            return Optional.empty();
        }
        return Optional.of(this.gridFsBucket.openDownloadStream(file.getId()));
    }

    @Override
    public Optional<GridFSFile> getById(String gridFsObjectId) {
        if (Objects.nonNull(gridFsObjectId)) {
            log.debug("Getting file byId {}", (Object)gridFsObjectId);
            GridFSFile file = (GridFSFile)this.gridFsBucket.find(Filters.eq((String)"_id", (Object)new ObjectId(gridFsObjectId))).first();
            if (Objects.nonNull(file)) {
                try (GridFSDownloadStream ds = this.gridFsBucket.openDownloadStream(file.getId());){
                    Optional<GridFSFile> optional = Optional.of(ds.getGridFSFile());
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public String getCollectionsSize(UUID projectId) {
        ArrayList lengths = new ArrayList();
        if (projectId == null) {
            this.gridFsBucket.find().forEach(file -> lengths.add(file.getLength()));
        } else {
            this.gridFsBucket.find((Bson)new Document().append("projectId", (Object)projectId)).forEach(file -> lengths.add(file.getLength()));
        }
        return String.format("Amount of documents %s, Size: %s byte", lengths.size(), lengths.stream().reduce(0L, Long::sum));
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public void removeFile(FileMetaData fileData) {
        log.warn("Removing file {}", (Object)fileData.getFileName());
        GridFSFile res = this.getGridFsFile(fileData);
        if (res != null) {
            this.gridFsBucket.delete(res.getObjectId());
        }
    }

    @Override
    public void removeFile(ObjectId objectId) {
        this.gridFsBucket.delete(objectId);
    }

    @Override
    public void rename(ProjectFile projectFile) {
        log.debug("Rename file '{}'", (Object)projectFile);
        this.gridFsBucket.rename(new ObjectId(projectFile.getGridFsObjectId()), Paths.get(ProjectFileType.MIA_FILE_TYPE_PROJECT.name(), new String[0]).resolve(projectFile.getPathFile()).toString());
    }

    @Override
    public ObjectId save(FileMetaData fileData, InputStream fis) {
        log.debug("Saving file {} ", (Object)fileData);
        Optional.ofNullable((GridFSFile)this.gridFsBucket.find(this.queryToFind(fileData)).first()).ifPresent(f -> this.gridFsBucket.delete(f.getId()));
        GridFSUploadOptions uploadOptions = this.buildOptions(this.getDocument(fileData));
        return this.gridFsBucket.uploadFromStream(fileData.getFileName(), fis, uploadOptions);
    }

    private GridFSUploadOptions buildOptions(Document document) {
        return new GridFSUploadOptions().chunkSizeBytes(Integer.valueOf(1024)).metadata(document);
    }

    private Document getDocument(FileMetaData fileData) {
        Document document = new Document().append("projectId", (Object)fileData.getProjectId().toString()).append("fileType", (Object)fileData.getProjectFileType().name()).append("uploadDate", (Object)LocalDateTime.now().toString()).append("extension", (Object)fileData.getFileExtension()).append("contentType", (Object)fileData.getContentType());
        return document;
    }

    private GridFSFile getGridFsFile(FileMetaData fileData) {
        log.debug("Getting fs file {}", (Object)fileData.getFileName());
        return (GridFSFile)this.gridFsBucket.find(this.queryToFind(fileData)).first();
    }

    private Bson queryToFind(FileMetaData fileData) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"metadata.projectId", (Object)fileData.getProjectId().toString()), Filters.eq((String)"metadata.fileType", (Object)fileData.getProjectFileType().name()), Filters.eq((String)"filename", (Object)fileData.getFileName())});
    }

    @Override
    public byte[] getFileContent(GridFSFile file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.gridFsBucket.downloadToStream(file.getObjectId(), (OutputStream)bos);
        return bos.toByteArray();
    }

    public GridFsRepositoryImpl(GridFSBucket gridFsBucket) {
        this.gridFsBucket = gridFsBucket;
    }
}

