/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.qubership.atp.mia.exceptions.MiaException;
import org.qubership.atp.mia.exceptions.responseerrors.CantParseExpectedCodeException;
import org.qubership.atp.mia.exceptions.responseerrors.CodeNotPresentWhenFlagOnException;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.impl.output.MarkedContent;
import org.qubership.atp.mia.model.pot.Marker;
import org.qubership.atp.mia.model.pot.ProcessStatus;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class ProcessStatusRepository {
    private static final Logger log = LoggerFactory.getLogger(ProcessStatusRepository.class);
    private final MiaContext miaContext;
    @Value(value="${response.file.size.limit.bytes:1000000}")
    private Long limitSizeBytes;

    public void parseLogMarkers(ProcessStatus processStatus, Command command) {
        if (command.getMarker() != null) {
            processStatus.setMarker(command.getMarker());
            Marker marker = processStatus.getMarker();
            if (marker.getPassedMarkerForLog() != null) {
                marker.setPassedMarkerForLog(marker.getPassedMarkerForLog().stream().map(m -> this.miaContext.evaluate((String)m)).collect(Collectors.toList()));
            }
            if (marker.getFailedMarkersForLog() != null) {
                marker.setFailedMarkersForLog(marker.getFailedMarkersForLog().stream().map(m -> this.miaContext.evaluate((String)m)).collect(Collectors.toList()));
            }
            if (marker.getWarnMarkersForLog() != null) {
                marker.setWarnMarkersForLog(marker.getWarnMarkersForLog().stream().map(m -> this.miaContext.evaluate((String)m)).collect(Collectors.toList()));
            }
        }
    }

    public void parseLogStatus(ExecutionResponse executionResponse) {
        this.parseLogStatus(executionResponse, this.miaContext.getConfig().getCommonConfiguration().getLinesAmount());
    }

    public void parseLogStatus(ExecutionResponse executionResponse, int linesAmount) {
        Marker marker = executionResponse.getProcessStatus().getMarker();
        if (executionResponse.getCommandResponse() != null && executionResponse.getCommandResponse().getCommandOutputs() != null && executionResponse.getCommandResponse().getCommandOutputs().size() > 0) {
            boolean isFirst = true;
            for (CommandOutput logCommandOutput : executionResponse.getCommandResponse().getCommandOutputs()) {
                try {
                    if (marker != null) {
                        log.info("Add log Status on entry marker is: [{}]", (Object)marker);
                        LinkedList<String> content = logCommandOutput.contentFromFile();
                        logCommandOutput.setMarkedContent(new LinkedList<MarkedContent>());
                        for (String s : content) {
                            Statuses statuses = marker.checkLineForMarker(s);
                            if (statuses.equals((Object)Statuses.UNKNOWN)) continue;
                            logCommandOutput.addContent(s, statuses);
                        }
                    }
                }
                catch (MiaException e) {
                    this.handlerFileNotFoundErr(executionResponse, logCommandOutput, linesAmount, e);
                }
                if (logCommandOutput.getMarkedContent().size() == 0) {
                    logCommandOutput.saveLatestLineToContent(linesAmount, this.limitSizeBytes);
                }
                if (isFirst) {
                    this.checkContentAndGetNewStatus(logCommandOutput, executionResponse, marker);
                }
                isFirst = false;
            }
        }
    }

    private void checkContentAndGetNewStatus(CommandOutput logOutput, ExecutionResponse res, Marker marker) {
        MiaException error = res.getError();
        Statuses oldStatus = res.getProcessStatus().getStatus();
        Statuses newStatus = null;
        if (logOutput.containsMarkedContentWithState(Statuses.FAIL)) {
            log.info("Set process status FAIL: found FAIL marker");
            newStatus = Statuses.FAIL;
        } else if (logOutput.containsMarkedContentWithState(Statuses.WARNING) && !oldStatus.equals((Object)Statuses.FAIL)) {
            log.info("Set process status WARNING: found warning marker");
            newStatus = Statuses.WARNING;
        } else if (logOutput.containsMarkedContentWithState(Statuses.SUCCESS) && !oldStatus.equals((Object)Statuses.FAIL) && !oldStatus.equals((Object)Statuses.WARNING)) {
            log.info("Set process status SUCCESS: found passed marker");
            newStatus = Statuses.SUCCESS;
        }
        if (marker != null && marker.getPassedMarkerForLog() != null && marker.getPassedMarkerForLog().size() > 0 && marker.isFailWhenNoPassedMarkersFound() && !logOutput.containsMarkedContentWithState(Statuses.SUCCESS) && !oldStatus.equals((Object)Statuses.FAIL)) {
            String errMsg = "passed markers not found and \"Fail when No Passed Markers Found\" flag is true";
            log.info("Set process status FAIL: {}", (Object)errMsg);
            error = new MiaException(errMsg);
            newStatus = Statuses.FAIL;
        }
        res.getProcessStatus().setStatus(newStatus == null ? oldStatus : newStatus);
        res.setError(error);
    }

    private void handlerFileNotFoundErr(ExecutionResponse executionResponse, CommandOutput logCommandOutput, int linesAmount, MiaException e) {
        String expected = ErrorCodes.MIA_2053_READ_FAIL_FILE_NOT_FOUND.getCode();
        if (e.getMessage().contains(expected)) {
            try {
                boolean isContentEmpty;
                LinkedList<MarkedContent> content = executionResponse.getCommandResponse().getCommandOutputs().getFirst().getMarkedContent();
                boolean bl = isContentEmpty = content == null || content.isEmpty();
                if (!isContentEmpty) {
                    return;
                }
            }
            catch (NullPointerException ignore) {
                log.debug("content is empty, accessing last line [npe = {}]", (Object)e.getMessage());
            }
        } else {
            throw e;
        }
        logCommandOutput.saveLatestLineToContent(linesAmount, this.limitSizeBytes);
    }

    public void parseReturnCodeAndUpdateStatus(ExecutionResponse response) {
        if (response.getCommandResponse().isCheckStatusCodeFlag()) {
            List<String> codes = response.getCommandResponse().getExpectedCodes();
            String statusCode = response.getCommandResponse().getStatusCode();
            if (codes != null && codes.size() > 0) {
                boolean matches = false;
                for (String code : codes) {
                    if (code.contains("*")) {
                        code = code.replaceAll("\\*", "\\\\d");
                    }
                    try {
                        if (!statusCode.matches(code)) continue;
                        matches = true;
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        throw new CantParseExpectedCodeException();
                    }
                }
                if (!matches) {
                    if (response.getProcessStatus() == null) {
                        response.setProcessStatus(new ProcessStatus());
                    }
                    response.getProcessStatus().setStatus(Statuses.FAIL);
                }
            } else {
                throw new CodeNotPresentWhenFlagOnException();
            }
        }
    }

    public ProcessStatusRepository(MiaContext miaContext) {
        this.miaContext = miaContext;
    }

    public void setLimitSizeBytes(Long limitSizeBytes) {
        this.limitSizeBytes = limitSizeBytes;
    }
}

