/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import clover.org.apache.commons.lang.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.qubership.atp.mia.exceptions.rest.RestCopyResultToStringException;
import org.qubership.atp.mia.exceptions.rest.RestCreateConnectionFailException;
import org.qubership.atp.mia.exceptions.rest.RestNotFoundException;
import org.qubership.atp.mia.exceptions.rest.RestParseErrorException;
import org.qubership.atp.mia.model.ContentType;
import org.qubership.atp.mia.model.environment.Connection;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.Rest;
import org.qubership.atp.mia.model.impl.executable.RestLoopParameters;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.execution.RestClientService;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.FileUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class RestRepository {
    private static final Logger log = LoggerFactory.getLogger(RestRepository.class);
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final TypeReference<DbTable> TYPE_REF_DB_TABLE = new TypeReference<DbTable>(){};
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final MiaContext miaContext;
    private final RestClientService restClient;
    private final MetricsAggregateService metricsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResponse sendRestRequest(Command command) {
        Server server;
        if (command.getRest() == null) {
            throw new RestNotFoundException();
        }
        log.info("Sending REST request");
        System system = this.miaContext.getFlowData().getSystem(command.getSystem());
        try {
            server = system.getServer("REST");
        }
        catch (IllegalArgumentException e1) {
            try {
                server = system.getServer(Connection.SourceTemplateId.HTTP);
            }
            catch (IllegalArgumentException e2) {
                throw new RestCreateConnectionFailException(e2);
            }
        }
        HashMap<String, String> connectionInfo = new HashMap<String, String>();
        Rest rest = command.getRest();
        RestLoopParameters restLoopParameters = rest.getRestLoopParameters();
        if (restLoopParameters != null && !Strings.isNullOrEmpty((String)restLoopParameters.getTextToCheck())) {
            restLoopParameters.setTextToCheck(this.miaContext.evaluate(restLoopParameters.getTextToCheck()));
        }
        log.info("Preparing REST client for project: {}", (Object)this.miaContext.getProjectId());
        HttpClient client = this.restClient.prepareRestClient(server, rest.isDisableRedirect(), connectionInfo);
        HttpRequestBase request = this.restClient.prepareRestRequest(rest, server, connectionInfo);
        connectionInfo.put("timestampRequest", Utils.getTimestamp());
        HttpResponse httpResponse = this.restClient.executeRestRequest(client, request);
        boolean textChecked = true;
        Map.Entry<File, String> responseBody = this.getResponseBody(command, httpResponse);
        if (responseBody.getValue() != null) {
            textChecked = this.checkForText(restLoopParameters, responseBody.getValue(), httpResponse.getAllHeaders());
        }
        int retryCount = 0;
        if (!textChecked && restLoopParameters != null && restLoopParameters.getMaxNumberRepeats() >= 0 && restLoopParameters.getTimeoutRepeats() > 0) {
            for (int repeatId = 0; repeatId < restLoopParameters.getMaxNumberRepeats(); ++repeatId) {
                try {
                    Thread.sleep((long)restLoopParameters.getTimeoutRepeats() * 1000L);
                }
                catch (InterruptedException e) {
                    log.error("restLoopParameters timeout error.", (Throwable)e);
                }
                httpResponse = this.restClient.executeRestRequest(client, request);
                responseBody = this.getResponseBody(command, httpResponse);
                if (responseBody.getValue() != null) {
                    textChecked = this.checkForText(restLoopParameters, responseBody.getValue(), httpResponse.getAllHeaders());
                }
                ++retryCount;
                if (textChecked) break;
            }
            String pollingInfo = "ReTried Count : " + retryCount + " / " + restLoopParameters.getMaxNumberRepeats() + "\n Status : " + (textChecked ? "PASSED" : "FAILED") + "\n TimeOut of Repeats : " + restLoopParameters.getTimeoutRepeats() * retryCount + " Seconds\n Text to Check : " + restLoopParameters.getTextToCheck();
            connectionInfo.put("pollingStatus", pollingInfo);
        }
        connectionInfo.put("timestampResponse", Utils.getTimestamp());
        connectionInfo.put("code", String.valueOf(httpResponse.getStatusLine().getStatusCode()));
        StringJoiner headerResponse = new StringJoiner("\n");
        Arrays.stream(httpResponse.getAllHeaders()).forEach(h -> headerResponse.add(h.toString()));
        connectionInfo.put("headersResponse", headerResponse.toString());
        if (rest.isSaveCookie()) {
            Arrays.stream(httpResponse.getAllHeaders()).forEach(header -> {
                if (header.getName().contains("Cookie")) {
                    this.miaContext.getFlowData().addParameter("Cookie", header.getValue());
                    log.info("Cookie is saved to flow data [ " + header.getValue() + " ].");
                }
            });
        }
        CommandOutput commandOutput = new CommandOutput(responseBody.getKey().getPath(), null, ContentType.getType(Utils.getHeaderValue(httpResponse, HEADER_CONTENT_TYPE)).isDisplay(), this.miaContext);
        CommandResponse commandResponse = new CommandResponse();
        commandResponse.addLog(commandOutput);
        commandResponse.setConnectionInfo(connectionInfo);
        if (!textChecked) {
            commandResponse.addError(new IllegalArgumentException(String.format("Text '%s' defined but not found", restLoopParameters == null ? "null_value" : restLoopParameters.getTextToCheck())));
        }
        if (rest.isParseResponseAsTable()) {
            try {
                String commandOutputContent = commandOutput.contentFromFile().toString();
                JsonNode node = MAPPER.readTree(commandOutputContent.substring(1, commandOutputContent.length() - 1));
                if (node.has("table") && node.get("table").has("columns") && node.get("table").has("data")) {
                    SqlResponse sqlResponse = new SqlResponse();
                    DbTable table = (DbTable)MAPPER.convertValue((Object)node.get("table"), TYPE_REF_DB_TABLE);
                    if (table.getData() == null) {
                        table.setData(new ArrayList<List<String>>());
                    }
                    if (table.getColumns() == null) {
                        table.setColumns(new ArrayList<String>());
                    }
                    sqlResponse.setData(table);
                    if (rest.isHasFile() && node.has("file")) {
                        String file = node.get("file").asText();
                        sqlResponse.setLink(new Link(file, Utils.getFileNameFromPath(file)));
                    }
                    commandResponse.setSqlResponse(sqlResponse);
                }
            }
            catch (IOException e) {
                log.error("Exception during parse response as table: {}", (Object)e.getMessage());
                commandResponse.addError(e);
            }
        }
        commandResponse.setPostScriptExecutionReport(this.executeScript(rest, httpResponse, responseBody.getValue(), command.getName()));
        try {
            connectionInfo.put("postScript", rest.getScript());
            connectionInfo.put("postScriptResults", commandResponse.getPostScriptExecutionReport());
            connectionInfo.put("bodyResponse", responseBody.getValue());
            File fileFullInfo = this.miaContext.getLogPath().resolve(this.miaContext.createLogFileName("REST_FULL_INFO", "json")).toFile();
            FileUtils.logIntoFile(Utils.GSON.toJson(connectionInfo), fileFullInfo);
            CommandOutput commandFullInfo = new CommandOutput(fileFullInfo.getPath(), null, false, this.miaContext);
            commandResponse.addCommandOutput(commandFullInfo);
        }
        finally {
            connectionInfo.remove("postScript");
            connectionInfo.remove("postScriptResults");
            connectionInfo.remove("bodyResponse");
        }
        return commandResponse;
    }

    public String executeScript(Rest rest, HttpResponse httpResponse, String responseBody, String processName) {
        String script;
        log.trace("Start executing post script of {} process", (Object)processName);
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("Nashorn");
        if (engine == null) {
            return String.format("%s can't define OpenJDK Nashorn script engine.", "Error");
        }
        engine.put("request", rest);
        engine.put("response", httpResponse);
        engine.put("globalVariables", this.miaContext.getFlowData().getParameters());
        engine.put("collectionVariables", new HashMap());
        if (responseBody != null) {
            Object parsedResponse = this.parseResponse(new ObjectMapper(), responseBody.trim());
            engine.put("responseBody", parsedResponse);
        }
        if (StringUtils.isNotEmpty((String)(script = rest.getScript()))) {
            try {
                engine.eval(script);
                HashMap result = (HashMap)engine.eval("collectionVariables;");
                result.keySet().forEach(k -> {
                    block2: {
                        try {
                            Object v = result.get(k);
                        }
                        catch (ClassCastException cce) {
                            if (!cce.getMessage().contains("jdk.nashorn.internal.runtime.Undefined")) break block2;
                            result.put(k, "");
                        }
                    }
                });
                this.miaContext.getFlowData().addParameters(result);
                return "Post script has been successfully executed";
            }
            catch (ScriptException e) {
                log.trace("{} in script execution: {}", (Object)"Error", (Object)e.getMessage());
                return String.format("%s in script: %s", "Error", e.getMessage());
            }
            catch (Exception e) {
                log.trace("{} in script execution: {}", (Object)"Error", (Object)e.getMessage());
                return String.format("%s something went wrong when adding the result to global variables: %s", "Error", e.getMessage());
            }
        }
        return "";
    }

    private Object parseResponse(ObjectMapper mapper, String responseBody) {
        try {
            return mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException mapException) {
            log.debug("Unable to parse responseBody as map, trying as list: {}", (Object)mapException.getMessage());
            try {
                return mapper.readValue(responseBody, (TypeReference)new TypeReference<List<Object>>(){});
            }
            catch (JsonProcessingException listException) {
                log.debug("Unable to parse responseBody as list: {}", (Object)listException.getMessage());
                log.info("Using raw responseBody string as JSON parsing failed");
                return responseBody;
            }
        }
    }

    boolean checkForText(RestLoopParameters loopParameters, String responseBody, Header[] headers) {
        boolean textChecked = true;
        if (loopParameters != null && !Strings.isNullOrEmpty((String)loopParameters.getTextToCheck())) {
            boolean bl = textChecked = loopParameters.isCheckTextInBody() && responseBody != null && responseBody.contains(loopParameters.getTextToCheck());
            if (!textChecked) {
                textChecked = loopParameters.isCheckTextInHeaders() && headers != null && Arrays.stream(headers).anyMatch(h -> h.toString().contains(loopParameters.getTextToCheck()));
            }
        }
        return textChecked;
    }

    protected Map.Entry<File, String> getResponseBody(Command command, HttpResponse httpResponse) {
        File file;
        String stringBody;
        block10: {
            stringBody = null;
            ContentType contentType = ContentType.getType(Utils.getHeaderValue(httpResponse, HEADER_CONTENT_TYPE));
            Path filename = command.getLogFileNameFormat() != null ? Paths.get(StringUtils.deleteWhitespace((String)this.miaContext.evaluate(command.getLogFileNameFormat())), new String[0]) : (Utils.isHeaderNamePresent(httpResponse, HEADER_CONTENT_DISPOSITION) && Utils.getFirstGroupFromStringByRegexp(Utils.getHeaderValue(httpResponse, HEADER_CONTENT_DISPOSITION), "filename=(.*)") != null ? Paths.get(Utils.getFirstGroupFromStringByRegexp(Utils.getHeaderValue(httpResponse, HEADER_CONTENT_DISPOSITION), "filename=(.*)").replaceAll("\"", ""), new String[0]) : Paths.get(this.miaContext.createFileName(contentType), new String[0]));
            file = this.miaContext.getLogPath().resolve(filename.getFileName()).toFile();
            try (FileOutputStream outStream = new FileOutputStream(file);){
                HttpEntity entity = httpResponse.getEntity();
                if (entity == null) break block10;
                entity.writeTo((OutputStream)outStream);
                long restResponseSizeInKb = file.length() / 1024L;
                log.info("[SIZE] REST Response length: {} kb", (Object)restResponseSizeInKb);
                this.metricsService.restResponseSize(restResponseSizeInKb);
                log.debug("File with response created, path: " + file.getPath());
                try {
                    if (contentType.isTextFormat()) {
                        stringBody = org.apache.commons.io.FileUtils.readFileToString((File)file);
                    }
                }
                catch (IOException e) {
                    throw new RestCopyResultToStringException(!file.exists(), e);
                }
            }
            catch (Exception e) {
                throw new RestParseErrorException(e);
            }
        }
        return new AbstractMap.SimpleEntry<File, Object>(file, stringBody);
    }

    public RestRepository(MiaContext miaContext, RestClientService restClient, MetricsAggregateService metricsService) {
        this.miaContext = miaContext;
        this.restClient = restClient;
        this.metricsService = metricsService;
    }
}

