/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.xml.ws.Holder;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.FlowData;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.repo.impl.SshConnectionManager;
import org.qubership.atp.mia.repo.impl.SshConnectionResponse;
import org.qubership.atp.mia.repo.impl.pool.ssh.ConnectionPool;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class ShellRepository {
    private static final Logger log = LoggerFactory.getLogger(ShellRepository.class);
    private static final String INTERACTIVE_FORMAT = "%s > %s 2>&1";
    public final String genevaParamKey = "exportGenevaDate";
    private final MiaContext miaContext;
    private final ConnectionPool sshServerPool;
    private final MetricsAggregateService metricsService;

    private static String getRightsMsg(File internalDir) {
        return String.format("Local directory %s read rights and %s write rights", internalDir.canRead() ? "has" : "doesn't have", internalDir.canWrite() ? "has" : "doesn't have");
    }

    public void transferFileOnServer(Command command, String pathToFile, String pathToUpLoad) {
        this.getSshConnection(this.getServer(command), man -> man.transferFileOnServer(pathToFile, pathToUpLoad));
    }

    public void uploadFileOnServer(Server server, String pathToUpLoad, File file) {
        String workDir = this.miaContext.getFlowData().getCustom(Constants.CustomParameters.WORKING_DIRECTORY, this.miaContext);
        this.getSshConnection(server, man -> man.uploadFileOnServer(file, pathToUpLoad, workDir));
    }

    public CommandOutput getFileOnServer(Command command, String pathToFile, boolean isDisplayed) {
        CommandOutput output;
        Holder file = new Holder();
        String errorMessage = "";
        Server server = this.getServer(command);
        try {
            this.getSshConnection(server, ssh -> {
                file.value = ssh.getFileFromServer(pathToFile, this.miaContext.getFlowData().getCustom(Constants.CustomParameters.WORKING_DIRECTORY, this.miaContext));
            });
        }
        catch (Exception e) {
            log.error("Can't get file on server. ProcessName: {},  Server: {}, Command: {}, filePath: {}, Message: {}", new Object[]{this.miaContext.getFlowData().getCustom(Constants.CustomParameters.PROCESS_NAME, this.miaContext), server.toString(), command.getToExecute(), pathToFile, e.getMessage(), e});
            errorMessage = e.getMessage();
        }
        if (file.value != null) {
            long fileSizeInKb = ((File)file.value).length() / 1024L;
            log.info("[SIZE] Downloaded file size : {} kb", (Object)fileSizeInKb);
            this.metricsService.requestSshDownloadFileSize(fileSizeInKb);
            output = new CommandOutput(((File)file.value).getPath(), pathToFile, isDisplayed, this.miaContext);
        } else {
            output = this.fileNotFound(this.miaContext.getLogPath().toString(), pathToFile, errorMessage);
        }
        return output;
    }

    private String updateCommand(String logFileName, String commandValue, String system) {
        StringJoiner command = new StringJoiner(this.miaContext.getConfig().getCommonConfiguration().getCommandShellSeparator());
        Map<String, String> params = this.miaContext.getFlowData().getParameters();
        this.checkExportGenevaDateIsValid(params);
        this.miaContext.getShellPrefixes(system).forEach((k, prefixValue) -> {
            String param;
            prefixValue = this.miaContext.evaluate((String)prefixValue, params);
            String prefixKey = k.toLowerCase();
            if (prefixKey.startsWith("always")) {
                command.add((CharSequence)prefixValue);
            } else if (params.containsKey(k) && (param = (String)params.get(k)) != null && !param.isEmpty() && !param.equals("false")) {
                command.add(String.format(prefixValue, params.get(k)));
            }
        });
        command.add(String.format(INTERACTIVE_FORMAT, this.miaContext.evaluate(commandValue, params), logFileName));
        return command.toString();
    }

    public Server getServer(Command command) {
        return this.miaContext.getFlowData().getSystem(command.getSystem()).getServer(Server.ConnectionType.SSH);
    }

    private void checkExportGenevaDateIsValid(Map<String, String> params) {
        if (params.containsKey("exportGenevaDate")) {
            boolean isExportGenevaInvalid;
            String param = params.get("exportGenevaDate");
            boolean bl = isExportGenevaInvalid = param == null || param.isEmpty() || !param.equals("true");
            if (isExportGenevaInvalid) {
                log.warn("Command has incorrect value of genevaParamKey [{}], removing it from parameters", (Object)"exportGenevaDate");
                params.remove("exportGenevaDate");
            }
        }
    }

    private static void addResponseTextToError(CommandOutput logFile, String command, String sshOutput) {
        boolean commandIsNotEmpty = org.apache.logging.log4j.util.Strings.isNotEmpty((CharSequence)command);
        if (commandIsNotEmpty && !logFile.getMarkedContent().isEmpty() && org.apache.logging.log4j.util.Strings.isNotEmpty((CharSequence)sshOutput)) {
            logFile.addContent("------------------------------\n", Statuses.FAIL);
            logFile.addContent("Ssh part of execution response\n", Statuses.FAIL);
            String cutCommand = command.split("\n")[0];
            int maxSize = 20;
            boolean toTakeElements = false;
            Iterator it = Arrays.stream(sshOutput.split("\n")).iterator();
            while (it.hasNext() && logFile.getMarkedContent().size() < maxSize) {
                String line = (String)it.next();
                if (line.contains(cutCommand)) {
                    toTakeElements = true;
                } else if (line.contains("STOP")) {
                    toTakeElements = false;
                }
                if (!toTakeElements) continue;
                logFile.addContent(line, Statuses.FAIL);
            }
        }
    }

    public CommandResponse executeAndGetLog(Command command) {
        Server server = this.getServer(command);
        FlowData flowData = this.miaContext.getFlowData();
        flowData.addParameters(server.getProperties());
        String fileName = this.miaContext.createLogFileName(command);
        String logFileName = this.miaContext.evaluate(FileUtils.tempFileName(flowData.getCustom(Constants.CustomParameters.WORKING_DIRECTORY, this.miaContext), fileName));
        CommandResponse commandResponse = new CommandResponse();
        String updatedCommand = this.updateCommand(logFileName, command.getToExecute(), command.getSystem());
        Holder output = new Holder(null);
        SshConnectionResponse sshResponse = this.getSshConnection(server, man -> {
            output.value = man.runCommand(updatedCommand);
        });
        commandResponse.setCommand(sshResponse.getExecutedCommand());
        commandResponse.setConnectionInfo(sshResponse.connectionInfo());
        if (commandResponse.getErrors() == null || commandResponse.getErrors().size() < 1) {
            CommandOutput logFile = this.getFileOnServer(command, logFileName, true);
            ShellRepository.addResponseTextToError(logFile, command.getToExecute(), (String)output.value);
            commandResponse.concatCommandOutput(logFile);
        }
        return commandResponse;
    }

    public CommandOutput fileNotFound(@NotNull String internalPathToFile, String externalPathToFile, String errorMessage) {
        log.error("SSH download fail, internal path: {}, external path: {}, error message: {}", new Object[]{internalPathToFile, externalPathToFile, errorMessage});
        ArrayList<String> errors = new ArrayList<String>();
        errors.add("SSH download failed. External path : " + externalPathToFile);
        errors.add("Local directory path: " + internalPathToFile);
        File internalDir = new File(internalPathToFile);
        if (internalDir.exists()) {
            if (!internalDir.isDirectory()) {
                if (internalDir.canRead() && internalDir.canWrite()) {
                    errors.add("Error! Make sure that Remote file exists on server: " + externalPathToFile);
                } else {
                    errors.add(ShellRepository.getRightsMsg(internalDir));
                }
            } else {
                errors.add("Local path :" + internalPathToFile + " is a Directory and not a file");
            }
        } else {
            errors.add("Local directory not created!");
            errors.add(ShellRepository.getRightsMsg(internalDir));
        }
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            errors.add("Error message: " + errorMessage);
        }
        return new CommandOutput(internalPathToFile, externalPathToFile, errors, true, this.miaContext);
    }

    private SshConnectionResponse getSshConnection(Server server, Consumer<SshConnectionManager> consumer) {
        String prefix = this.miaContext.getExternalPrefix();
        SshConnectionManager sshConnection = this.sshServerPool.getConnection(server, prefix);
        consumer.accept(sshConnection);
        return new SshConnectionResponse(sshConnection);
    }

    public void resetCache() {
        this.sshServerPool.resetCache();
    }

    public ShellRepository(MiaContext miaContext, ConnectionPool sshServerPool, MetricsAggregateService metricsService) {
        this.miaContext = miaContext;
        this.sshServerPool = sshServerPool;
        this.metricsService = metricsService;
    }
}

