/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.qubership.atp.mia.exceptions.soap.SoapCreateConnectionFailException;
import org.qubership.atp.mia.exceptions.soap.SoapCreateRequestFailException;
import org.qubership.atp.mia.exceptions.soap.SoapExecutionFailException;
import org.qubership.atp.mia.exceptions.soap.SoapGetInstanceFailException;
import org.qubership.atp.mia.exceptions.soap.SoapWriteIoException;
import org.qubership.atp.mia.exceptions.soap.SoapWriteOutputFailException;
import org.qubership.atp.mia.model.environment.Connection;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.environment.System;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.Soap;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.CryptoUtils;
import org.qubership.atp.mia.utils.FileUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class SoapRepository {
    private static final Logger log = LoggerFactory.getLogger(SoapRepository.class);
    private final MiaContext miaContext;
    private final MetricsAggregateService metricsService;

    private static SOAPMessage createSoapRequest(Soap soap) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(soap.getRequest().getBytes());
            SOAPMessage soapMessage = MessageFactory.newInstance().createMessage(null, (InputStream)is);
            log.info("Request SOAP Message was created");
            log.debug(soap.getRequest());
            return soapMessage;
        }
        catch (SOAPException e) {
            throw new SoapGetInstanceFailException(e);
        }
        catch (IOException e) {
            throw new SoapCreateRequestFailException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResponse sendSoapRequest(Command command) {
        log.info("Sending SOAP request");
        try {
            Server server;
            System system = this.miaContext.getFlowData().getSystem(command.getSystem());
            try {
                server = system.getServer(Server.ConnectionType.HTTP);
            }
            catch (IllegalArgumentException e1) {
                try {
                    server = system.getServer(Connection.SourceTemplateId.HTTP);
                }
                catch (IllegalArgumentException e2) {
                    throw new SoapCreateConnectionFailException(e2);
                }
            }
            Map<String, String> serverParams = server.getConnection().getParameters();
            HashMap<String, String> connectionInfo = new HashMap<String, String>();
            String url = serverParams.get("url") + this.miaContext.evaluate(command.getSoap().getEndpoint());
            String login = serverParams.get("login");
            connectionInfo.put("user", login);
            connectionInfo.put("endpoint", url);
            connectionInfo.put("bodyRequest", command.getSoap().getRequest());
            SOAPMessage soapRequest = SoapRepository.createSoapRequest(command.getSoap());
            MimeHeaders hd = soapRequest.getMimeHeaders();
            String authorization = Base64.getEncoder().encodeToString((login + ":" + CryptoUtils.decryptValue(serverParams.get("password"))).getBytes());
            hd.addHeader("Authorization", "Basic " + authorization);
            hd.addHeader("SOAPAction", "");
            connectionInfo.put("timestampRequest", Utils.getTimestamp());
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = soapConnection.call(soapRequest, (Object)url);
            log.info("Response SOAP Message was got");
            soapConnection.close();
            File logFile = this.miaContext.getLogPath().resolve(this.miaContext.createLogFileName(command)).toFile();
            CommandResponse commandResponse = new CommandResponse(new CommandOutput(this.createFileWithResponse(soapResponse, logFile), null, true, this.miaContext));
            commandResponse.setConnectionInfo(connectionInfo);
            connectionInfo.put("timestampResponse", Utils.getTimestamp());
            try {
                connectionInfo.put("bodyResponse", soapResponse.toString());
                File fileFullInfo = this.miaContext.getLogPath().resolve(this.miaContext.createLogFileName("SOAP_FULL_INFO", "json")).toFile();
                FileUtils.logIntoFile(Utils.GSON.toJson(connectionInfo), fileFullInfo);
                CommandOutput commandFullInfo = new CommandOutput(fileFullInfo.getPath(), null, false, this.miaContext);
                commandResponse.addCommandOutput(commandFullInfo);
            }
            finally {
                connectionInfo.remove("bodyResponse");
            }
            return commandResponse;
        }
        catch (SOAPException e) {
            throw new SoapExecutionFailException(e);
        }
    }

    private String createFileWithResponse(SOAPMessage response, File logFile) {
        log.info("Creating file with response: {}, logfile: {}", (Object)response, (Object)logFile);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            response.writeTo((OutputStream)out);
            int responseSize = out.size() / 1024;
            log.info("[SIZE] SOAP Response length: {} kb", (Object)responseSize);
            this.metricsService.soapResponseSize(responseSize);
            String responseString = out.toString();
            responseString = Utils.getPrettyStringFromXml(responseString).replaceFirst(">", ">\n");
            log.debug(responseString);
            Files.write(Paths.get(logFile.getPath(), new String[0]), responseString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SoapWriteIoException(e);
        }
        catch (SOAPException e) {
            throw new SoapWriteOutputFailException(e);
        }
        log.debug("File with response created, path: " + logFile.getPath());
        return logFile.getPath();
    }

    public SoapRepository(MiaContext miaContext, MetricsAggregateService metricsService) {
        this.miaContext = miaContext;
        this.metricsService = metricsService;
    }
}

