/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.repo.impl;

import clover.com.google.common.base.Strings;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshChannelCreateFailException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshChannelCreateInterruptionException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshChannelsBusyException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshCreateSessionException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshCreateSessionFailException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshRsaAddFailedException;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.environment.ConnectionProps;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.repo.impl.pool.ssh.ChannelType;
import org.qubership.atp.mia.repo.impl.pool.ssh.SshSessionPool;
import org.qubership.atp.mia.utils.CryptoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.retry.RetryException;

public class SshSession {
    private static final Logger log = LoggerFactory.getLogger(SshSession.class);
    private Session session;
    private final UUID sessionId = UUID.randomUUID();
    private final int retries = 2;
    private final AtomicInteger channelsCounter;
    private final AtomicInteger openChannels;
    private final ReentrantLock locker;
    private final Condition maximumChannels;
    private final JSch jsch;
    private final ConnectionProps properties;
    private String rsaFilePath;
    private boolean isIdentityAdded;

    public SshSession(Server server, CommonConfiguration configuration) {
        this.jsch = this.getJsch(configuration);
        this.properties = ConnectionProps.forSsh(server);
        this.channelsCounter = new AtomicInteger();
        this.openChannels = new AtomicInteger();
        this.locker = new ReentrantLock();
        this.maximumChannels = this.locker.newCondition();
        log.trace("{} created and has environment properties: {}.", (Object)this.sessionId, (Object)this.properties.fullInfo());
    }

    private JSch getJsch(CommonConfiguration configuration) {
        JSch jsch = new JSch();
        if (configuration != null && !Strings.isNullOrEmpty((String)configuration.getSshRsaFilePath())) {
            this.rsaFilePath = configuration.getSshRsaFilePath();
            try {
                jsch.addIdentity(configuration.getSshRsaFilePath());
                log.debug("RSA identity added");
            }
            catch (JSchException e) {
                throw new SshRsaAddFailedException(configuration.getSshRsaFilePath(), e);
            }
        }
        return jsch;
    }

    public Channel openChannel(ChannelType channelType) {
        this.locker.lock();
        try {
            if (!this.isConnected()) {
                this.createSession(1);
            }
            this.channelsCounter.incrementAndGet();
            Channel channel = this.openChannel(channelType, 1);
            return channel;
        }
        finally {
            this.channelsCounter.decrementAndGet();
            this.locker.unlock();
        }
    }

    private Channel openChannel(ChannelType channelType, int retryCount) {
        Channel ch = null;
        UUID channelId = UUID.randomUUID();
        try {
            log.trace("Open channels for session {}: {}/{}", new Object[]{this.sessionId, this.openChannels.get(), this.properties.getChannelsPerSession()});
            int i = 0;
            int timeout = this.properties.getTimeoutExecute() / 1000;
            while (this.openChannels.get() >= this.properties.getChannelsPerSession()) {
                log.warn("Maximum channels({}) per sessions ({}) achieved. Waiting for resolve to open channel {}", new Object[]{this.properties.getChannelsPerSession(), this.sessionId, channelId});
                if (this.maximumChannels.await(new Random().nextInt(100) + 900, TimeUnit.MILLISECONDS)) continue;
                log.error("Condition await failed for session with ID #{}", (Object)this.sessionId);
                if (i++ <= timeout) continue;
                throw new SshChannelsBusyException(timeout);
            }
            this.openChannels.incrementAndGet();
            try {
                log.trace("Free to open channel with ID {}", (Object)channelId);
                ch = this.session.openChannel(channelType.toString());
                if (ch == null || ch.isClosed()) {
                    String err = String.format("Can't open channel it %s", ch == null ? "is null" : (ch.isClosed() ? "is closed" : "unknown reason"));
                    throw new Exception(err);
                }
                log.debug("Channel with ID {} opened successfully", (Object)channelId);
            }
            catch (Exception e) {
                log.error("Can't open ssh channel with ID {}: {}", (Object)channelId, (Object)e.getMessage());
                if (retryCount++ >= 2) {
                    throw new SshChannelCreateFailException(channelId, e.getMessage());
                }
                log.debug("Retry open channel with ID {}", (Object)channelId);
                this.openChannel(channelType, retryCount);
            }
        }
        catch (InterruptedException e) {
            throw new SshChannelCreateInterruptionException(channelId, e.getMessage());
        }
        return ch;
    }

    public void closeChannel(Channel channel) {
        log.debug("Close channel for session {}", (Object)this.sessionId);
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
        log.debug("Open channels for session {}: {}/{}", new Object[]{this.sessionId, this.openChannels.decrementAndGet(), this.properties.getChannelsPerSession()});
    }

    public void createSession(int retryCount) {
        if (!this.isConnected()) {
            log.trace("Create a new session with {} in sshManager \u2116{}", (Object)this.properties, (Object)this.sessionId);
            try {
                this.addIdentity(this.jsch);
                this.session = this.jsch.getSession(this.properties.getUsername(), this.properties.getHostname(), this.properties.getPort());
                this.session.setServerAliveInterval(SshSessionPool.KEEP_ALIVE_MSG_INTERVAL);
                this.session.setConfig(this.getSessionConfig(this.session));
                this.session.setPassword(CryptoUtils.decryptValue(this.properties.getPassword()));
                this.session.setTimeout(this.properties.getTimeoutConnect());
                this.session.setServerAliveCountMax(Integer.MAX_VALUE);
                this.session.connect(this.properties.getTimeoutConnect());
                if (!this.session.isConnected()) {
                    throw new RetryException("Session is not connected after attempt.");
                }
                log.trace("Session created for {}", (Object)this.sessionId);
            }
            catch (RetryException e) {
                log.error("Session didn't open after connect {}. {}", (Object)this.sessionId, (Object)e.getMessage());
                if (retryCount++ >= 2) {
                    throw new SshCreateSessionFailException(this.properties, e.getMessage());
                }
                log.warn("Trying to reconnect the session {}", (Object)this.sessionId);
                this.createSession(retryCount);
            }
            catch (Exception e) {
                throw new SshCreateSessionException(this.properties.fullInfo(), e.getMessage());
            }
        }
    }

    private void addIdentity(JSch jsch) {
        if (!this.isIdentityAdded && !Strings.isNullOrEmpty((String)this.properties.getKey())) {
            byte[] key = CryptoUtils.decryptValue(this.properties.getKey()).getBytes(StandardCharsets.UTF_8);
            byte[] passphrase = Strings.isNullOrEmpty((String)this.properties.getPassphrase()) ? null : CryptoUtils.decryptValue(this.properties.getPassphrase()).getBytes(StandardCharsets.UTF_8);
            try {
                jsch.addIdentity("id_rsa", key, null, passphrase);
                this.isIdentityAdded = true;
                log.debug("id_rsa identity added");
            }
            catch (JSchException e) {
                throw new SshRsaAddFailedException("properties", e);
            }
        }
    }

    private Properties getSessionConfig(final Session session) {
        return new Properties(){
            {
                this.put("StrictHostKeyChecking", "no");
                this.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
                this.put("cipher.c2s", session.getConfig("cipher.c2s") + ",ssh-rsa,signature.dss");
                this.put("cipher.s2c", session.getConfig("cipher.s2c") + ",ssh-rsa,signature.dss");
                this.put("server_host_key", session.getConfig("server_host_key") + ",ssh-rsa,signature.dss");
                this.put("PubkeyAcceptedAlgorithms", session.getConfig("PubkeyAcceptedAlgorithms") + ",ssh-rsa,signature.dss");
                if (SshSession.this.properties.getSshServerKexAlgorithms() != null && SshSession.this.properties.getSshServerKexAlgorithms().trim().length() > 0) {
                    this.put("kex", SshSession.this.properties.getSshServerKexAlgorithms());
                }
            }
        };
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    @NonNull
    public ConnectionProps getProperties() {
        return this.properties;
    }

    public boolean disconnect() {
        log.debug("Trying to disconnect SSH connection [{}]", (Object)this.sessionId);
        boolean isDisconnected = false;
        if (this.isConnected()) {
            if (!this.isExecuting()) {
                this.session.disconnect();
                isDisconnected = true;
                log.info("Disconnect SSH connection {}, successfully [{}]", (Object)this.properties, (Object)this.sessionId);
            } else {
                log.debug("Session is executing.");
            }
        } else {
            log.debug("SSH connection null or just was disconnected, no action required.");
        }
        return isDisconnected;
    }

    public boolean isExecuting() {
        return this.channelsCounter.get() > 0 || this.openChannels.get() > 0;
    }

    public boolean isSame(Server server, CommonConfiguration configuration) {
        boolean propEq = Objects.equals(ConnectionProps.forSsh(server), this.properties);
        boolean rsaEq = configuration == null ? Strings.isNullOrEmpty((String)this.rsaFilePath) : (Strings.isNullOrEmpty((String)configuration.getSshRsaFilePath()) ? Strings.isNullOrEmpty((String)this.rsaFilePath) : !Strings.isNullOrEmpty((String)this.rsaFilePath));
        return propEq && rsaEq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshSession)) {
            return false;
        }
        SshSession that = (SshSession)o;
        return this.properties.equals(that.properties) && Objects.equals(this.isIdentityAdded, that.isIdentityAdded);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.isIdentityAdded);
    }

    public UUID getSessionId() {
        return this.sessionId;
    }
}

