/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service;

import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.stereotype.Service;

@Service
public class AtpUserService {
    private static final Logger log = LoggerFactory.getLogger(AtpUserService.class);
    private final Provider<UserInfo> userInfoProvider;

    public String getAtpUser() {
        return this.userInfoProvider != null && this.userInfoProvider.get() != null ? ((UserInfo)this.userInfoProvider.get()).getFullName() : "UserNotDefined";
    }

    public UUID getUserIdFromToken(String token) {
        UUID userId = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                token = token.split(" ")[1];
                JsonParser parser = JsonParserFactory.getJsonParser();
                Map tokenData = parser.parseMap(JwtHelper.decode((String)token).getClaims());
                userId = UUID.fromString(tokenData.get("sub").toString());
            }
            catch (Exception e) {
                log.warn("Cannot parse token with error: ", (Throwable)e);
            }
        }
        return userId;
    }

    public AtpUserService(Provider<UserInfo> userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }
}

