/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.mia.controllers.api.dto.candidates.ExportCandidateDto;
import org.qubership.atp.mia.controllers.api.dto.candidates.ExportEntitiesCandidateDto;
import org.qubership.atp.mia.exceptions.configuration.ProjectNotFoundException;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.springframework.stereotype.Service;

@Service
public class CandidatesService {
    private final ProjectConfigurationService projectConfigurationService;

    public List<ExportCandidateDto> getCandidates(UUID projectId) {
        ArrayList<ExportCandidateDto> candidates = new ArrayList<ExportCandidateDto>();
        Optional<ProjectConfiguration> projectConfigurationOptional = this.projectConfigurationService.findByProjectId(projectId);
        if (!projectConfigurationOptional.isPresent()) {
            throw new ProjectNotFoundException(projectId);
        }
        ProjectConfiguration projectConfiguration = projectConfigurationOptional.get();
        ArrayList<ExportEntitiesCandidateDto> sectionEntities = new ArrayList<ExportEntitiesCandidateDto>();
        projectConfiguration.getSections().forEach(s -> sectionEntities.add(new ExportEntitiesCandidateDto(s.getId(), s.getName(), "section", null)));
        candidates.add(new ExportCandidateDto(new UUID(0L, 1L), "Configuration", sectionEntities));
        ArrayList<ExportEntitiesCandidateDto> exportEntitiesCandidateDtos = new ArrayList<ExportEntitiesCandidateDto>();
        exportEntitiesCandidateDtos.add(new ExportEntitiesCandidateDto(new UUID(1L, 1L), "Common Configuration", "common_configuration", null));
        exportEntitiesCandidateDtos.add(new ExportEntitiesCandidateDto(new UUID(1L, 2L), "Header Configuration", "header_configuration", null));
        exportEntitiesCandidateDtos.add(new ExportEntitiesCandidateDto(new UUID(1L, 3L), "POT Header Configuration", "pot_header_configuration", null));
        candidates.add(new ExportCandidateDto(new UUID(0L, 2L), "Project Configuration", exportEntitiesCandidateDtos));
        candidates.add(new ExportCandidateDto(new UUID(0L, 3L), "Files", this.directoriesAndFiles(projectConfiguration.getRootDirectories())));
        return candidates;
    }

    private List<ExportEntitiesCandidateDto> directoriesAndFiles(List<ProjectDirectory> directories) {
        ArrayList<ExportEntitiesCandidateDto> directoriesAndFiles = new ArrayList<ExportEntitiesCandidateDto>();
        if (directories != null) {
            directories.forEach(d -> {
                if (d != null) {
                    List<ProjectFile> files;
                    List<ProjectDirectory> innerDirectories = d.getDirectories();
                    ArrayList<ExportEntitiesCandidateDto> directoriesAndFilesCandidates = new ArrayList<ExportEntitiesCandidateDto>();
                    if (innerDirectories != null && !innerDirectories.isEmpty()) {
                        directoriesAndFilesCandidates.addAll(this.directoriesAndFiles(innerDirectories));
                    }
                    if ((files = d.getFiles()) != null && !files.isEmpty()) {
                        files.forEach(f -> directoriesAndFilesCandidates.add(new ExportEntitiesCandidateDto(f.getId(), f.getName(), "file", null)));
                    }
                    directoriesAndFiles.add(new ExportEntitiesCandidateDto(d.getId(), d.getName(), "directory", directoriesAndFilesCandidates));
                }
            });
        }
        return directoriesAndFiles;
    }

    public CandidatesService(ProjectConfigurationService projectConfigurationService) {
        this.projectConfigurationService = projectConfigurationService;
    }
}

