/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service;

import clover.com.google.common.base.Preconditions;
import clover.org.apache.commons.lang.StringUtils;
import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.qubership.atp.mia.exceptions.fileservice.ArchiveFileNotFoundException;
import org.qubership.atp.mia.exceptions.fileservice.ArchiveIoExceptionDuringClose;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.ContentType;
import org.qubership.atp.mia.model.configuration.CommandPrefix;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.model.impl.FlowData;
import org.qubership.atp.mia.model.impl.VariableFormat;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.TableMarker;
import org.qubership.atp.mia.model.impl.macros.MacroRegistryImpl;
import org.qubership.atp.mia.model.impl.macros.MacrosType;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.repo.ContextRepository;
import org.qubership.atp.mia.service.configuration.EnvironmentsService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.utils.AtpMacrosUtils;
import org.qubership.atp.mia.utils.CryptoUtils;
import org.qubership.atp.mia.utils.EnvironmentVariableUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiaContext {
    private static final Logger log = LoggerFactory.getLogger(MiaContext.class);
    private final ProjectConfigurationService projectConfigurationService;
    private final ContextRepository contextRepository;
    private final String miaPotTemplate;
    private final EnvironmentsService environmentsService;
    @Value(value="${catalogue.url}")
    private String catalogueUrl;

    public static Link getLogLinkOnUi(String path) {
        String fileName;
        String projectFolder = FileMetaData.PROJECT_FOLDER.toString();
        Path pathOnUi = path.contains(projectFolder) ? Paths.get(path.split(projectFolder)[1], new String[0]) : Paths.get(path, new String[0]);
        String parent = pathOnUi.getParent() == null ? "" : pathOnUi.getParent().toString();
        String encodedFileName = fileName = pathOnUi.getFileName().toString();
        try {
            encodedFileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Fail to encode " + fileName);
        }
        return new Link("/rest/downloadFile" + FilenameUtils.separatorsToUnix((String)parent) + "/" + encodedFileName, fileName);
    }

    public String createFileName(ContentType contentType) {
        String accountNumber = Strings.nullToEmpty((String)this.getFlowData().getCustom(Constants.CustomParameters.ACCOUNT_NUMBER, this)).trim().replaceAll(" ", "_");
        String prefix = StringUtils.deleteWhitespace((String)this.getFlowData().getParameters().get("processName")) + "_" + accountNumber;
        return prefix + Utils.getTimestampFile() + contentType.getExtension();
    }

    public String createLogFileName(Command command) {
        String fileName;
        if (command.getLogFileNameFormat() != null) {
            fileName = StringUtils.deleteWhitespace((String)this.evaluate(command.getLogFileNameFormat()));
        } else {
            String accountNumber = Strings.nullToEmpty((String)this.getFlowData().getCustom(Constants.CustomParameters.ACCOUNT_NUMBER, this)).trim().replaceAll(" ", "_");
            String prefix = StringUtils.deleteWhitespace((String)this.getFlowData().getParameters().get("processName")) + "_" + accountNumber;
            fileName = prefix + Utils.getTimestampFile() + ".log";
        }
        return fileName;
    }

    public String createLogFileName(String suffix, String extension) {
        String prefix = StringUtils.deleteWhitespace((String)this.getFlowData().getParameters().get("processName")) + "_" + suffix;
        return prefix + Utils.getTimestampFile() + "." + extension;
    }

    public String createTableFileName(String tableName) {
        String prefix = StringUtils.deleteWhitespace((String)this.getFlowData().getParameters().get("processName"));
        prefix = StringUtils.isBlank((String)tableName) ? prefix : prefix + "_" + tableName;
        String accountNumber = Strings.nullToEmpty((String)this.getFlowData().getCustom(Constants.CustomParameters.ACCOUNT_NUMBER, this)).trim().replaceAll(" ", "_");
        prefix = StringUtils.isBlank((String)accountNumber) ? prefix : prefix + "_" + accountNumber;
        String fileName = prefix + Utils.getTimestampFile() + ".csv";
        return fileName;
    }

    public String evaluate(String text) {
        return this.evaluate(text, new HashMap<String, String>());
    }

    public String evaluate(String text, Map<String, String> additionalParameters) {
        if (!Strings.isNullOrEmpty((String)text)) {
            String variableFormat = this.getConfig().getCommonConfiguration().getVariableFormat();
            VariableFormat varFormat = new VariableFormat(variableFormat);
            HashMap<String, String> parameters = new HashMap<String, String>(this.getFlowData().getParameters());
            parameters.putAll(additionalParameters);
            return this.evaluateWithMacroses(this.evaluateInside(text, varFormat, parameters));
        }
        return text;
    }

    public TableMarker evaluateTableMarker(TableMarker tableMarker) {
        TableMarker newTableMarker = new TableMarker();
        LinkedHashMap<String, String> expectedResultForQuery = new LinkedHashMap<String, String>();
        if (tableMarker.getTableRowCount() != null) {
            newTableMarker.setTableRowCount(this.evaluate(tableMarker.getTableRowCount()));
        }
        if (tableMarker.getExpectedResultForQuery() != null) {
            for (Map.Entry<String, String> entry : tableMarker.getExpectedResultForQuery().entrySet()) {
                expectedResultForQuery.put(entry.getKey(), this.evaluate(entry.getValue()));
            }
            newTableMarker.setExpectedResultForQuery(expectedResultForQuery);
        }
        return newTableMarker;
    }

    public ProjectConfiguration getConfig() {
        return this.projectConfigurationService.getConfigByProjectId(this.getProjectId());
    }

    public String getExternalPrefix() {
        String prefix = this.getConfig().getCommonConfiguration().getExternalEnvironmentPrefix();
        return Strings.isNullOrEmpty((String)prefix) ? "" : this.evaluate(prefix);
    }

    public FlowData getFlowData() {
        return this.contextRepository.getContext();
    }

    public Path getLogPath() {
        return this.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_LOG);
    }

    public File getPotTemplate() {
        return new File(this.miaPotTemplate);
    }

    public Path getProjectFilePath() {
        return this.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_PROJECT, null);
    }

    public UUID getProjectId() {
        return this.getFlowData().getProjectId();
    }

    public Path getProjectPathWithType(ProjectFileType projectFileType) {
        FlowData flowData = this.contextRepository.getContext();
        return this.projectConfigurationService.getProjectPathWithType(flowData.getProjectId(), projectFileType, flowData.getSessionId());
    }

    public Path getProjectPathWithType(ProjectFileType projectFileType, UUID sessionId) {
        return this.projectConfigurationService.getProjectPathWithType(this.contextRepository.getContext().getProjectId(), projectFileType, sessionId);
    }

    public LinkedHashMap<String, String> getShellPrefixes(String system) {
        Optional<CommandPrefix> commandPrefix = this.getConfig().getCommonConfiguration().getCommandShellPrefixes().stream().filter(p -> p.getSystem().equals(system)).findFirst();
        if (commandPrefix.isPresent()) {
            return commandPrefix.get().getPrefixes();
        }
        return new LinkedHashMap<String, String>();
    }

    public Path getUploadsPath() {
        return this.getProjectPathWithType(ProjectFileType.MIA_FILE_TYPE_UPLOAD);
    }

    public String prepareMiaURL(String miaPath, String processName) {
        String urlSuffix = "";
        try {
            String[] sections;
            String urlParams = "";
            for (String section : sections = miaPath.split("/")) {
                urlParams = urlParams + section + ",";
            }
            urlSuffix = URLEncoder.encode(urlParams + processName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error(ErrorCodes.MIA_1812_MIA_URL_ENCODE_FAIL.getMessage(processName));
        }
        return this.catalogueUrl + "/project/" + this.getProjectId() + "/mia?path=" + urlSuffix;
    }

    public void replaceSpacesInAccountNumber() {
        this.getFlowData().getParameters().computeIfPresent(Constants.CustomParameters.ACCOUNT_NUMBER.toString(), (k, v) -> v.replaceAll(" ", "_"));
    }

    public void setContext(UUID projectId, UUID sessionId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"No project specified.");
        String projectName = this.environmentsService.getProject(projectId).getName();
        log.debug("Set project id '{}' with name '{}' to FlowData", (Object)projectId, (Object)projectName);
        FlowData flowData = new FlowData(projectId, projectName, sessionId == null ? UUID.randomUUID() : sessionId);
        this.contextRepository.setContext(flowData);
    }

    public void setContext(ExecutionRequest request, UUID projectId, String environmentName) {
        this.setContext(projectId, request.getSessionId());
        Preconditions.checkNotNull((Object)environmentName, (Object)"No environmentName specified in parameters.");
        log.debug(String.format("Set environment with name '{}' to FlowData.", environmentName));
        this.getFlowData().setEnvironment(this.environmentsService.getEnvByName(projectId, environmentName));
        this.setFlowDataFromRequest(request);
    }

    public void setFlowDataFromRequest(ExecutionRequest request) {
        FlowData flowData = this.getFlowData();
        if (request.getFlowData() != null) {
            flowData.setTestDataWorkbook(request.getFlowData().getTestDataWorkbook());
            flowData.setParameters(request.getFlowData().getParameters());
            flowData.getParameters().forEach((k, v) -> flowData.getParameters().put((String)k, this.evaluateWithMacroses((String)v)));
        }
        this.addCommonParametersFromConfig();
    }

    public Link zipCommandOutputs(String processName, List<String> filePaths) {
        String zipName = processName + Utils.getTimestampFile() + ".zip";
        return this.zipCommandOutputs(filePaths, this.getLogPath().resolve(zipName));
    }

    public Link zipCommandOutputs(List<String> filePaths, Path zipPath) {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipPath.toFile())));){
            zos.setMethod(8);
            int i = 0;
            for (String filePath : filePaths) {
                try {
                    File file = new File(filePath);
                    if (file.exists() && !file.isDirectory()) {
                        zos.putNextEntry(new ZipEntry(file.getName()));
                        byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
                        zos.write(bytes, 0, bytes.length);
                        continue;
                    }
                    String errMsg = ++i + "_Error_file_is_directory_or_not_present_" + file.getName();
                    zos.putNextEntry(new ZipEntry(errMsg));
                }
                catch (IOException e) {
                    log.error(ErrorCodes.MIA_2051_ARCHIVE_IO_ERROR_DURING_SAVE.getMessage(filePath, e.getMessage()));
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new ArchiveFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new ArchiveIoExceptionDuringClose(zipPath, e);
        }
        return MiaContext.getLogLinkOnUi(zipPath.toString());
    }

    private void addCommonParametersFromConfig() {
        this.projectConfigurationService.getConfigByProjectId(this.getProjectId()).getCommonConfiguration().getCommonVariables().forEach((k, v) -> this.getFlowData().addParameter((String)k, this.evaluate((String)v)));
    }

    private String evaluateInside(String text, VariableFormat varFormat, Map<String, String> additionalParameters) {
        HashSet avoidInfinityLoops = new HashSet();
        String extractMatches = varFormat.getMatches().toString();
        Pattern pattern = Pattern.compile(extractMatches);
        int max_Iteration = 1000;
        int iterationCount = 0;
        while (pattern.matcher(text).find()) {
            if (iterationCount++ > 1000) {
                log.warn("Maximum iterations reached, exiting loop to prevent infinite loop.");
                break;
            }
            String newText = text;
            Matcher matcher = pattern.matcher(newText);
            LinkedHashSet<String> extractedVariables = new LinkedHashSet<String>();
            while (matcher.find()) {
                for (int groupIdx = 1; groupIdx <= matcher.groupCount(); ++groupIdx) {
                    extractedVariables.add(matcher.group(groupIdx));
                }
            }
            boolean infinityLoopFound = false;
            for (LinkedHashSet linkedHashSet : avoidInfinityLoops) {
                if (extractedVariables.isEmpty() || linkedHashSet.size() != extractedVariables.size() || !linkedHashSet.containsAll(extractedVariables)) continue;
                infinityLoopFound = true;
                break;
            }
            if (infinityLoopFound) {
                log.warn("INFINITY LOOP found in {}", (Object)text);
                break;
            }
            avoidInfinityLoops.add(extractedVariables);
            for (String string : extractedVariables) {
                String decryptedValue;
                if (!additionalParameters.containsKey(string) || (decryptedValue = CryptoUtils.decryptValue(additionalParameters.get(string))) == null) continue;
                newText = newText.replaceAll(varFormat.getVariableAccordingFormat(string), Matcher.quoteReplacement(decryptedValue));
            }
            text = newText;
        }
        return text;
    }

    public String evaluateWithMacroses(String text) {
        boolean contains = text.contains("${");
        if (contains) {
            if (text.contains("${ENV") && text.contains("}") && text.indexOf("${Gen") < text.lastIndexOf("}")) {
                int end;
                int start = text.indexOf("${ENV");
                String environmentVariable = text.substring(start, end = text.indexOf("}", start) + 1);
                String environmentVariableValue = EnvironmentVariableUtils.evaluateEnvironmentVariable(environmentVariable);
                if (environmentVariableValue == null) {
                    log.warn("Problem in evaluating Environment Variable Value. Either System or Connection or Connection parameter doesn't exist. Returning without Converting");
                    return text;
                }
                return text.replace(environmentVariable, environmentVariableValue);
            }
            log.info("Found ${ in text, so it will be replaced as macros");
            log.debug("${ in text: {}", (Object)text);
            int start = text.indexOf("${") + 2;
            int end = start == text.length() ? text.length() + 1 : text.indexOf("}", start);
            String macrosText = text.substring(start, end);
            try {
                String[] macrosParams;
                String typeAsString = macrosText.substring(0, macrosText.indexOf("("));
                MacrosType marcosType = MacrosType.valueOf(typeAsString);
                String macrosParameters = macrosText.substring(macrosText.indexOf("(") + 1, macrosText.indexOf(")"));
                if (macrosParameters.contains("',")) {
                    macrosParams = macrosParameters.split("',");
                    for (int paramIdx = 0; paramIdx < macrosParams.length; ++paramIdx) {
                        macrosParams[paramIdx] = macrosParams[paramIdx].trim().replaceAll("'", "");
                    }
                } else {
                    macrosParams = macrosParameters.split(",");
                }
                return this.evaluateWithMacroses(this.replaceMacrosWithResultOfMacros(text, marcosType, macrosParams));
            }
            catch (IndexOutOfBoundsException e) {
                log.error("Out of bound for macros '${{}}'.\n1. Probably you use curly brackets incorrectly please check { } that it's closes only macros.\n2. Also please check that macros available in MIA documentation", (Object)macrosText);
            }
            catch (Exception e) {
                log.error("Implementation for macros type '${{}}' has not been found", (Object)macrosText);
            }
        }
        if (text.matches("(?s).*\\$\\w+\\(.*\\)") || text.matches("(?s).*\\#\\w+\\(.*\\)")) {
            return AtpMacrosUtils.evaluateWithAtpMacros(text, this.getFlowData().getProjectId());
        }
        return text;
    }

    private String replaceMacrosWithResultOfMacros(String text, MacrosType macrosType, String[] macrosParams) {
        String macrosResult = MacroRegistryImpl.getMacros(macrosType.name()).evaluate(macrosParams);
        String textBeforeMacros = text.substring(0, text.indexOf("${"));
        int start = text.indexOf("${");
        int end = start == text.length() ? text.length() + 1 : text.indexOf("}", start) + 1;
        String textAfterMacros = start == text.length() ? "" : text.substring(end);
        return textBeforeMacros + macrosResult + textAfterMacros;
    }

    public MiaContext(ProjectConfigurationService projectConfigurationService, ContextRepository contextRepository, String miaPotTemplate, EnvironmentsService environmentsService) {
        this.projectConfigurationService = projectConfigurationService;
        this.contextRepository = contextRepository;
        this.miaPotTemplate = miaPotTemplate;
        this.environmentsService = environmentsService;
    }
}

