/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.cache;

import com.hazelcast.spring.cache.HazelcastCache;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.mia.model.CacheKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;

public interface MiaCacheService {
    public static final Logger log = LoggerFactory.getLogger(MiaCacheService.class);

    public CacheManager cacheManager();

    default public void clearEnvironmentsCache(CacheManager cacheManager, UUID projectId) {
        for (CacheKeys cacheKey : CacheKeys.values()) {
            log.info("Clearing caches for cache key '{}' and project id {}", (Object)cacheKey, (Object)projectId);
            Cache cache = cacheManager.getCache(cacheKey.getKey());
            if (cache == null) continue;
            if (!cacheKey.isKeyContainProjectId()) {
                cache.clear();
                continue;
            }
            Set<Object> keySet = new HashSet();
            if (cache instanceof HazelcastCache) {
                keySet = ((HazelcastCache)cache).getNativeCache().keySet();
            }
            if (cache instanceof CaffeineCache) {
                keySet = ((CaffeineCache)cache).getNativeCache().asMap().keySet();
            }
            for (Object key : keySet) {
                if (!key.toString().contains(projectId.toString())) continue;
                cache.evict(key);
            }
        }
    }

    default public void clearConfigurationCache(UUID projectId) {
        Cache cache = this.cacheManager().getCache("ATP_MIA_CONFIGURATION");
        if (cache != null) {
            cache.evictIfPresent((Object)projectId);
        }
    }
}

