/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.cache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.util.UUID;
import org.qubership.atp.mia.model.CacheKeys;
import org.qubership.atp.mia.service.cache.MiaCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;

public class MiaCacheServiceHazelCast
implements MiaCacheService {
    private static final Logger log = LoggerFactory.getLogger(MiaCacheServiceHazelCast.class);
    public static final String CACHE_CLIENT_NAME = "ATP_MIA_";
    public static final String CACHE_SERVER_NAME = "ATP-MIA-SERVER";
    public static final UUID CACHE_ID = UUID.randomUUID();
    @Value(value="${spring.cache.hazelcast.cluster-name:atp-hc}")
    private String cacheClusterName;
    @Value(value="${spring.cache.hazelcast.server.address:127.0.0.1}")
    private String hazelcastServerAddress;
    @Value(value="${spring.cache.hazelcast.server.enable:#{true}}")
    private boolean hazelcastServerEnable;
    @Value(value="${spring.cache.hazelcast.server.port:#{5701}}")
    private int hazelcastServerPort;
    private volatile HazelcastInstance hzInstanceClient;
    @Value(value="${server.port}")
    private String serverPort;
    private boolean serverStarted = false;
    private CacheManager cacheManager;

    @Override
    public CacheManager cacheManager() {
        if (this.cacheManager == null) {
            log.info("Create HAZELCAST cache manager");
            this.cacheManager = new HazelcastCacheManager(this.getHzInstance());
        }
        return this.cacheManager;
    }

    public synchronized HazelcastInstance getHzInstance() {
        if (this.hzInstanceClient == null) {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setInstanceName("ATP_MIA_on_port_" + this.serverPort + "_with_id_" + CACHE_ID);
            clientConfig.setClusterName(this.cacheClusterName);
            clientConfig.getNetworkConfig().addAddress(new String[]{this.hazelcastServerAddress + ":" + this.hazelcastServerPort});
            clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
            if (!this.serverStarted) {
                this.startCacheServer();
            }
            try {
                log.debug("Connect to HAZELCAST as client");
                this.hzInstanceClient = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
                for (CacheKeys key : CacheKeys.values()) {
                    String name = key.getKey();
                    if (CacheKeys.AUTH_PROJECTS_KEY.equals((Object)key)) continue;
                    try {
                        log.debug("Try to create config for map {}", (Object)name);
                        this.hzInstanceClient.getConfig().addMapConfig(new MapConfig(name).setTimeToLiveSeconds(key.getTtlInSeconds()));
                    }
                    catch (Exception failedCreate) {
                        log.warn("Map {} already created. Not possible to change map config: {}", (Object)name, (Object)failedCreate);
                    }
                }
            }
            catch (Exception e) {
                log.error("HazelCast server is not available!!! {}", (Throwable)e);
                this.serverStarted = false;
            }
        }
        return this.hzInstanceClient;
    }

    private void startCacheServer() {
        if (this.hazelcastServerEnable) {
            log.info("Get or start cache config on address " + this.hazelcastServerAddress + ":" + this.hazelcastServerPort);
            Config config = new Config(CACHE_SERVER_NAME);
            NetworkConfig network = config.getNetworkConfig().setPort(this.hazelcastServerPort).setPortCount(1).setPortAutoIncrement(false).setReuseAddress(true);
            network.getJoin().getMulticastConfig().setEnabled(true);
            for (CacheKeys key : CacheKeys.values()) {
                if (CacheKeys.AUTH_PROJECTS_KEY.equals((Object)key)) continue;
                config.addMapConfig(new MapConfig(key.getKey()).setTimeToLiveSeconds(key.getTtlInSeconds()));
            }
            config.setClusterName(this.cacheClusterName);
            try {
                if (Hazelcast.getOrCreateHazelcastInstance((Config)config) != null) {
                    this.serverStarted = true;
                }
            }
            catch (Exception e) {
                log.warn("HazelCast server already started: {}", (Object)e.getMessage());
                this.serverStarted = false;
            }
        } else {
            this.serverStarted = true;
        }
    }
}

