/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import javax.xml.ws.Holder;
import org.apache.commons.lang.IllegalClassException;
import org.qubership.atp.mia.exceptions.configuration.DeserializeErrorInFileException;
import org.qubership.atp.mia.exceptions.configuration.DeserializeJsonConfigFailedException;
import org.qubership.atp.mia.exceptions.configuration.ErrorInFlowJsonException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.ProjectNotFoundException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.CommonConfiguration;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.HeaderConfiguration;
import org.qubership.atp.mia.model.configuration.PotHeaderConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.SectionConfiguration;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;
import org.qubership.atp.mia.service.AtpUserService;
import org.qubership.atp.mia.service.configuration.EnvironmentsService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationFileDeserializer {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFileDeserializer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper MAPPER_NO_ERROR = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final ThreadLocal<List<SectionConfiguration>> threadSections = new ThreadLocal();
    private final ThreadLocal<List<CompoundConfiguration>> threadCompounds = new ThreadLocal();
    private final ThreadLocal<List<ProcessConfiguration>> threadProcesses = new ThreadLocal();
    private final ThreadLocal<List<ProjectDirectory>> threadDirectories = new ThreadLocal();
    private final ThreadLocal<Boolean> threadMigration = new ThreadLocal();
    private final ThreadLocal<List<ProjectFile>> threadFiles = new ThreadLocal();
    private final EnvironmentsService environmentsService;
    private final GridFsService gridFsService;
    private final AtpUserService atpUserService;
    private ThreadLocal<StringJoiner> validationResults = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectConfiguration deserialize(Path pathToConfig, ProjectConfiguration flowConfig, Path miaPathForEtalonFiles, boolean isMigration) throws IOException {
        this.threadMigration.set(isMigration);
        Path flowConfigPath = pathToConfig.resolve("flow").resolve("Flow.json");
        JsonNode node = MAPPER.readTree(flowConfigPath.toFile());
        this.validationResults.set(new StringJoiner("\n"));
        UUID projectId = flowConfig.getProjectId();
        if (flowConfig.getProjectName() == null || flowConfig.getProjectName().isEmpty()) {
            flowConfig.setProjectName(this.environmentsService.getProjects().stream().filter(p -> p.getId().equals(projectId)).findFirst().orElseThrow(() -> new ProjectNotFoundException(projectId)).getName());
        }
        try {
            flowConfig.setCommonConfiguration(this.parseConfiguration(node, "commonConfiguration", CommonConfiguration.class).toBuilder().projectId(projectId).projectConfiguration(flowConfig).build());
            if (node.has("defaultSystem")) {
                flowConfig.getCommonConfiguration().setDefaultSystem(node.get("defaultSystem").asText());
            }
            flowConfig.getCommonConfiguration().updateShellPrefixes();
            flowConfig.setHeaderConfiguration(this.parseConfiguration(node, "headerConfiguration", HeaderConfiguration.class).toBuilder().projectId(projectId).projectConfiguration(flowConfig).build());
            flowConfig.setPotHeaderConfiguration(this.parseConfiguration(node, "potHeaderConfiguration", PotHeaderConfiguration.class).toBuilder().projectId(projectId).projectConfiguration(flowConfig).build());
            this.threadSections.set(new ArrayList<SectionConfiguration>(flowConfig.getAllSections()));
            if (flowConfig.getSections() == null) {
                flowConfig.setSections(new ArrayList<SectionConfiguration>());
            }
            flowConfig.getSections().clear();
            this.threadCompounds.set(new ArrayList<CompoundConfiguration>(flowConfig.getCompounds()));
            if (flowConfig.getCompounds() == null) {
                flowConfig.setCompounds(new ArrayList<CompoundConfiguration>());
            }
            flowConfig.getCompounds().clear();
            this.threadProcesses.set(new ArrayList<ProcessConfiguration>(flowConfig.getProcesses()));
            if (flowConfig.getProcesses() == null) {
                flowConfig.setProcesses(new ArrayList<ProcessConfiguration>());
            }
            flowConfig.getProcesses().clear();
            this.parseSections(flowConfig, node, flowConfigPath, null);
            this.parseIsolatedProcesses(flowConfig, pathToConfig.resolve("flow").toFile());
            this.updateConfigWithDefaultSystem(flowConfig.getProcesses(), flowConfig.getCommonConfiguration().getDefaultSystem());
            this.threadDirectories.set(new ArrayList<ProjectDirectory>(flowConfig.getAllDirectories()));
            if (flowConfig.getDirectories() == null) {
                flowConfig.setDirectories(new ArrayList<ProjectDirectory>());
            }
            flowConfig.getDirectories().clear();
            this.threadFiles.set(new ArrayList<ProjectFile>(flowConfig.getFiles()));
            if (flowConfig.getFiles() == null) {
                flowConfig.setFiles(new ArrayList<ProjectFile>());
            }
            flowConfig.getFiles().clear();
            this.deserializeProjectDirectoriesAndFiles(pathToConfig, flowConfig, miaPathForEtalonFiles);
            flowConfig.setLastLoadedWhen(LocalDateTime.now());
        }
        catch (Exception e) {
            String err = "Error while reading flowConfig; FlowConfig path: [" + flowConfigPath + "];\n" + e.getMessage();
            log.error(err);
            this.validationResults.get().add(err);
        }
        finally {
            this.threadSections.remove();
            this.threadCompounds.remove();
            this.threadProcesses.remove();
            this.threadDirectories.remove();
            this.threadFiles.remove();
            flowConfig.setValidationResult(this.validationResults.get().toString());
            this.validationResults.remove();
            this.threadMigration.remove();
        }
        return flowConfig;
    }

    private void deserializeProjectDirectories(File directory, ProjectConfiguration projectConfiguration, ProjectDirectory parentDirectory, Path miaPathForEtalonFiles) {
        ProjectDirectory projectDirectory = this.findProjectDirectory(directory.getName(), parentDirectory).orElse((ProjectDirectory)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)ProjectDirectory.builder().id(this.threadMigration.get() != false ? null : UUID.randomUUID())).name(directory.getName())).parentDirectory(parentDirectory)).projectConfiguration(projectConfiguration)).build());
        if (parentDirectory == null) {
            projectConfiguration.getDirectories().add(projectDirectory);
        } else {
            parentDirectory.getDirectories().add(projectDirectory);
        }
        for (File file : Optional.ofNullable(directory.listFiles()).map(Arrays::asList).orElse(Collections.emptyList())) {
            if (file.isDirectory()) {
                this.deserializeProjectDirectories(file, projectConfiguration, projectDirectory, miaPathForEtalonFiles);
                continue;
            }
            this.deserializeProjectFiles(file, projectDirectory, projectConfiguration, miaPathForEtalonFiles);
        }
    }

    private ProjectConfiguration deserializeProjectDirectoriesAndFiles(Path pathFlowJson, ProjectConfiguration projectConfiguration, Path miaPathForEtalonFiles) {
        File etalonFiles = pathFlowJson.resolve(projectConfiguration.getCommonConfiguration().getEthalonFilesPath()).toFile();
        if (etalonFiles.exists()) {
            log.info("Storing of {} files to Mongo DB Process started", (Object)etalonFiles.getName());
            for (File file : Optional.ofNullable(etalonFiles.listFiles()).map(Arrays::asList).orElse(Collections.emptyList())) {
                if (file.isDirectory()) {
                    this.deserializeProjectDirectories(file, projectConfiguration, null, miaPathForEtalonFiles);
                    continue;
                }
                this.deserializeProjectFiles(file, null, projectConfiguration, miaPathForEtalonFiles);
            }
        }
        return projectConfiguration;
    }

    private void deserializeProjectFiles(File file, ProjectDirectory projectDirectory, ProjectConfiguration projectConfiguration, Path miaPathForEtalonFiles) {
        Optional<ProjectFile> optionalProjectFile = this.findProjectFile(file.getName(), projectDirectory);
        DateAuditorEntity projectFile = optionalProjectFile.isPresent() ? optionalProjectFile.get() : ((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)((ProjectFile.ProjectFileBuilder)ProjectFile.builder().id(this.threadMigration.get() != false ? null : UUID.randomUUID())).name(file.getName())).directory(projectDirectory)).lastUpdateWhen(LocalDateTime.now())).lastUpdateBy(this.atpUserService.getAtpUser())).size(file.length())).projectConfiguration(projectConfiguration)).build();
        projectFile.setGridFsObjectId(this.gridFsService.uploadFile(new FileMetaData(projectConfiguration.getProjectId(), miaPathForEtalonFiles.resolve(projectFile.getPathFile()).toString(), ProjectFileType.MIA_FILE_TYPE_PROJECT), file).toString());
        if (projectDirectory != null) {
            projectDirectory.getFiles().add((ProjectFile)projectFile);
        }
        projectConfiguration.getFiles().add((ProjectFile)projectFile);
    }

    private Optional<ProjectDirectory> findProjectDirectory(String directoryName, ProjectDirectory parentDirectory) {
        return this.threadDirectories.get().stream().filter(d -> {
            if (parentDirectory == null) {
                return d.getName().equals(directoryName) && d.getParentDirectory() == null;
            }
            return d.getName().equals(directoryName) && parentDirectory.getId().equals(d.getParentDirectory().getId());
        }).findFirst();
    }

    private Optional<ProjectFile> findProjectFile(String fileName, ProjectDirectory directory) {
        return this.threadFiles.get().stream().filter(f -> {
            if (directory == null) {
                return f.getName().equals(fileName) && f.getDirectory() == null;
            }
            return f.getName().equals(fileName) && f.getDirectory() != null && directory.getId().equals(f.getDirectory().getId());
        }).findFirst();
    }

    private UUID getCompoundId(JsonNode jsonNode) {
        if (this.threadMigration.get().booleanValue()) {
            return null;
        }
        Optional<CompoundConfiguration> compoundConfigurationOptional = this.threadCompounds.get().stream().filter(c -> {
            if (jsonNode.has("id") && c.getId().equals(UUID.fromString(jsonNode.get("id").asText()))) {
                return true;
            }
            return c.getName().equals(jsonNode.get("name").asText());
        }).findFirst();
        if (compoundConfigurationOptional.isPresent()) {
            return compoundConfigurationOptional.get().getId();
        }
        return this.getIdFromJsonNode(jsonNode);
    }

    private UUID getIdFromJsonNode(JsonNode jsonNode) {
        if (jsonNode.has("id")) {
            return UUID.fromString(jsonNode.get("id").asText());
        }
        return null;
    }

    private UUID getProcessId(JsonNode jsonNode, Path fileName, String procName) {
        if (this.threadMigration.get().booleanValue()) {
            return null;
        }
        Optional<ProcessConfiguration> processConfigurationOptional = this.threadProcesses.get().stream().filter(p -> {
            if (jsonNode.has("id") && p.getId().equals(UUID.fromString(jsonNode.get("id").asText()))) {
                return true;
            }
            return fileName != null && fileName.equals(Paths.get(p.getPathToFile(), new String[0]).normalize()) || procName != null && procName.equals(p.getName());
        }).findFirst();
        if (processConfigurationOptional.isPresent()) {
            return processConfigurationOptional.get().getId();
        }
        return jsonNode == null ? null : this.getIdFromJsonNode(jsonNode);
    }

    private UUID getSectionId(JsonNode jsonNode, UUID parentSectionId) {
        if (this.threadMigration.get().booleanValue()) {
            return null;
        }
        Optional<SectionConfiguration> sectionConfigurationOptional = this.threadSections.get().stream().filter(s -> {
            if (jsonNode.has("id") && s.getId().equals(UUID.fromString(jsonNode.get("id").asText()))) {
                return true;
            }
            if (s.getName().equals(jsonNode.get("name").asText())) {
                if (parentSectionId == null) {
                    return s.getParentSection() == null;
                }
                if (s.getParentSection() != null) {
                    return parentSectionId.equals(s.getParentSection().getId());
                }
            }
            return false;
        }).findFirst();
        if (sectionConfigurationOptional.isPresent()) {
            return sectionConfigurationOptional.get().getId();
        }
        return this.getIdFromJsonNode(jsonNode);
    }

    private void parseCompound(ProjectConfiguration flowConfig, Path flowConfigPath, JsonNode compoundJsonNode, SectionConfiguration sectionConfiguration) throws IOException {
        String compoundName = compoundJsonNode.get("name").asText();
        UUID compoundId = this.getCompoundId(compoundJsonNode);
        CompoundConfiguration compound = flowConfig.getCompounds().stream().filter(c -> c.getName().equals(compoundName) || c.getId() != null && c.getId().equals(compoundId)).findAny().orElseGet(() -> {
            DateAuditorEntity compoundConfiguration = ((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)((CompoundConfiguration.CompoundConfigurationBuilder)new CompoundConfiguration().toBuilder()).id(compoundId)).name(compoundName)).referToInput(compoundJsonNode.has("referToInput") ? compoundJsonNode.get("referToInput").asText() : null)).build();
            for (JsonNode processNode : compoundJsonNode.get("processList")) {
                this.parseProcess(flowConfig, flowConfigPath, processNode, sectionConfiguration, (CompoundConfiguration)compoundConfiguration);
            }
            ((CompoundConfiguration)compoundConfiguration).setProjectConfiguration(flowConfig);
            if (sectionConfiguration != null) {
                ((CompoundConfiguration)compoundConfiguration).getInSections().add(sectionConfiguration);
            }
            return compoundConfiguration;
        });
        if (sectionConfiguration != null) {
            sectionConfiguration.addCompound(compound);
        }
        flowConfig.getCompounds().add(compound);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseConfiguration(JsonNode node, String nodeName, Class<T> clazz) {
        void var4_7;
        if (node.has(nodeName)) {
            try {
                Object object = MAPPER.convertValue((Object)node.get(nodeName), clazz);
                return var4_7;
            }
            catch (IllegalArgumentException e) {
                String message = ErrorCodes.MIA_0054_FLOW_CONTAIN_ERROR.getMessage(nodeName, e.getMessage());
                log.warn(message);
                this.validationResults.get().add(message);
                Object object = MAPPER_NO_ERROR.convertValue((Object)node.get(nodeName), clazz);
                if (object != null) return var4_7;
                throw new ErrorInFlowJsonException(nodeName, e);
            }
        }
        try {
            T t = clazz.newInstance();
            return var4_7;
        }
        catch (Exception e) {
            throw new IllegalClassException("Can't create class " + clazz.getName());
        }
    }

    private void parseIsolatedProcesses(ProjectConfiguration flowConfig, File folder) {
        if (folder.exists()) {
            for (File file : Optional.ofNullable(folder.listFiles()).map(Arrays::asList).orElse(Collections.emptyList())) {
                if (file.isDirectory()) {
                    this.parseIsolatedProcesses(flowConfig, file);
                    continue;
                }
                if (file.getName().equals("Flow.json") || !file.getName().endsWith(".json")) continue;
                Path fileName = FileUtils.getPathToFileFromFile(file);
                if (!flowConfig.getProcesses().stream().noneMatch(p -> Paths.get(p.getPathToFile(), new String[0]).normalize().equals(fileName))) continue;
                try {
                    ProcessSettings processSettings = (ProcessSettings)MAPPER_NO_ERROR.readValue(file, ProcessSettings.class);
                    if (!processSettings.check()) {
                        log.error("In file '" + file.getName() + "' is not Process configuration");
                        continue;
                    }
                    String procName = this.uniqueProcName(processSettings.getName(), flowConfig);
                    processSettings.setName(procName);
                    DateAuditorEntity processConfiguration = ((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)ProcessConfiguration.builder().id(null)).name(procName)).pathToFile(fileName.toString())).processSettings(processSettings)).projectConfiguration(flowConfig)).build();
                    this.threadProcesses.get().stream().forEach(arg_0 -> ConfigurationFileDeserializer.lambda$parseIsolatedProcesses$10(procName, (ProcessConfiguration)processConfiguration, arg_0));
                    flowConfig.getProcesses().add((ProcessConfiguration)processConfiguration);
                }
                catch (Exception e) {
                    String message = "Unable to parse Isolated Process. '" + fileName + "' contains error:" + e.getMessage();
                    log.warn(message);
                    this.validationResults.get().add(message);
                }
            }
        }
    }

    private void parseProcess(ProjectConfiguration flowConfig, Path flowConfigPath, JsonNode processJsonNode, SectionConfiguration sectionConfiguration, CompoundConfiguration compoundConfiguration) {
        Path filePath = processJsonNode.has("template") ? Paths.get(processJsonNode.get("template").asText(), new String[0]).normalize() : (processJsonNode.has("process") ? Paths.get(processJsonNode.get("process").asText(), new String[0]).normalize() : (processJsonNode.has("Process") ? Paths.get(processJsonNode.get("Process").asText(), new String[0]).normalize() : (processJsonNode.has("pathToFile") ? Paths.get(processJsonNode.get("pathToFile").asText(), new String[0]).normalize() : Paths.get(processJsonNode.asText(), new String[0]).normalize())));
        UUID processId = this.getProcessId(processJsonNode, filePath, null);
        ProcessConfiguration processConfiguration = flowConfig.getProcesses().stream().filter(p -> filePath.equals(Paths.get(p.getPathToFile(), new String[0]).normalize()) || p.getId() != null && p.getId().equals(processId)).findAny().orElseGet(() -> {
            try {
                ProcessSettings processSettings = (ProcessSettings)MAPPER_NO_ERROR.readValue(flowConfigPath.getParent().resolve(filePath).toFile(), ProcessSettings.class);
                String procName = this.uniqueProcName(processSettings.getName(), flowConfig);
                processSettings.setName(procName);
                DateAuditorEntity processConfigurationNew = ((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)((ProcessConfiguration.ProcessConfigurationBuilder)ProcessConfiguration.builder().id(processId)).name(procName)).processSettings(processSettings)).pathToFile(filePath.toString())).projectConfiguration(flowConfig)).build();
                flowConfig.getProcesses().add((ProcessConfiguration)processConfigurationNew);
                return processConfigurationNew;
            }
            catch (Exception e) {
                String message = "Fail parsing process from '" + filePath + "' file";
                this.validationResults.get().add(message);
                log.error(message, (Throwable)e);
                return null;
            }
        });
        if (processConfiguration != null) {
            if (compoundConfiguration != null) {
                processConfiguration.getInCompounds().add(compoundConfiguration);
                processConfiguration.getCompounds().add(compoundConfiguration.getName());
                compoundConfiguration.addProcess(processConfiguration);
            } else if (sectionConfiguration != null && sectionConfiguration.getProcesses().stream().noneMatch(p -> p.getName().equals(processConfiguration.getName()))) {
                processConfiguration.getInSections().add(sectionConfiguration);
                processConfiguration.getSections().add(sectionConfiguration.getName());
                sectionConfiguration.addProcess(processConfiguration);
            }
        }
    }

    private String uniqueProcName(String originalName, ProjectConfiguration projectConfiguration) {
        Holder procName = new Holder((Object)originalName);
        int duplicateId = 0;
        while (projectConfiguration.getProcesses().stream().anyMatch(p -> p.getName().equals(procName.value))) {
            procName.value = originalName + "_duplicate" + ++duplicateId;
        }
        if (duplicateId > 0) {
            String message = "Process with name '" + originalName + "' already exist. Make new name to '" + (String)procName.value + "'";
            log.warn(message);
            this.validationResults.get().add(message);
        }
        return (String)procName.value;
    }

    private void parseProcessesOrCompound(ProjectConfiguration flowConfig, Path flowConfigPath, JsonNode processesNode, SectionConfiguration sectionConfiguration) {
        for (JsonNode processJsonNode : processesNode) {
            try {
                String type;
                try {
                    type = processJsonNode.get("execType").asText();
                }
                catch (NullPointerException e) {
                    try {
                        type = processJsonNode.get("type").asText();
                    }
                    catch (NullPointerException ex) {
                        JsonNode nameNode = processJsonNode.get("name");
                        String name = nameNode != null ? nameNode.asText() : ". You have second error: you forgot to set name! Check Flow.json for process without name.";
                        String message = "Can't find \"type\" in node " + name;
                        throw new NullPointerException(message);
                    }
                }
                if ("compound".equalsIgnoreCase(type)) {
                    this.parseCompound(flowConfig, flowConfigPath, processJsonNode, sectionConfiguration);
                    continue;
                }
                if (!"config".equalsIgnoreCase(type) && !"process".equalsIgnoreCase(type)) continue;
                this.parseProcess(flowConfig, flowConfigPath, processJsonNode, sectionConfiguration, null);
            }
            catch (JsonProcessingException e) {
                StringBuilder errorMessage = new StringBuilder("Error while reading of process: [").append(processJsonNode).append("].");
                if (processJsonNode.has("pathToFile")) {
                    errorMessage.append("\n<b>Check file ").append(processJsonNode.get("pathToFile"));
                    errorMessage.append(" at line: ").append(e.getLocation().getLineNr()).append(", index: ").append(e.getLocation().getColumnNr()).append("</b>");
                }
                String err = errorMessage.toString().replaceAll("\n", "<p>");
                throw new DeserializeJsonConfigFailedException(err, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new DeserializeErrorInFileException(flowConfigPath, processJsonNode, e);
            }
        }
    }

    private void parseSections(ProjectConfiguration flowConfig, JsonNode node, Path flowConfigPath, SectionConfiguration parentSection) {
        JsonNode sections = node.get("sections");
        int sectionPlace = -1;
        for (JsonNode section : sections) {
            SectionConfiguration flowConfigSection = new SectionConfiguration();
            try {
                flowConfigSection.setId(this.getSectionId(section, parentSection == null ? null : parentSection.getId()));
                flowConfigSection.setName(section.get("name").asText());
                flowConfigSection.setParentSection(parentSection);
                flowConfigSection.setPlace(++sectionPlace);
            }
            catch (NullPointerException e) {
                log.error("Can't parse section, because it null");
            }
            if (section.has("processes")) {
                this.parseProcessesOrCompound(flowConfig, flowConfigPath, section.get("processes"), flowConfigSection);
            }
            if (section.has("sections")) {
                this.parseSections(flowConfig, section, flowConfigPath, flowConfigSection);
            }
            flowConfigSection.setProjectConfiguration(flowConfig);
            if (parentSection == null) {
                flowConfig.getSections().add(flowConfigSection);
                continue;
            }
            parentSection.getSections().add(flowConfigSection);
        }
    }

    private void updateConfigWithDefaultSystem(List<ProcessConfiguration> processes, String defaultSystem) {
        processes.forEach(p -> {
            ProcessSettings proc = p.getProcessSettings();
            proc.getCommand().setSystemIfNull(defaultSystem);
            if (proc.getPrerequisites() != null) {
                proc.getPrerequisites().forEach(prereq -> prereq.setSystemIfNull(defaultSystem));
            }
            if (proc.getValidations() != null) {
                proc.getValidations().forEach(valid -> valid.setSystemIfNull(defaultSystem));
            }
            if (proc.getInputs() != null) {
                proc.getInputs().forEach(imp -> imp.setSystemIfNull(defaultSystem));
            }
        });
    }

    public ConfigurationFileDeserializer(EnvironmentsService environmentsService, GridFsService gridFsService, AtpUserService atpUserService) {
        this.environmentsService = environmentsService;
        this.gridFsService = gridFsService;
        this.atpUserService = atpUserService;
    }

    private static /* synthetic */ void lambda$parseIsolatedProcesses$10(String procName, ProcessConfiguration processConfiguration, ProcessConfiguration p) {
        if (p.getName().equals(procName)) {
            processConfiguration.setId(p.getId());
        }
    }
}

