/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.MoveDirectoryRequestDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoriesDto;
import org.qubership.atp.mia.controllers.api.dto.ProjectDirectoryDto;
import org.qubership.atp.mia.exceptions.configuration.CreateDirectoryException;
import org.qubership.atp.mia.exceptions.configuration.DeleteDirectoryException;
import org.qubership.atp.mia.exceptions.configuration.DirectoryCyclicDependencyException;
import org.qubership.atp.mia.exceptions.configuration.DirectoryNotFoundException;
import org.qubership.atp.mia.exceptions.configuration.DuplicateDirectoryException;
import org.qubership.atp.mia.exceptions.configuration.UpdateDirectoryException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.file.ProjectDirectory;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.repo.configuration.DirectoryConfigurationRepository;
import org.qubership.atp.mia.service.configuration.FileConfigurationService;
import org.qubership.atp.mia.service.configuration.ProjectConfigurationService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DirectoryConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(DirectoryConfigurationService.class);
    private final DirectoryConfigurationRepository directoryConfigurationRepository;
    private final GridFsService gridFsService;
    private final ModelMapper modelMapper;
    private final ProjectConfigurationService projectConfigurationService;
    private final FileConfigurationService fileConfigurationService;

    public void addDirectory(ProjectConfiguration projectConfiguration, ProjectDirectoryDto projectDirectoryDto) {
        log.info("Create directory: '{}'", (Object)projectDirectoryDto);
        if (projectConfiguration.getAllDirectories().stream().anyMatch(dir -> {
            if (dir.getName().equals(projectDirectoryDto.getName())) {
                if (dir.getParentDirectory() != null) {
                    return dir.getParentDirectory().getId().equals(projectDirectoryDto.getParentDirectoryId());
                }
                return projectDirectoryDto.getParentDirectoryId() == null;
            }
            return false;
        })) {
            throw new DuplicateDirectoryException(projectDirectoryDto.getName());
        }
        try {
            ProjectDirectory parentDirectory = projectDirectoryDto.getParentDirectoryId() == null ? null : DirectoryConfigurationService.getDirectoryById(projectConfiguration, projectDirectoryDto.getParentDirectoryId());
            ProjectDirectory projectDirectory = (ProjectDirectory)this.modelMapper.map((Object)projectDirectoryDto, ProjectDirectory.class);
            projectDirectory.setProjectConfiguration(projectConfiguration);
            projectConfiguration.getDirectories().add(projectDirectory);
            if (parentDirectory != null) {
                parentDirectory.getDirectories().add(projectDirectory);
                projectDirectory.setParentDirectory(parentDirectory);
            }
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.directoryConfigurationRepository.save(projectDirectory);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new CreateDirectoryException(e);
        }
    }

    public void deleteDirectory(ProjectConfiguration projectConfiguration, UUID directoryId) {
        log.info("Delete directory with ID '{}'", (Object)directoryId);
        Optional<ProjectDirectory> optionalProjectDirectory = projectConfiguration.getDirectories().stream().filter(dir -> dir.getId().equals(directoryId)).findAny();
        if (!optionalProjectDirectory.isPresent()) {
            throw new DirectoryNotFoundException(directoryId);
        }
        try {
            this.deleteWholeDirectory(projectConfiguration, optionalProjectDirectory.get());
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.directoryConfigurationRepository.deleteById(directoryId);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new DeleteDirectoryException(e);
        }
    }

    public ProjectDirectoriesDto directoriesDto(ProjectConfiguration projectConfiguration) {
        DateAuditorEntity rootProjectDirectory = ((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)((ProjectDirectory.ProjectDirectoryBuilder)ProjectDirectory.builder().name("MIA_ROOT_DIRECTORY")).directories(projectConfiguration.getRootDirectories())).files(projectConfiguration.getRootFiles())).build();
        return (ProjectDirectoriesDto)this.modelMapper.map((Object)rootProjectDirectory, ProjectDirectoriesDto.class);
    }

    public static ProjectDirectory getDirectoryById(ProjectConfiguration projectConfig, UUID projectDirectoryId) {
        return projectConfig.getDirectories().stream().filter(d -> d.getId().equals(projectDirectoryId)).findFirst().orElseThrow(() -> new DirectoryNotFoundException(projectDirectoryId));
    }

    public void moveDirectory(ProjectConfiguration projectConfiguration, UUID directoryId, MoveDirectoryRequestDto moveDirectoryRequestDto) {
        log.info("Move directory '{}' to {}", (Object)directoryId, (Object)moveDirectoryRequestDto);
        ProjectDirectory projectDirectory = this.checkAndGetDirectory(projectConfiguration, directoryId, moveDirectoryRequestDto.getParentDirectory());
        try {
            UUID parentDirectoryId = moveDirectoryRequestDto.getParentDirectory();
            ProjectDirectory parentDirectory = null;
            if (parentDirectoryId != null) {
                parentDirectory = DirectoryConfigurationService.getDirectoryById(projectConfiguration, parentDirectoryId);
                parentDirectory.getDirectories().add(projectDirectory);
            }
            if (projectDirectory.getParentDirectory() != null) {
                projectDirectory.getParentDirectory().getDirectories().remove(projectDirectory);
            }
            projectDirectory.setParentDirectory(parentDirectory);
            this.updateFilesPathOfDirectory(projectDirectory);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.directoryConfigurationRepository.save(projectDirectory);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new UpdateDirectoryException(e);
        }
    }

    public void updateDirectory(ProjectConfiguration projectConfiguration, ProjectDirectoryDto projectDirectoryDto) {
        log.info("Update directory: '{}'", (Object)projectDirectoryDto);
        ProjectDirectory projectDirectory = this.checkAndGetDirectory(projectConfiguration, projectDirectoryDto.getId(), projectDirectoryDto.getParentDirectoryId());
        try {
            projectDirectory.setName(projectDirectoryDto.getName());
            this.updateFilesPathOfDirectory(projectDirectory);
            this.projectConfigurationService.synchronizeConfiguration(projectConfiguration.getProjectId(), () -> {
                this.directoryConfigurationRepository.save(projectDirectory);
                return projectConfiguration;
            }, true);
        }
        catch (Exception e) {
            throw new UpdateDirectoryException(e);
        }
    }

    private ProjectDirectory checkAndGetDirectory(ProjectConfiguration projectConfiguration, UUID directoryId, UUID parentDirectoryId) {
        ProjectDirectory projectDirectory = projectConfiguration.getDirectories().stream().filter(dir -> dir.getId().equals(directoryId)).findFirst().orElseThrow(() -> new DirectoryNotFoundException(directoryId));
        if (parentDirectoryId != null && projectDirectory.getChildrenUuid().contains(parentDirectoryId)) {
            throw new DirectoryCyclicDependencyException(directoryId, parentDirectoryId);
        }
        return projectDirectory;
    }

    private void deleteWholeDirectory(ProjectConfiguration projectConfiguration, ProjectDirectory projectDirectory) {
        this.deleteWholeDirectory(projectConfiguration, projectDirectory, true);
    }

    private void deleteWholeDirectory(ProjectConfiguration projectConfiguration, ProjectDirectory projectDirectory, boolean deleteFromParent) {
        log.warn("Delete directory {} with ID '{}'", (Object)projectDirectory.getName(), (Object)projectDirectory.getId());
        if (!projectDirectory.getDirectories().isEmpty()) {
            projectDirectory.getDirectories().forEach(d -> this.deleteWholeDirectory(projectConfiguration, (ProjectDirectory)d, false));
            projectDirectory.setDirectories(new ArrayList<ProjectDirectory>());
        }
        if (!projectDirectory.getFiles().isEmpty()) {
            projectDirectory.getFiles().forEach(f -> this.fileConfigurationService.deleteFile(projectConfiguration, (ProjectFile)f, false));
            projectDirectory.setFiles(new ArrayList<ProjectFile>());
        }
        if (projectDirectory.getParentDirectory() != null && deleteFromParent) {
            projectDirectory.getParentDirectory().getDirectories().remove(projectDirectory);
        }
        projectConfiguration.getDirectories().remove(projectDirectory);
    }

    private void updateFilesPathOfDirectory(ProjectDirectory projectDirectory) {
        log.info("Update path for files in directory {} with ID {}", (Object)projectDirectory.getName(), (Object)projectDirectory.getId());
        if (!projectDirectory.getFiles().isEmpty()) {
            projectDirectory.getFiles().forEach(this.gridFsService::rename);
        }
        if (!projectDirectory.getDirectories().isEmpty()) {
            projectDirectory.getDirectories().forEach(this::updateFilesPathOfDirectory);
        }
    }

    public DirectoryConfigurationService(DirectoryConfigurationRepository directoryConfigurationRepository, GridFsService gridFsService, ModelMapper modelMapper, ProjectConfigurationService projectConfigurationService, FileConfigurationService fileConfigurationService) {
        this.directoryConfigurationRepository = directoryConfigurationRepository;
        this.gridFsService = gridFsService;
        this.modelMapper = modelMapper;
        this.projectConfigurationService = projectConfigurationService;
        this.fileConfigurationService = fileConfigurationService;
    }
}

