/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.atp.mia.clients.api.environments.dto.projects.EnvironmentsWithFilterRequestDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.FilterRequestDto;
import org.qubership.atp.mia.clients.api.environments.dto.projects.SystemEnvironmentsViewDto;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.IncorrectEnvironmentResponseException;
import org.qubership.atp.mia.model.environment.AbstractConfiguratorModel;
import org.qubership.atp.mia.model.environment.Environment;
import org.qubership.atp.mia.model.environment.Project;
import org.qubership.atp.mia.service.client.EnvironmentsFeignClient;
import org.qubership.atp.mia.service.client.ProjectsFeignClient;
import org.qubership.atp.mia.utils.converters.DtoConvertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class EnvironmentsService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsService.class);
    private final EnvironmentsFeignClient environmentsFeignClient;
    private final ProjectsFeignClient projectsFeignClient;
    private final DtoConvertService responseEntityConverter;
    private final EnvironmentsService self;

    @Cacheable(value={"ATP_MIA_ENVIRONMENTS_BY_NAME"}, key="#projectId.toString() + \"_\" + #name", condition="#projectId!=null", sync=true)
    public Environment getEnvByName(UUID projectId, String name) {
        EnvironmentsWithFilterRequestDto requestDto = new EnvironmentsWithFilterRequestDto().projectId(projectId).addFieldsItem("id").addFieldsItem("name").addFieldsItem("systems").filter(Collections.singletonList(new FilterRequestDto().name("name").addValueItem(name)));
        List foundEnvironments = (List)this.environmentsFeignClient.getEnvironmentsByRequest(true, null, null, requestDto).getBody();
        return CollectionUtils.isEmpty((Collection)foundEnvironments) ? null : this.responseEntityConverter.convertList(foundEnvironments, Environment.class).get(0);
    }

    @Cacheable(value={"ATP_MIA_ENVIRONMENTS"}, key="#projectId", condition="#projectId!=null")
    public List<AbstractConfiguratorModel> getEnvironmentsByProject(UUID projectId) {
        return this.responseEntityConverter.convertList((List)this.projectsFeignClient.getEnvironmentsShort(projectId).getBody(), AbstractConfiguratorModel.class);
    }

    @Cacheable(value={"ATP_MIA_ENVIRONMENTSFULL"}, key="#projectId + \"_\" + #id", condition="#id!=null")
    public Environment getEnvironmentsFull(UUID id, UUID projectId) {
        try {
            return this.responseEntityConverter.convert(this.environmentsFeignClient.getEnvironment(id, true).getBody(), Environment.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse response environment with id: " + id, e);
        }
    }

    public Project getProject(UUID projectId) {
        try {
            return this.responseEntityConverter.convert(this.projectsFeignClient.getShortProject(projectId, false).getBody(), Project.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse response for project with id: " + projectId, e);
        }
    }

    @Cacheable(value={"ATP_MIA_PROJECTS"}, sync=true)
    public List<AbstractConfiguratorModel> getProjects() {
        try {
            List<AbstractConfiguratorModel> projects = this.responseEntityConverter.convertList((List)this.projectsFeignClient.getAllShort(false).getBody(), AbstractConfiguratorModel.class);
            return projects;
        }
        catch (Exception e) {
            throw new IncorrectEnvironmentResponseException(e);
        }
    }

    @Cacheable(value={"ATP_MIA_SYSTEM_NAMES"}, key="#projectId", condition="#projectId!=null", sync=true)
    public List<SystemEnvironmentsViewDto> getSystemsForProject(UUID projectId) {
        return (List)this.projectsFeignClient.getAllShortSystemsOnProject(projectId).getBody();
    }

    public EnvironmentsService(EnvironmentsFeignClient environmentsFeignClient, ProjectsFeignClient projectsFeignClient, DtoConvertService responseEntityConverter, EnvironmentsService self) {
        this.environmentsFeignClient = environmentsFeignClient;
        this.projectsFeignClient = projectsFeignClient;
        this.responseEntityConverter = responseEntityConverter;
        this.self = self;
    }
}

