/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.SerializationUtils;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.qubership.atp.mia.exceptions.configuration.CurrentStatementListIsEmptyException;
import org.qubership.atp.mia.exceptions.configuration.ProcessOrCompoundNotFoundException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.EnvConnectionNotFoundInContextException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.EnvConnectionNotFoundInContextOrNullException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.EnvSystemNotFoundException;
import org.qubership.atp.mia.exceptions.externalsystemintegrations.EnvSystemNotFoundInContextException;
import org.qubership.atp.mia.exceptions.macrosandevaluations.PatternCompileException;
import org.qubership.atp.mia.exceptions.prerequisite.PrerequisiteNoRecordsAddedException;
import org.qubership.atp.mia.exceptions.prerequisite.PrerequisiteQueryNotValidException;
import org.qubership.atp.mia.exceptions.prerequisite.PrerequisiteTypeUnsupportedException;
import org.qubership.atp.mia.exceptions.runtimeerrors.UnsupportedCommandException;
import org.qubership.atp.mia.model.Constants;
import org.qubership.atp.mia.model.configuration.CompoundConfiguration;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.configuration.ProjectConfiguration;
import org.qubership.atp.mia.model.configuration.Switcher;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.executable.CommandType;
import org.qubership.atp.mia.model.impl.executable.Prerequisite;
import org.qubership.atp.mia.model.impl.executable.ProcessSettings;
import org.qubership.atp.mia.model.impl.executable.TableMarker;
import org.qubership.atp.mia.model.impl.executable.Validation;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.impl.request.ExecutionRequest;
import org.qubership.atp.mia.model.pot.ProcessStatus;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.TableMarkerResult;
import org.qubership.atp.mia.repo.impl.ProcessStatusRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.SseEmitterService;
import org.qubership.atp.mia.service.execution.RecordingSessionsService;
import org.qubership.atp.mia.service.execution.RestExecutionHelperService;
import org.qubership.atp.mia.service.execution.SoapExecutionHelperService;
import org.qubership.atp.mia.service.execution.SqlExecutionHelperService;
import org.qubership.atp.mia.service.execution.SshExecutionHelperService;
import org.qubership.atp.mia.service.execution.TestDataService;
import org.qubership.atp.mia.service.file.GridFsService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.qubership.atp.mia.utils.FileUtils;
import org.qubership.atp.mia.utils.HttpUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessService.class);
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;
    private final SshExecutionHelperService sshService;
    private final TestDataService testDataService;
    private final SqlExecutionHelperService sqlService;
    private final RestExecutionHelperService restService;
    private final SoapExecutionHelperService soapService;
    private final MetricsAggregateService metricsService;
    private final RecordingSessionsService recordingSessionsService;
    private final GridFsService gridFsService;
    private final ProcessStatusRepository processStatusRepository;
    private final String fileDownloadPrefix;
    private final String miaEntityUrlFormat;
    private final SseEmitterService sseEmitterService;

    @Deprecated
    public void executeCommandOnLocalHost(String command) {
    }

    @AtpJaegerLog(spanTags={@AtpSpanTag(key="current.statement.name", value="#executableName")})
    public List<SqlResponse> executeCurrentStatement(String executableName) {
        ArrayList<Validation> currentStatement = new ArrayList<Validation>();
        Optional<ProcessConfiguration> optionalProcess = this.miaContext.getConfig().getProcessByNameSafe(executableName);
        if (optionalProcess.isPresent()) {
            if (optionalProcess.get().getProcessSettings().getCurrentStatement() != null) {
                currentStatement.addAll(optionalProcess.get().getProcessSettings().getCurrentStatement());
            }
        } else {
            Optional<CompoundConfiguration> optionalCompound = this.miaContext.getConfig().getCompoundByNameSafe(executableName);
            if (optionalCompound.isPresent()) {
                optionalCompound.get().getProcesses().forEach(p -> {
                    if (p.getProcessSettings().getCurrentStatement() != null) {
                        currentStatement.addAll(p.getProcessSettings().getCurrentStatement());
                    }
                });
            } else {
                throw new ProcessOrCompoundNotFoundException(executableName);
            }
        }
        if (currentStatement.isEmpty()) {
            throw new CurrentStatementListIsEmptyException(executableName);
        }
        return this.sqlService.executeValidations(currentStatement, new Command());
    }

    @AtpJaegerLog(spanTags={@AtpSpanTag(key="process.name", value="#request.process")})
    public ExecutionResponse executeProcess(ExecutionRequest request, UUID sseId) {
        long startDate = System.currentTimeMillis();
        ProjectConfiguration config = this.miaContext.getConfig();
        this.metricsService.processExecutionWasStarted();
        this.miaContext.replaceSpacesInAccountNumber();
        ProcessConfiguration process = config.getProcessByName(request.getProcess());
        MDC.put((String)"miaProcessId", (String)process.getId().toString());
        log.info("Execute process {}", (Object)process.getName());
        List switchersListFromBe = null;
        List switchersListFromFe = null;
        if (config.getHeaderConfiguration() != null) {
            List<Object> userSwitchersBe = config.getHeaderConfiguration().getSwitchers() != null ? config.getHeaderConfiguration().getSwitchers() : new ArrayList();
            List<Switcher> systemSwitchersBe = config.getHeaderConfiguration().getSystemSwitchers();
            List systemSwitchersBeClone = systemSwitchersBe.stream().map(sbe -> sbe.clone()).collect(Collectors.toList());
            switchersListFromBe = Stream.of(userSwitchersBe, systemSwitchersBeClone).flatMap(x -> x.stream()).collect(Collectors.toList());
        }
        if (request != null) {
            ArrayList userSwitchersFe = request.getSwitchers() != null ? request.getSwitchers() : new ArrayList();
            ArrayList systemSwitchersFe = request.getSystemSwitchers() != null ? request.getSystemSwitchers() : new ArrayList();
            switchersListFromFe = Stream.of(userSwitchersFe, systemSwitchersFe).flatMap(x -> x.stream()).collect(Collectors.toList());
        }
        this.getActualStateOfSwitchers(switchersListFromBe, switchersListFromFe);
        ProcessSettings processSettings = (ProcessSettings)SerializationUtils.clone((Serializable)process.getProcessSettings());
        Command configCommand = processSettings.getCommand();
        if (request.getCommand() != null && !request.getCommand().isEmpty()) {
            String labelOrCommand = request.getCommand();
            if (configCommand.getAtpValues().containsKey(labelOrCommand)) {
                configCommand.setToExecute(configCommand.getAtpValues().get(labelOrCommand));
            } else {
                configCommand.setToExecute(labelOrCommand);
            }
        } else if (request.getRest() != null) {
            configCommand.setRest(request.getRest());
        } else {
            configCommand.setToExecute(configCommand.getValue());
        }
        ExecutionResponse response = this.executeProcess(this.replaceProcessSystems(processSettings), switchersListFromBe);
        response.setEntityId(process.getId());
        response.setEntityUrl(HttpUtils.getMiaEntityUrl(this.miaEntityUrlFormat, this.miaContext.getProjectId(), process.getId()));
        this.recordingSessionsService.addExecutionStep(response);
        this.gridFsService.saveLogResponseAfterExecution(response);
        response.setDuration(Utils.calculateDuration(startDate));
        this.sseEmitterService.updateResponseAndSendToEmitter(response, sseId, true, 0);
        return response;
    }

    private ExecutionResponse executeProcess(ProcessSettings processSettings, List<Switcher> switchersListFromBe) {
        ExecutionResponse executionResponse = new ExecutionResponse();
        executionResponse.setProcessName(processSettings.getName());
        executionResponse.setProcessStatus(new ProcessStatus());
        Command command = processSettings.getCommand();
        if (switchersListFromBe != null) {
            switchersListFromBe.forEach(switcher -> {
                if (switcher.getActionType() != null && switcher.getActionType().equals("SQL")) {
                    if (switcher.isValue() && switcher.getActionTrue() != null) {
                        processSettings.addPrerequisites(new Prerequisite(switcher.getActionType(), this.miaContext.getConfig().getCommonConfiguration().getDefaultSystem(), switcher.getActionTrue()));
                    }
                    if (!switcher.isValue() && switcher.getActionFalse() != null) {
                        processSettings.addPrerequisites(new Prerequisite(switcher.getActionType(), this.miaContext.getConfig().getCommonConfiguration().getDefaultSystem(), switcher.getActionFalse()));
                    }
                }
            });
        }
        if (processSettings.getPrerequisites() != null) {
            executionResponse.setPrerequisites(this.executePrerequisites(processSettings.getPrerequisites(), command));
        }
        if (switchersListFromBe != null) {
            switchersListFromBe.forEach(switcher -> {
                if (switcher.getActionType() != null && switcher.getActionType().equals("SSH") && command.getType().contains("SSH")) {
                    if (switcher.isValue() && switcher.getActionTrue() != null) {
                        command.setToExecute(switcher.getActionTrue() + "\n" + command.getToExecute());
                    }
                    if (!switcher.isValue() && switcher.getActionFalse() != null) {
                        command.setToExecute(switcher.getActionFalse() + "\n" + command.getToExecute());
                    }
                }
            });
        }
        if (Strings.isNullOrEmpty((String)command.getSystem())) {
            command.setSystem(this.miaContext.getConfig().getCommonConfiguration().getDefaultSystem());
        }
        try {
            this.miaContext.getFlowData().getSystem(command.getSystem());
        }
        catch (Exception e) {
            throw new EnvSystemNotFoundException(command.getSystem());
        }
        if (command.getToExecute() != null) {
            executionResponse.setExecutedCommand(this.miaContext.evaluate(command.getToExecute()));
        }
        executionResponse.setCommandResponse(this.executeCommand(command));
        this.validateProcessStatus(executionResponse);
        if (command.getRest() != null) {
            String statusCode = executionResponse.getCommandResponse().getConnectionInfo().get("code");
            executionResponse.getCommandResponse().setStatusCode(statusCode);
            boolean isCheckStatusCodeFlag = command.getRest().isCheckStatusCodeFlag();
            executionResponse.getCommandResponse().setCheckStatusCodeFlag(isCheckStatusCodeFlag);
            if (isCheckStatusCodeFlag) {
                executionResponse.getCommandResponse().setExpectedCodes(command.getRest().getCheckStatusCode());
                this.processStatusRepository.parseReturnCodeAndUpdateStatus(executionResponse);
            }
        }
        this.processStatusRepository.parseLogMarkers(executionResponse.getProcessStatus(), command);
        this.processStatusRepository.parseLogStatus(executionResponse);
        List<Validation> validations = processSettings.getValidations();
        if (validations != null) {
            executionResponse.setValidations(this.sqlService.executeValidations(validations, command));
            if (validations.stream().anyMatch(validation -> validation.getTableMarker() != null) || validations.stream().anyMatch(validation -> validation.getExportVariables() != null)) {
                this.addValidationStatusAndSaveVariables(executionResponse, validations);
            }
        }
        if (processSettings.getGlobalVariables() != null) {
            HashMap<String, String> globalVariables = new HashMap<String, String>();
            processSettings.getGlobalVariables().forEach((globalVariableKey, globalVariableValue) -> {
                String value;
                if (globalVariableValue != null && (value = this.miaContext.evaluate((String)globalVariableValue)) != null) {
                    globalVariables.put((String)globalVariableKey, value);
                    log.info("Parameter '{}' saved as '{}' to globalVariables", (Object)value, globalVariableKey);
                }
            });
            executionResponse.setGlobalVariables(globalVariables);
        }
        return executionResponse;
    }

    public void fillFlowDataWithEnvVars(String system, CommandResponse.CommandResponseType type) {
        if (!type.equals((Object)CommandResponse.CommandResponseType.NO_SYSTEM_REQUIRED)) {
            String connection = CommandResponse.getConnectionNameFromResponseType(type);
            this.fillFlowDataWithEnvVars(system, connection);
        }
    }

    public void fillFlowDataWithEnvVars(String system, String connection) {
        if (Strings.isNullOrEmpty((String)system) || Strings.isNullOrEmpty((String)connection)) {
            log.warn("System or connection is empty. Cannot fulfill variables.");
            return;
        }
        try {
            Server server = this.miaContext.getFlowData().getSystem(system).getServer(connection);
            this.miaContext.getFlowData().addParameters(server.getProperties().entrySet().stream().collect(Collectors.toMap(k -> {
                if (((String)k.getKey()).equals("url")) {
                    return ((String)k.getKey()).toUpperCase();
                }
                return (String)k.getKey();
            }, Map.Entry::getValue, (v1, v2) -> v1)));
            this.miaContext.getFlowData().addParameter("Connection_UID", server.getConnection().getId().toString());
            this.miaContext.getFlowData().addParameter("System_UID", server.getConnection().getSystemId().toString());
        }
        catch (IllegalArgumentException e) {
            throw new EnvConnectionNotFoundInContextException(connection, system);
        }
        catch (NullPointerException e) {
            throw new EnvConnectionNotFoundInContextOrNullException(system, connection);
        }
        catch (RuntimeException e) {
            throw new EnvSystemNotFoundInContextException(system);
        }
    }

    public String getNextBillDate() {
        return this.sqlService.getNextBillDate();
    }

    public ProcessSettings replaceProcessSystems(ProcessSettings processSettings) {
        processSettings.getCommand().setSystem(this.miaContext.evaluate(processSettings.getCommand().getSystem()));
        if (processSettings.getPrerequisites() != null) {
            processSettings.getPrerequisites().stream().forEach(prerequisite -> prerequisite.setSystem(this.miaContext.evaluate(prerequisite.getSystem())));
        }
        if (processSettings.getValidations() != null) {
            processSettings.getValidations().stream().forEach(validation -> validation.setSystem(this.miaContext.evaluate(validation.getSystem())));
        }
        return processSettings;
    }

    public boolean resetDbCache() {
        return this.sqlService.resetDbCache();
    }

    private void addPrefixToDownloadLinks(CommandResponse commandResponse) {
        if (commandResponse.getSqlResponse() != null && commandResponse.getSqlResponse().getLink() != null) {
            commandResponse.getSqlResponse().getLink().setPath(this.fileDownloadPrefix + commandResponse.getSqlResponse().getLink().getPath());
        }
        if (commandResponse.getCommandOutputs() != null && commandResponse.getCommandOutputs().size() > 0) {
            commandResponse.getCommandOutputs().forEach(commandOutput -> commandOutput.getLink().setPath(this.fileDownloadPrefix + commandOutput.getLink().getPath()));
        }
    }

    private void addValidationStatusAndSaveVariables(ExecutionResponse executionResponse, List<Validation> validations) {
        for (SqlResponse sqlResponse : executionResponse.getValidations()) {
            Optional<Validation> validationOption = validations.stream().filter(v -> {
                if (v.getValue().contains(".sql")) {
                    String content = this.miaContext.evaluate(FileUtils.readFile(this.miaFileService.getFile(v.getValue()).toPath()));
                    return content.contains(sqlResponse.getQuery());
                }
                return this.miaContext.evaluate(v.getValue()).equals(sqlResponse.getQuery());
            }).findFirst();
            if (!validationOption.isPresent()) {
                log.debug("Validation options is not present, setting status to: FAIL");
                executionResponse.getProcessStatus().setStatus(Statuses.FAIL);
                continue;
            }
            Validation validation = validationOption.get();
            TableMarker tableMarker = validation.getTableMarker();
            if (tableMarker != null && (tableMarker.getTableRowCount() != null || MapUtils.isNotEmpty(tableMarker.getExpectedResultForQuery()))) {
                tableMarker = this.miaContext.evaluateTableMarker(validation.getTableMarker());
                TableMarkerResult tableMarkerResult = this.processTableWithTableMarker(tableMarker, sqlResponse);
                if (tableMarkerResult.getColumnStatuses() != null) {
                    for (TableMarkerResult.TableMarkerColumnStatus tableMarkerColumnStatus : tableMarkerResult.getColumnStatuses()) {
                        if (tableMarkerColumnStatus.getStatus() != Statuses.FAIL) continue;
                        log.debug("Table Marker Column Status is FAIL, so setting response status to: FAIL");
                        executionResponse.getProcessStatus().setStatus(Statuses.FAIL);
                        break;
                    }
                }
                if (tableMarkerResult.getTableRowCount() != null && tableMarkerResult.getTableRowCount().getStatus() == Statuses.FAIL) {
                    log.debug("Table Row Count status is FAIL, so setting response status to: FAIL");
                    executionResponse.getProcessStatus().setStatus(Statuses.FAIL);
                }
                sqlResponse.setTableMarkerResult(tableMarkerResult);
            }
            if (validation.getExportVariables() == null) continue;
            for (Map.Entry<String, String> entry : validation.getExportVariables().entrySet()) {
                String value;
                String columnName = entry.getValue();
                String variableName = entry.getKey();
                if (sqlResponse.getRecords() == 0) {
                    value = "Not Found";
                } else if (!sqlResponse.getData().getColumns().stream().filter(s -> s.equalsIgnoreCase(columnName)).findFirst().isPresent()) {
                    value = "Column '" + columnName + "' not found";
                } else {
                    String returnColumnName = sqlResponse.getData().getColumns().stream().filter(s -> s.equalsIgnoreCase(columnName)).findFirst().get();
                    int rowIndex = 0;
                    if (sqlResponse.getData().getData().get(0).get(0).equals("ER")) {
                        rowIndex = 1;
                    }
                    value = sqlResponse.getData().getData().get(rowIndex).get(sqlResponse.getData().getColumns().indexOf(returnColumnName));
                }
                this.miaContext.getFlowData().addParameter(variableName, value);
                log.info("Parameter '{}' saved as '{}' from table record", (Object)value, (Object)variableName);
            }
        }
    }

    private boolean checkInput(List<String> inputNamesToRefer) {
        Map<String, String> params = this.miaContext.getFlowData().getParameters();
        if (inputNamesToRefer != null) {
            for (String inputName : inputNamesToRefer) {
                if (!params.containsKey(inputName) || Strings.isNullOrEmpty((String)params.get(inputName))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private CommandResponse executeCommand(Command command) {
        CommandResponse commandResponse;
        String type = command.getType();
        CommandType commandType = CommandType.valueOf(type);
        CommandResponse.CommandResponseType responseType = CommandType.getResponseType(commandType);
        this.fillFlowDataWithEnvVars(command.getSystem(), responseType);
        if (CommandType.isTestData(commandType)) {
            this.metricsService.testDataExecutionWasStarted();
        }
        switch (commandType) {
            case SSH: {
                commandResponse = this.sshService.executeSingleCommand(command);
                break;
            }
            case SSH_CheckFileOnServer: {
                commandResponse = this.sshService.executeCommandAndCheckFileOnServer(command);
                break;
            }
            case SSH_TransferFile: {
                commandResponse = this.sshService.executeCommandAndTransferFileOnServer(command);
                break;
            }
            case SSH_GenerationFile: {
                commandResponse = this.sshService.executeCommandAndGenerateFile(command);
                break;
            }
            case SQL: {
                commandResponse = this.sqlService.executeCommand(command.getToExecute(), command.getSystem()).stream().findFirst().orElse(new CommandResponse());
                break;
            }
            case SSH_UploadFileAndDownloadResult: {
                commandResponse = this.sshService.uploadFilesAndDownloadResults(command);
                break;
            }
            case SSH_DownloadFiles: {
                commandResponse = this.sshService.executeCommandAndDownloadFilesFromServer(command);
                break;
            }
            case SSH_GenerateEvent: {
                commandResponse = this.sshService.generateEventFilesAndExecuteCommand(command);
                break;
            }
            case SSH_UploadFile: {
                commandResponse = this.sshService.executeCommandAndUploadFile(command);
                break;
            }
            case REST: {
                commandResponse = this.restService.sendRestRequest(command);
                break;
            }
            case SOAP: {
                commandResponse = this.soapService.sendSoapRequest(command);
                break;
            }
            case SOAP_FROM_TEST_DATA: {
                commandResponse = this.testDataService.soap(command);
                break;
            }
            case REST_FROM_TEST_DATA: {
                commandResponse = this.testDataService.rest(command);
                break;
            }
            case VALIDATE_TEST_DATA: {
                commandResponse = this.testDataService.validate(command);
                break;
            }
            case EVENT_TEST_DATA: {
                commandResponse = this.testDataService.event(command);
                break;
            }
            case SSH_FROM_TEST_DATA: {
                commandResponse = this.testDataService.ssh(command);
                break;
            }
            case SQL_FROM_TEST_DATA: {
                commandResponse = this.testDataService.sql(command);
                break;
            }
            default: {
                throw new UnsupportedCommandException(type);
            }
        }
        if (commandResponse != null) {
            commandResponse.setType(responseType);
            this.addPrefixToDownloadLinks(commandResponse);
        }
        this.getVariablesFromLogs(commandType, commandResponse, command);
        return commandResponse;
    }

    private List<CommandResponse> executePrerequisites(List<Prerequisite> prerequisites, Command command) {
        ArrayList<CommandResponse> responses = new ArrayList<CommandResponse>();
        ArrayList<String> sshPrerequisitesToExecute = new ArrayList<String>();
        for (Prerequisite prerequisite2 : prerequisites) {
            if (this.skipPrerequisite(prerequisite2, command)) {
                log.debug("Prerequisite " + prerequisite2 + " has been skipped");
                continue;
            }
            log.debug("Execute prerequisite: " + prerequisite2);
            String type = prerequisite2.getType();
            if (CommandType.SQL.toString().equals(type)) {
                List<CommandResponse> prerequisiteResponses = this.sqlService.executeCommand(prerequisite2.getValue(), prerequisite2.getSystem());
                responses.addAll(prerequisiteResponses);
                this.saveSqlPrerequisiteResponseToFlowData(prerequisite2, prerequisiteResponses);
                continue;
            }
            if (CommandType.SSH.toString().equals(type)) {
                sshPrerequisitesToExecute.add(prerequisite2.getValue());
                continue;
            }
            if ("COMMAND_ON_LOCALHOST".equals(type)) {
                prerequisite2.getValues().forEach(c -> this.executeCommandOnLocalHost((String)c));
                continue;
            }
            throw new PrerequisiteTypeUnsupportedException(type);
        }
        sshPrerequisitesToExecute.forEach(prerequisite -> {
            String currentCommandValue = command.getToExecute();
            command.setToExecute(prerequisite + this.miaContext.getConfig().getCommonConfiguration().getCommandShellSeparator() + currentCommandValue);
        });
        return responses;
    }

    private boolean filterQueryType(CommandResponse r) {
        String query = r.getSqlResponse().getQuery().toLowerCase();
        return Constants.sqlOperators.stream().anyMatch(query::startsWith);
    }

    public void getActualStateOfSwitchers(List<Switcher> switchersListFromBe, List<Switcher> switchersListFromFe) {
        log.info("Actualization of switchers state");
        if (switchersListFromBe != null && switchersListFromFe != null) {
            ArrayList<Switcher> finalSwitchersListFromFe = new ArrayList<Switcher>(switchersListFromFe);
            switchersListFromBe.forEach(sBe -> sBe.setValue(finalSwitchersListFromFe.stream().filter(sFe -> sFe.getName().equals(sBe.getName())).findAny().orElse((Switcher)sBe).isValue()));
        }
    }

    private void getVariablesFromLogs(CommandType commandType, CommandResponse commandResponse, Command command) {
        switch (commandType) {
            case SQL: 
            case SOAP_FROM_TEST_DATA: 
            case REST_FROM_TEST_DATA: 
            case VALIDATE_TEST_DATA: 
            case EVENT_TEST_DATA: 
            case SSH_FROM_TEST_DATA: 
            case SQL_FROM_TEST_DATA: {
                break;
            }
            default: {
                if (commandResponse == null || commandResponse.getCommandOutputs() == null || command.getVariablesToExtractFromLog() == null) break;
                this.saveVariableFromLog(commandResponse, command.getVariablesToExtractFromLog());
            }
        }
    }

    private TableMarkerResult processTableWithTableMarker(TableMarker tableMarker, SqlResponse table) {
        TableMarkerResult tableMarkerResult = new TableMarkerResult();
        if (tableMarker.getExpectedResultForQuery() != null) {
            ArrayList<List<String>> processedData = new ArrayList<List<String>>();
            ArrayList<String> expectedResults = new ArrayList<String>();
            ArrayList<String> actualResults = new ArrayList<String>();
            ArrayList<String> processedColumns = new ArrayList<String>();
            processedColumns.add(" ");
            expectedResults.add("ER");
            actualResults.add("AR");
            for (String column : table.getData().getColumns()) {
                String columnValue = table.getRecords() > 0 ? table.getData().getData().get(0).get(table.getData().getColumns().indexOf(column)) : "Not Found";
                for (Map.Entry<String, String> entry : tableMarker.getExpectedResultForQuery().entrySet()) {
                    if (!column.equalsIgnoreCase(entry.getKey())) continue;
                    try {
                        if (!Utils.checkCondition(entry.getValue(), columnValue)) {
                            tableMarkerResult.addColumnStatus(column, Statuses.FAIL, columnValue, entry.getValue());
                        } else {
                            tableMarkerResult.addColumnStatus(column, Statuses.SUCCESS, columnValue, entry.getValue());
                        }
                        expectedResults.add(entry.getValue());
                        processedColumns.add(column);
                    }
                    catch (PatternSyntaxException pse) {
                        throw new PatternCompileException("Problem in evaluating Validation Table Marker. Exception : " + pse.getMessage());
                    }
                }
                if (!processedColumns.contains(column)) {
                    expectedResults.add("---");
                    processedColumns.add(column);
                }
                actualResults.add(columnValue);
            }
            processedData.add(expectedResults);
            processedData.add(actualResults);
            table.getData().setColumns(processedColumns);
            table.getData().setData(processedData);
            this.sqlService.saveSqlTableToFile(Collections.singletonList(table));
        }
        if (tableMarker.getTableRowCount() != null) {
            if (!Utils.checkCondition(tableMarker.getTableRowCount(), String.valueOf(table.getRecords()))) {
                tableMarkerResult.setTableRowCount(tableMarker.getTableRowCount(), String.valueOf(table.getRecords()), Statuses.FAIL);
            } else {
                tableMarkerResult.setTableRowCount(tableMarker.getTableRowCount(), String.valueOf(table.getRecords()), Statuses.SUCCESS);
            }
        }
        return tableMarkerResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveSqlPrerequisiteResponseToFlowData(Prerequisite prerequisite, List<CommandResponse> responses) {
        if (prerequisite.getName() == null) return;
        Optional<CommandResponse> prerequisiteQuery = responses.stream().filter(this::filterQueryType).findFirst();
        if (!prerequisiteQuery.isPresent()) throw new PrerequisiteQueryNotValidException(Constants.sqlOperators);
        SqlResponse sqlResponse = prerequisiteQuery.get().getSqlResponse();
        if (sqlResponse.getRecords() > 0) {
            String value = sqlResponse.getData().getData().get(0).get(0);
            this.miaContext.getFlowData().addParameter(prerequisite.getName(), value);
            log.info("Parameter {} saved as {} from query: {}", new Object[]{prerequisite.getName(), value, sqlResponse.getQuery()});
            return;
        } else {
            if (sqlResponse.getDescription() == null) throw new PrerequisiteNoRecordsAddedException(sqlResponse.getQuery());
            this.miaContext.getFlowData().addParameter(prerequisite.getName(), sqlResponse.getDescription());
            log.info("Parameter {}  from query: {}", (Object)prerequisite.getName(), (Object)sqlResponse.getQuery());
        }
    }

    private void saveVariableFromLog(CommandResponse commandResponse, HashMap<String, String> variables) {
        CommandOutput commandOutput = commandResponse.getCommandOutputs().get(0);
        try {
            commandOutput.contentFromFile().forEach(string -> variables.forEach((variableName, regex) -> {
                String value = Utils.getFirstGroupFromStringByRegexp(string, regex);
                if (value != null) {
                    this.miaContext.getFlowData().addParameter((String)variableName, value);
                    log.info("Parameter '{}' saved as '{}' from string: {}", new Object[]{value, variableName, string});
                }
            }));
        }
        catch (PatternSyntaxException pse) {
            throw new PatternCompileException("Problem in variableToExtractFromLog value. " + pse.getMessage());
        }
    }

    private boolean skipPrerequisite(Prerequisite prerequisite, Command command) {
        List<String> commandValuesToRefer = prerequisite.getReferToCommandValue();
        List<String> inputNamesToRefer = prerequisite.getReferToInputName();
        boolean toSkip = false;
        if (commandValuesToRefer != null) {
            if (commandValuesToRefer.stream().anyMatch(commandValue -> commandValue.equalsIgnoreCase(command.getToExecute()))) {
                if (inputNamesToRefer != null) {
                    toSkip = this.checkInput(inputNamesToRefer);
                }
            } else {
                toSkip = true;
            }
        } else if (inputNamesToRefer != null) {
            toSkip = this.checkInput(inputNamesToRefer);
        }
        return toSkip;
    }

    private void validateProcessStatus(ExecutionResponse executionResponse) {
        ProcessStatus processStatusFromMarkerResult = new ProcessStatus();
        try {
            processStatusFromMarkerResult.setStatus(executionResponse.getCommandResponse().getSqlResponse().getTableMarkerResult().getTableRowCount().getStatus());
            executionResponse.setProcessStatus(processStatusFromMarkerResult);
        }
        catch (NullPointerException e) {
            log.debug("cannot set process status from markerResult (NPE1), because [{}]", (Object)e.getMessage());
        }
        try {
            if (executionResponse.getCommandResponse().getErrors().size() > 0) {
                processStatusFromMarkerResult.setStatus(Statuses.FAIL);
                executionResponse.setProcessStatus(processStatusFromMarkerResult);
            }
        }
        catch (NullPointerException e) {
            log.debug("cannot set process status from markerResult (NPE2), because [{}]", (Object)e.getMessage());
        }
        try {
            if (executionResponse.getCommandResponse().getPostScriptExecutionReport().contains("Error")) {
                processStatusFromMarkerResult.setStatus(Statuses.FAIL);
                executionResponse.setProcessStatus(processStatusFromMarkerResult);
            }
        }
        catch (NullPointerException e) {
            log.debug("cannot set process status from markerResult (NPE3), because [{}]", (Object)e.getMessage());
        }
    }

    public ProcessService(MiaContext miaContext, MiaFileService miaFileService, SshExecutionHelperService sshService, TestDataService testDataService, SqlExecutionHelperService sqlService, RestExecutionHelperService restService, SoapExecutionHelperService soapService, MetricsAggregateService metricsService, RecordingSessionsService recordingSessionsService, GridFsService gridFsService, ProcessStatusRepository processStatusRepository, String fileDownloadPrefix, String miaEntityUrlFormat, SseEmitterService sseEmitterService) {
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
        this.sshService = sshService;
        this.testDataService = testDataService;
        this.sqlService = sqlService;
        this.restService = restService;
        this.soapService = soapService;
        this.metricsService = metricsService;
        this.recordingSessionsService = recordingSessionsService;
        this.gridFsService = gridFsService;
        this.processStatusRepository = processStatusRepository;
        this.fileDownloadPrefix = fileDownloadPrefix;
        this.miaEntityUrlFormat = miaEntityUrlFormat;
        this.sseEmitterService = sseEmitterService;
    }
}

