/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Optional;
import java.util.UUID;
import org.owasp.encoder.Encode;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.pot.Link;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.entity.PotExecutionStep;
import org.qubership.atp.mia.model.pot.entity.PotSession;
import org.qubership.atp.mia.repo.db.RecordingSessionRepository;
import org.qubership.atp.mia.service.AtpUserService;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RecordingSessionsService {
    private static final Logger log = LoggerFactory.getLogger(RecordingSessionsService.class);
    private final RecordingSessionRepository recordingSessionRepository;
    private final MiaContext miaContext;
    private final AtpUserService atpUserService;

    public PotSession addExecutionStep(ExecutionResponse executionResponse) {
        UUID sessionId = this.miaContext.getFlowData().getSessionId();
        log.info("Save execution step for session ID #{}", (Object)sessionId);
        Optional recordingSessionOptional = this.recordingSessionRepository.findById(sessionId);
        PotSession recordingSession = recordingSessionOptional.isPresent() ? (PotSession)recordingSessionOptional.get() : (PotSession)this.recordingSessionRepository.save(new PotSession(sessionId, this.miaContext.getConfig(), this.atpUserService.getAtpUser()));
        this.recordingSessionRepository.save(recordingSession.addExecutionStep(this.generateExecutionStepFromExecutionResponse(executionResponse)));
        return recordingSession;
    }

    public void deleteSession(UUID sessionId) {
        try {
            this.recordingSessionRepository.deleteById(sessionId);
        }
        catch (Exception e) {
            log.error("Error during session {} remove.", (Object)sessionId, (Object)e);
        }
    }

    public Optional<PotSession> getSession(UUID sessionId) {
        return this.recordingSessionRepository.findById(sessionId);
    }

    public void deleteOldSession() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -3);
        log.info("With Scheduled CleanPostgresqlPot Cron Job, {} records got deleted.", (Object)this.recordingSessionRepository.deleteByCreatedAtBefore(new Timestamp(calendar.getTimeInMillis())));
    }

    private PotExecutionStep generateExecutionStepFromExecutionResponse(ExecutionResponse executionResponse) {
        PotExecutionStep potExecutionStep = new PotExecutionStep();
        potExecutionStep.setStepName(executionResponse.getProcessName());
        potExecutionStep.setEnvironmentName(this.miaContext.getFlowData().getEnvironment().getName());
        potExecutionStep.setExecutedCommand(executionResponse.getExecutedCommand());
        ArrayList<Link> outputFiles = new ArrayList<Link>();
        if (executionResponse.getCommandResponse() != null) {
            if (executionResponse.getCommandResponse().getCommandOutputs() != null) {
                for (CommandOutput commandOutput : executionResponse.getCommandResponse().getCommandOutputs()) {
                    outputFiles.add(this.getLinkForPot(commandOutput.getInternalPathToFile(), commandOutput.getLink()));
                }
            }
            if (executionResponse.getCommandResponse().getSqlResponse() != null) {
                SqlResponse sqlResponse = executionResponse.getCommandResponse().getSqlResponse();
                potExecutionStep.setExecutedCommand(sqlResponse.getQuery());
                if (sqlResponse.getLink() != null) {
                    outputFiles.add(this.getLinkForPot(sqlResponse.getInternalPathToFile(), sqlResponse.getLink()));
                }
            }
        }
        potExecutionStep.setLinks(outputFiles);
        ArrayList<SqlResponse> validations = new ArrayList<SqlResponse>();
        if (executionResponse.getValidations() != null) {
            for (SqlResponse sqlResponse : executionResponse.getValidations()) {
                SqlResponse validation = new SqlResponse();
                validation.setData(sqlResponse.getData());
                validation.setTableName(sqlResponse.getTableName());
                validation.setQuery(sqlResponse.getQuery());
                validation.setDescription(sqlResponse.getDescription());
                validation.setRecords(sqlResponse.getRecords());
                validation.setTableMarkerResult(sqlResponse.getTableMarkerResult());
                validation.setInternalPathToFile(sqlResponse.getInternalPathToFile(), this.miaContext);
                validation.setLink(this.getLinkForPot(sqlResponse.getInternalPathToFile(), sqlResponse.getLink()));
                validation.setSaveToWordFile(sqlResponse.isSaveToWordFile());
                validation.setSaveToZipFile(sqlResponse.isSaveToZipFile());
                validation.setConnectionInfo(sqlResponse.getConnectionInfo());
                validations.add(validation);
            }
        }
        potExecutionStep.setValidations(validations);
        potExecutionStep.setProcessStatus(executionResponse.getProcessStatus());
        log.debug("Added process status for recording session from Response: {}", (Object)executionResponse.getProcessStatus());
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if (executionResponse.getCommandResponse() != null && executionResponse.getCommandResponse().getErrors() != null) {
            arrayList.addAll(executionResponse.getCommandResponse().getErrors());
        }
        if (executionResponse.getError() != null) {
            arrayList.add((Exception)((Object)executionResponse.getError()));
        }
        potExecutionStep.setErrors(arrayList);
        return potExecutionStep;
    }

    private Link getLinkForPot(String path, Link link) {
        String safeName = Encode.forHtml((String)link.getName());
        return new Link(path, safeName);
    }

    public RecordingSessionsService(RecordingSessionRepository recordingSessionRepository, MiaContext miaContext, AtpUserService atpUserService) {
        this.recordingSessionRepository = recordingSessionRepository;
        this.miaContext = miaContext;
        this.atpUserService = atpUserService;
    }
}

