/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import clover.com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.Holder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.qubership.atp.mia.exceptions.internal.ssl.SslAlgorithmNotPresentException;
import org.qubership.atp.mia.exceptions.internal.ssl.SslInitException;
import org.qubership.atp.mia.exceptions.rest.RestExceptionDuringExecution;
import org.qubership.atp.mia.exceptions.rest.RestExecutionTimeOutException;
import org.qubership.atp.mia.exceptions.rest.RestHeadersIncorrectFormatException;
import org.qubership.atp.mia.exceptions.rest.RestIncorrectEndpointException;
import org.qubership.atp.mia.exceptions.rest.RestIncorrectUrlException;
import org.qubership.atp.mia.exceptions.rest.RestResultWriteToFileException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.impl.executable.Rest;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.utils.CryptoUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RestClientService {
    private static final Logger log = LoggerFactory.getLogger(RestClientService.class);
    @Value(value="${rest.execution.timeout:5}")
    protected long executionTimeout;
    private final MiaContext miaContext;

    public static SSLContext getSslContext() {
        SSLContext sslContext = null;
        TrustManager[] trustAllCerts = new X509TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SslAlgorithmNotPresentException(e);
        }
        catch (KeyManagementException e) {
            throw new SslInitException(e);
        }
        return sslContext;
    }

    public HttpClient prepareRestClient(Server server, boolean disableRedirect, Map<String, String> connectionInfo) {
        String login = server.getProperty("login");
        String password = server.getProperty("password");
        connectionInfo.put("user", login);
        HttpClientBuilder httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout((int)TimeUnit.MINUTES.toMillis(this.executionTimeout)).setConnectTimeout((int)TimeUnit.MINUTES.toMillis(this.executionTimeout)).build()).setSSLContext(RestClientService.getSslContext()).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        if (Strings.isNullOrEmpty((String)login) || Strings.isNullOrEmpty((String)password)) {
            log.info("These fields from REST connection are empty: login, password.");
        } else {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, CryptoUtils.decryptValue(password));
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClient.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        if (disableRedirect) {
            httpClient.disableRedirectHandling();
        } else {
            httpClient.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        return httpClient.build();
    }

    public HttpRequestBase prepareRestRequest(Rest rest, Server server, Map<String, String> connectionInfo) {
        Rest.RestMethod method;
        log.info("Preparing REST request");
        try {
            method = Rest.RestMethod.valueOf(this.miaContext.evaluate(rest.getMethod()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Rest method should one of " + Arrays.toString((Object[])Rest.RestMethod.values()));
        }
        String endPoint = this.miaContext.evaluate(rest.getEndpoint());
        if (Strings.isNullOrEmpty((String)endPoint)) {
            throw new RestIncorrectEndpointException("Null or Empty End Point");
        }
        if (Strings.isNullOrEmpty((String)server.getProperty("url"))) {
            throw new RestIncorrectUrlException();
        }
        String fullUrl = this.miaContext.evaluate(endPoint);
        if (!fullUrl.startsWith("http")) {
            fullUrl = server.getProperty("url") + fullUrl;
        }
        connectionInfo.put("endpoint", fullUrl);
        connectionInfo.put("method", method.name());
        HttpRequestBase request = method.getHttpRequest(fullUrl);
        if (!Strings.isNullOrEmpty((String)rest.getHeaders())) {
            String headers = this.miaContext.evaluate(this.miaContext.evaluate(rest.getHeaders()));
            this.setHeaders(request, headers);
            connectionInfo.put("headersRequest", headers);
        }
        if (!Strings.isNullOrEmpty((String)rest.getBody()) && request instanceof HttpEntityEnclosingRequestBase) {
            String body = this.miaContext.evaluate(this.miaContext.evaluate(rest.getBody()));
            connectionInfo.put("bodyRequest", body);
            ByteArrayEntity bodyEntity = new ByteArrayEntity(body.getBytes(this.getCharsetFromRequest(request)));
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)bodyEntity);
            log.debug("REST body: {}", (Object)bodyEntity);
        }
        log.debug("REST request: {}", (Object)request);
        return request;
    }

    public HttpResponse executeRestRequest(HttpClient httpClient, HttpRequestBase request) {
        HttpResponse httpResponse;
        try {
            log.info("Executing REST request: {}", (Object)request);
            httpResponse = httpClient.execute((HttpUriRequest)request);
            log.debug("REST executed with response: " + httpResponse);
        }
        catch (SocketTimeoutException ste) {
            throw new RestExecutionTimeOutException(this.executionTimeout, "minute(s)", request.getURI().toString());
        }
        catch (IOException e) {
            throw new RestExceptionDuringExecution(e);
        }
        return httpResponse;
    }

    public String createFileWithResponse(String responseBody, File logFile) {
        if (responseBody.startsWith("<")) {
            responseBody = Utils.getPrettyStringFromXml(responseBody).replaceFirst(">", ">\n");
        }
        try {
            Files.write(Paths.get(logFile.getPath(), new String[0]), responseBody.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RestResultWriteToFileException(e);
        }
        return logFile.getPath();
    }

    private void setHeaders(HttpRequestBase request, String headers) {
        log.info("Setting headers to request: {}, headers: {}", (Object)request, (Object)headers);
        for (String header : headers.split("\n")) {
            String headerValue;
            String headerName;
            if (header.contains(":")) {
                headerName = header.substring(0, header.indexOf(":")).trim();
                headerValue = header.substring(header.indexOf(":") + 1).trim();
                if ("null".equalsIgnoreCase(headerValue)) {
                    headerValue = "";
                }
            } else {
                throw new RestHeadersIncorrectFormatException(header);
            }
            log.debug("Header name: {}, Header value: {}", (Object)headerName, (Object)headerValue);
            request.setHeader(headerName, headerValue);
        }
    }

    private Charset getCharsetFromRequest(HttpRequestBase request) {
        Holder charset = new Holder((Object)StandardCharsets.ISO_8859_1);
        Arrays.stream(request.getHeaders("Content-Type")).anyMatch(h -> {
            Matcher matcher = Pattern.compile(".*charset=([\\w\\-]+).*").matcher(h.getValue());
            if (matcher.matches()) {
                String charsetValue = matcher.group(1);
                try {
                    charset.value = Charset.forName(matcher.group(1));
                    log.info("Charset \"{}\" will use for parsing request body according to header", charset.value);
                    return true;
                }
                catch (Exception e) {
                    log.error("Incorrect charset \"{}\". Use default \"{}\"", (Object)charsetValue, charset.value);
                }
            }
            return false;
        });
        return (Charset)charset.value;
    }

    public RestClientService(MiaContext miaContext) {
        this.miaContext = miaContext;
    }
}

