/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.mia.exceptions.soap.SoapNotFoundException;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.repo.impl.SoapRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SoapExecutionHelperService {
    private static final Logger log = LoggerFactory.getLogger(SoapExecutionHelperService.class);
    private final SoapRepository soapRepository;
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;

    @AtpJaegerLog
    public CommandResponse sendSoapRequest(Command command) {
        if (command.getSoap() == null) {
            throw new SoapNotFoundException();
        }
        if (!Strings.isNullOrEmpty((String)command.getSoap().getRequestFile())) {
            String requestFile = this.miaContext.evaluate(command.getSoap().getRequestFile());
            Path uploadsPath = this.miaContext.getUploadsPath().resolve(requestFile).normalize();
            Path projectPath = this.miaContext.getProjectFilePath().resolve(requestFile).normalize();
            Path resolvedPath = null;
            if (Files.exists(uploadsPath, new LinkOption[0])) {
                resolvedPath = uploadsPath;
            } else if (Files.exists(projectPath, new LinkOption[0])) {
                resolvedPath = projectPath;
            } else {
                resolvedPath = projectPath;
                this.miaFileService.getFile(resolvedPath.toString());
                if (!Files.exists(resolvedPath, new LinkOption[0])) {
                    throw new RuntimeException("File not found even after attempting to fetch: " + resolvedPath);
                }
            }
            try {
                String fileContent = FileUtils.readFile(resolvedPath);
                command.getSoap().setRequest(this.miaContext.evaluate(fileContent));
            }
            catch (SecurityException e) {
                throw new RuntimeException("Failed to read SOAP request file securely: " + resolvedPath, e);
            }
        } else {
            command.getSoap().setRequest(this.miaContext.evaluate(command.getSoap().getRequest()));
        }
        return this.soapRepository.sendSoapRequest(command);
    }

    public SoapExecutionHelperService(SoapRepository soapRepository, MiaContext miaContext, MiaFileService miaFileService) {
        this.soapRepository = soapRepository;
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
    }
}

