/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import clover.com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshMissedParameterException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshPathForDownloadEmptyException;
import org.qubership.atp.mia.exceptions.businesslogic.ssh.SshTransferFileFailException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.FlowData;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.generation.Template;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.repo.impl.ShellRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SshExecutionHelperService {
    private static final Logger log = LoggerFactory.getLogger(SshExecutionHelperService.class);
    private static final String FIND_COMMAND = "find";
    private final ShellRepository shellRepository;
    private final MiaContext miaContext;
    private final MiaFileService miaFileService;

    @AtpJaegerLog
    public CommandResponse executeSingleCommand(Command command) {
        return this.shellRepository.executeAndGetLog(command);
    }

    @AtpJaegerLog
    public CommandResponse executeCommandAndGenerateFile(Command command) {
        if (Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getEthalonFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getNamesOfFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)command.getPathForUpload())) {
            String params = "ethalonFilesForGeneration, namesOfFilesForGeneration, pathForUpload.";
            throw new SshMissedParameterException(params);
        }
        Server server = this.shellRepository.getServer(command);
        this.miaContext.getFlowData().addParameters(server.getProperties());
        String ethalonFileName = this.miaContext.evaluate(command.getEthalonFilesForGeneration().get(0));
        String nameOfFileForGeneration = this.miaContext.evaluate(command.getNamesOfFilesForGeneration().get(0));
        Template template = new Template(this.miaContext, this.miaFileService, ethalonFileName, nameOfFileForGeneration, command.getFileExtension(), command.definedCharsetForGeneratedFile());
        this.applyIfSaveGeneratedFiles(command, (name, value) -> this.miaContext.getFlowData().addParameter((String)name, template.getFileName()));
        template.evaluateFile();
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        this.shellRepository.uploadFileOnServer(server, pathForUpload, template.getFile());
        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(command);
        commandResponse.addCommandOutput(new CommandOutput(template.getFile().getPath(), pathForUpload, true, this.miaContext));
        this.applyIfSaveGeneratedFiles(command, (name, value) -> this.miaContext.getFlowData().removeParameter((String)name));
        return commandResponse;
    }

    @AtpJaegerLog
    public CommandResponse executeCommandAndUploadFile(Command command) {
        if (Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getFilesForUpload().get(0))) || Strings.isNullOrEmpty((String)command.getPathForUpload())) {
            String params = "fileForUpload, pathForUpload";
            throw new SshMissedParameterException(params);
        }
        Server server = this.shellRepository.getServer(command);
        this.miaContext.getFlowData().addParameters(server.getProperties());
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        for (String fileName : command.getFilesForUpload()) {
            String fullFileName = this.miaContext.evaluate(fileName);
            File fileForUpload = this.miaFileService.getFile(this.miaContext.evaluate(fullFileName));
            this.shellRepository.uploadFileOnServer(server, pathForUpload, fileForUpload);
        }
        return this.shellRepository.executeAndGetLog(command);
    }

    @AtpJaegerLog
    public CommandResponse generateEventFilesAndExecuteCommand(Command command) {
        if (Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getEthalonFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getNamesOfFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)command.getPathForUpload()) || Objects.requireNonNull(command.getValues()).size() < 1 || command.getEthalonFilesForGeneration().size() != command.getNamesOfFilesForGeneration().size()) {
            String params = "ethalonFilesForGeneration, namesOfFilesForGeneration, fileExtension,pathForUpload, values. Size of ethalonFilesForGeneration must be equals to size of namesOfFilesForGeneration";
            throw new SshMissedParameterException(params);
        }
        LinkedList<CommandOutput> commandOutputs = new LinkedList<CommandOutput>();
        Server server = this.shellRepository.getServer(command);
        FlowData flowData = this.miaContext.getFlowData();
        flowData.addParameters(server.getProperties());
        Iterator<String> ethalonFilesIterator = command.getEthalonFilesForGeneration().iterator();
        Iterator<String> namesOfFilesForGeneration = command.getNamesOfFilesForGeneration().iterator();
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        while (ethalonFilesIterator.hasNext() && namesOfFilesForGeneration.hasNext()) {
            String ethalonFile = this.miaContext.evaluate(ethalonFilesIterator.next());
            String fileForGeneration = this.miaContext.evaluate(namesOfFilesForGeneration.next());
            Template template = new Template(this.miaContext, this.miaFileService, ethalonFile, fileForGeneration, command.getFileExtension(), command.definedCharsetForGeneratedFile());
            template.evaluateFile();
            this.shellRepository.uploadFileOnServer(server, pathForUpload, template.getFile());
            commandOutputs.add(new CommandOutput(template.getFile().getPath(), null, false, this.miaContext));
            this.applyIfSaveGeneratedFiles(command, (name, value) -> {
                value = Strings.isNullOrEmpty((String)value) ? "[]" : value;
                value = value.replaceAll("]", "," + template.getFileName() + "]").replaceAll("\\[,", "[");
                flowData.addParameter((String)name, (String)value);
            });
        }
        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(command);
        this.applyIfSaveGeneratedFiles(command, (name, value) -> flowData.removeParameter((String)name));
        Utils.getPathToFileOutOfLog(commandResponse.getCommandOutputs().get(0).getInternalPathToFile(), command.getRegexpForFileRetrieve()).forEach(path -> commandOutputs.add(this.shellRepository.getFileOnServer(command, pathForUpload + path.trim(), false)));
        commandResponse.addCommandOutputs(commandOutputs);
        return commandResponse;
    }

    @AtpJaegerLog
    public CommandResponse executeCommandAndCheckFileOnServer(Command command) {
        if (Strings.isNullOrEmpty((String)command.getRegexpForFileRetrieve())) {
            String params = "regexpForFileRetrieve";
            throw new SshMissedParameterException(params);
        }
        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(command);
        Utils.getPathToFileOutOfLog(commandResponse.getCommandOutputs().get(0).getInternalPathToFile(), command.getRegexpForFileRetrieve()).forEach(path -> commandResponse.addCommandOutput(this.shellRepository.getFileOnServer(command, (String)path, command.getDisplayDownloadedFileContent())));
        return commandResponse;
    }

    @AtpJaegerLog
    public CommandResponse executeCommandAndTransferFileOnServer(Command command) {
        if (Strings.isNullOrEmpty((String)command.getRegexpForFileRetrieve()) || Strings.isNullOrEmpty((String)command.getPathForUpload())) {
            String params = "regexpForFileRetrieve, pathForUpload";
            throw new SshMissedParameterException(params);
        }
        Server server = this.shellRepository.getServer(command);
        this.miaContext.getFlowData().addParameters(server.getProperties());
        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(command);
        ArrayList<String> pathsToFiles = Utils.getPathToFileOutOfLog(commandResponse.getCommandOutputs().get(0).getInternalPathToFile(), command.getRegexpForFileRetrieve());
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        for (String pathToFile : pathsToFiles) {
            try {
                this.shellRepository.transferFileOnServer(command, pathToFile, pathForUpload);
                commandResponse.addDescription(String.format("File [%s] has been moved to [%s]", pathToFile, pathForUpload));
            }
            catch (Exception e) {
                throw new SshTransferFileFailException(pathToFile, pathForUpload, e);
            }
        }
        return commandResponse;
    }

    @AtpJaegerLog
    public CommandResponse executeCommandAndDownloadFilesFromServer(Command command) {
        if (Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getPathsForDownload()).get(0)) || Strings.isNullOrEmpty((String)command.getRegexpForFileRetrieve())) {
            String params = "pathsForDownload, regexpForFileRetrieve";
            throw new SshMissedParameterException(params);
        }
        CommandResponse commandResponse = this.shellRepository.executeAndGetLog(command);
        commandResponse.addCommandOutputs(this.findAndDownloadFiles(command));
        return commandResponse;
    }

    private LinkedList<CommandOutput> findAndDownloadFiles(Command command) {
        LinkedList<CommandOutput> outputs = new LinkedList<CommandOutput>();
        List<String> paths = command.getPathsForDownload();
        if (paths != null && paths.size() > 0) {
            String evaluateRegexp = this.miaContext.evaluate(command.getRegexpForFileRetrieve());
            for (String path : paths) {
                String evaluatePath = this.miaContext.evaluate(path);
                evaluatePath = evaluatePath.endsWith("*") ? evaluatePath : evaluatePath + " -maxdepth 1 ";
                String findCommand = "find " + evaluatePath + " " + evaluateRegexp;
                command.setToExecute(findCommand);
                if (!Strings.isNullOrEmpty((String)command.getDelayForGeneration())) {
                    try {
                        TimeUnit.SECONDS.sleep(Long.parseLong(command.getDelayForGeneration()));
                    }
                    catch (InterruptedException e) {
                        log.warn("Could not do delay for generation of dump.", (Throwable)e);
                    }
                }
                CommandOutput findOutput = null;
                try {
                    findOutput = this.shellRepository.executeAndGetLog(command).getCommandOutputs().get(0);
                }
                catch (Exception e) {
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append("Error during execution of find command [").append(findCommand).append("]. ");
                    if (!evaluatePath.endsWith("/")) {
                        errMsg.append("Try to add '/' (slash) at the end of pathsForDownload parameter in SSH process ").append("configuration if you specified a directory not a file!");
                    }
                    log.error("{}", (Object)errMsg, (Object)e);
                    String localPathToFile = this.miaContext.getLogPath().toString();
                    outputs.add(this.shellRepository.fileNotFound(localPathToFile, null, errMsg.toString()));
                }
                boolean isDisplay = command.getDisplayDownloadedFileContent();
                Optional.ofNullable(findOutput).map(CommandOutput::contentFromFile).ifPresent(resultPaths -> resultPaths.forEach(resultPath -> outputs.add(this.shellRepository.getFileOnServer(command, (String)resultPath, isDisplay))));
            }
        } else {
            throw new SshPathForDownloadEmptyException();
        }
        return outputs;
    }

    @AtpJaegerLog
    public CommandResponse uploadFilesAndDownloadResults(Command command) {
        if (Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getEthalonFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)Objects.requireNonNull(command.getNamesOfFilesForGeneration()).get(0)) || Strings.isNullOrEmpty((String)command.getFileExtension()) || Strings.isNullOrEmpty((String)command.getPathForUpload()) || Objects.requireNonNull(command.getValues()).size() < 1) {
            String params = "ethalonFilesForGeneration, namesOfFilesForGeneration, fileExtension,pathForUpload, values.";
            throw new SshMissedParameterException(params);
        }
        Server server = this.shellRepository.getServer(command);
        this.miaContext.getFlowData().addParameters(server.getProperties());
        List<String> ethalonFiles = command.getEthalonFilesForGeneration();
        ArrayList<String> commandValues = new ArrayList<String>(command.getValues());
        int ethalonFilesCount = ethalonFiles.size();
        int commandValuesCount = commandValues.size();
        CommandResponse commandResponse = new CommandResponse();
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        String fileExtension = command.getFileExtension();
        for (int i = 0; i < ethalonFilesCount; ++i) {
            String nameOfFileForGeneration = this.miaContext.evaluate(command.getNamesOfFilesForGeneration().get(i));
            Template template = new Template(this.miaContext, this.miaFileService, ethalonFiles.get(i), nameOfFileForGeneration, fileExtension, command.definedCharsetForGeneratedFile());
            this.shellRepository.uploadFileOnServer(server, pathForUpload, template.getFile());
            this.applyIfSaveGeneratedFiles(command, (name, value) -> this.miaContext.getFlowData().addParameter((String)name, template.getFileName()));
            Command singleCommand = new Command(commandValuesCount == 1 ? (String)commandValues.get(0) : (String)commandValues.get(i));
            singleCommand.setSystem(command.getSystem());
            singleCommand.setPathForUpload(pathForUpload);
            commandResponse.addCommandResponse(this.shellRepository.executeAndGetLog(singleCommand));
            this.applyIfSaveGeneratedFiles(command, (name, value) -> this.miaContext.getFlowData().removeParameter((String)name));
            String path = pathForUpload + nameOfFileForGeneration + fileExtension;
            if (!Strings.isNullOrEmpty((String)command.getDelayForGeneration())) {
                try {
                    TimeUnit.SECONDS.sleep(Long.valueOf(command.getDelayForGeneration()));
                }
                catch (InterruptedException e) {
                    log.warn("Could not do delay for generation of dump.", (Throwable)e);
                }
            }
            commandResponse.addCommandOutput(this.shellRepository.getFileOnServer(singleCommand, path, command.getDisplayDownloadedFileContent()));
        }
        return commandResponse;
    }

    private void applyIfSaveGeneratedFiles(Command command, BiConsumer<String, String> consumer) {
        if (!Strings.isNullOrEmpty((String)command.getSaveGeneratedFilesToParameter())) {
            String parameterName = command.getSaveGeneratedFilesToParameter();
            consumer.accept(parameterName, this.miaContext.getFlowData().getParameters().get(parameterName));
        }
    }

    public void resetCache() {
        this.shellRepository.resetCache();
    }

    public SshExecutionHelperService(ShellRepository shellRepository, MiaContext miaContext, MiaFileService miaFileService) {
        this.shellRepository = shellRepository;
        this.miaContext = miaContext;
        this.miaFileService = miaFileService;
    }
}

