/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.execution;

import clover.com.google.common.base.Strings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.mia.exceptions.fileservice.UploadTestDataFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixCommandIncorrectParameterException;
import org.qubership.atp.mia.exceptions.testdata.MatrixExcelCloseFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixExcelWriteFailException;
import org.qubership.atp.mia.exceptions.testdata.MatrixIncorrectParameterException;
import org.qubership.atp.mia.exceptions.testdata.MatrixScenarioNotFoundException;
import org.qubership.atp.mia.model.environment.Server;
import org.qubership.atp.mia.model.exception.ErrorCodes;
import org.qubership.atp.mia.model.impl.CommandResponse;
import org.qubership.atp.mia.model.impl.FlowData;
import org.qubership.atp.mia.model.impl.VariableFormat;
import org.qubership.atp.mia.model.impl.executable.Command;
import org.qubership.atp.mia.model.impl.generation.Template;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbook;
import org.qubership.atp.mia.model.impl.testdata.TestDataWorkbookStyles;
import org.qubership.atp.mia.model.impl.testdata.parsed.Scenario;
import org.qubership.atp.mia.model.pot.Statuses;
import org.qubership.atp.mia.model.pot.db.SqlResponse;
import org.qubership.atp.mia.model.pot.db.table.DbTable;
import org.qubership.atp.mia.model.pot.db.table.TableMarkerResult;
import org.qubership.atp.mia.repo.impl.ShellRepository;
import org.qubership.atp.mia.repo.impl.TestDataRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.execution.SqlExecutionHelperService;
import org.qubership.atp.mia.service.file.MiaFileService;
import org.qubership.atp.mia.utils.FileUtils;
import org.qubership.atp.mia.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TestDataService {
    private static final Logger log = LoggerFactory.getLogger(TestDataService.class);
    private final ShellRepository sshRepo;
    private final TestDataRepository testDataRepository;
    private final MiaContext miaContext;
    private final SqlExecutionHelperService sqlService;
    private final MiaFileService miaFileService;

    public static Statuses setValidationStatus(DbTable table, int scenariosToExecuteSize) {
        boolean isThereSuccessTest = table.getData().stream().anyMatch(row -> Integer.parseInt((String)row.get(1)) > 0);
        boolean isThereFailedTest = table.getData().stream().anyMatch(row -> Integer.parseInt((String)row.get(2)) > 0);
        return scenariosToExecuteSize == table.getData().size() && isThereSuccessTest && !isThereFailedTest ? Statuses.SUCCESS : (isThereSuccessTest && isThereFailedTest ? Statuses.WARNING : Statuses.FAIL);
    }

    public TestDataWorkbook uploadTestDataFileAndValidate(MultipartFile file) {
        String excelFile = this.miaFileService.uploadFileOnBe(file, false);
        TestDataWorkbook testDataWorkbook = new TestDataWorkbook(excelFile);
        this.testDataRepository.parseWorkbook(testDataWorkbook, true);
        if (testDataWorkbook.getMainSheet().getScenarios() == null || testDataWorkbook.getMainSheet().getScenarios().size() < 1) {
            throw new UploadTestDataFailException();
        }
        return testDataWorkbook;
    }

    public void writeTestDataWorkbookToFile(String newExcelFileName) {
        log.info("Preparing workbook to save into {}", (Object)newExcelFileName);
        TestDataWorkbook testDataWorkbook = this.testDataRepository.getTestDataWorkbook();
        try (TestDataWorkbookStyles wb = new TestDataWorkbookStyles(new SXSSFWorkbook(100));){
            testDataWorkbook.getMainSheet().write(wb);
            testDataWorkbook.getTestDataSheet().write(wb);
            testDataWorkbook.getQueriesSheet().write(wb);
            log.info("Saving Test Data workbook into {}", (Object)newExcelFileName);
            try (FileOutputStream out = new FileOutputStream(newExcelFileName);){
                wb.getWorkbook().write((OutputStream)out);
            }
            catch (IOException e) {
                throw new MatrixExcelWriteFailException(newExcelFileName, e);
            }
        }
        catch (Exception e) {
            throw new MatrixExcelCloseFailException(newExcelFileName, e);
        }
    }

    @AtpJaegerLog
    public CommandResponse event(Command command) {
        this.checkBeforeExecute();
        this.checkBeforeExecuteEvent(command);
        LinkedList<CommandOutput> commandOutputs = new LinkedList<CommandOutput>();
        Server server = this.sshRepo.getServer(command);
        FlowData flowData = this.miaContext.getFlowData();
        flowData.addParameters(server.getProperties());
        LinkedList eventFiles = new LinkedList();
        TestDataWorkbook testDataWorkbook = this.testDataRepository.getTestDataWorkbook();
        testDataWorkbook.getScenariosToExecute().forEach(sce -> {
            Scenario scenarioMain = this.findScenarioByName(testDataWorkbook.getMainSheet().getScenarios(), (String)sce, "Scenario '" + sce + "' not found on Main page");
            Scenario scenarioSec = this.findScenarioByName(testDataWorkbook.getTestDataSheet().getScenarios(), (String)sce, null);
            if (command.getTestDataParams().isEventFileForEachScenario()) {
                String ethalonFile = this.miaContext.evaluate(command.getTestDataParams().getEventFileTemplate());
                String toGeneration = this.miaContext.evaluate(command.getNamesOfFilesForGeneration().get(0));
                eventFiles.add(new Template(this.miaContext, this.miaFileService, ethalonFile, toGeneration, command.getFileExtension(), command.definedCharsetForGeneratedFile()));
            }
            this.testDataRepository.generateEventScenario(command, eventFiles, scenarioMain, scenarioSec);
        });
        String pathForUpload = this.miaContext.evaluate(command.getPathForUpload());
        eventFiles.forEach(template -> {
            String paramInTemplate = command.getTestDataParams().getEventParameterInTemplate();
            VariableFormat varFormat = new VariableFormat(this.miaContext.getConfig().getCommonConfiguration().getVariableFormat());
            String neededParamInTemplate = varFormat.getVariableAccordingFormat(paramInTemplate);
            template.replaceContent(neededParamInTemplate, "");
            template.writeContent();
            this.sshRepo.uploadFileOnServer(server, pathForUpload, template.getFile());
            commandOutputs.add(new CommandOutput(template.getFile().getPath(), null, false, this.miaContext));
        });
        String controlFile = command.getTestDataParams().getControlFileTemplate();
        if (!Strings.isNullOrEmpty((String)controlFile) && !Strings.isNullOrEmpty((String)command.getSaveGeneratedFilesToParameter())) {
            flowData.addParameter(command.getSaveGeneratedFilesToParameter(), "[" + eventFiles.stream().map(Template::getFileName).collect(Collectors.joining(", ")) + "]");
            String toGeneration = command.getNamesOfFilesForGeneration().size() > 1 ? this.miaContext.evaluate(command.getNamesOfFilesForGeneration().get(1)) : Utils.getFileNameWithoutExtension(controlFile);
            Template controlTemplate = new Template(this.miaContext, this.miaFileService, controlFile, toGeneration, command.getFileExtension(), command.definedCharsetForGeneratedFile());
            controlTemplate.evaluateFile();
            flowData.removeParameter(command.getSaveGeneratedFilesToParameter());
            this.sshRepo.uploadFileOnServer(server, pathForUpload, controlTemplate.getFile());
            commandOutputs.add(new CommandOutput(controlTemplate.getFile().getPath(), null, false, this.miaContext));
        }
        this.writeTestDataWorkbookToFile(testDataWorkbook.getExcelFile());
        String excelFilePath = testDataWorkbook.getExcelFile();
        commandOutputs.add(new CommandOutput(excelFilePath, null, false, this.miaContext));
        CommandResponse commandResponse = this.sshRepo.executeAndGetLog(command);
        commandResponse.addCommandOutputs(commandOutputs);
        return commandResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AtpJaegerLog
    public CommandResponse validate(Command command) {
        TestDataWorkbook testDataWorkbook = this.testDataRepository.getTestDataWorkbook();
        CommandResponse commandResponse = new CommandResponse();
        this.checkBeforeExecute();
        LinkedHashSet<String> scenariosToExecute = testDataWorkbook.getScenariosToExecute();
        DbTable table = new DbTable(Arrays.asList("SCENARIO", "PASSED", "FAILED"), new ArrayList<List<String>>());
        SqlResponse sqlResponse = new SqlResponse();
        sqlResponse.setDescription("Result for validations from Test Data file");
        sqlResponse.setRecords(scenariosToExecute.size());
        sqlResponse.setTableName("");
        sqlResponse.setQuery("");
        LinkedList<String> generatedFiles = new LinkedList<String>();
        try {
            scenariosToExecute.forEach(sce -> {
                Scenario scenarioMain = this.findScenarioByName(testDataWorkbook.getMainSheet().getScenarios(), (String)sce, "Scenario '" + sce + "' not found on Main page");
                Scenario scenarioSec = this.findScenarioByName(testDataWorkbook.getTestDataSheet().getScenarios(), (String)sce, null);
                this.testDataRepository.validateScenario(scenarioMain, scenarioSec, command.getSystem());
                table.addData(Arrays.asList(sce, String.valueOf(scenarioMain.getPassedValidatedNumber()), String.valueOf(scenarioMain.getFailedValidatedNumber())));
                String file = Utils.getFileNameWithTimestamp(testDataWorkbook.getExcelFile());
                this.writeTestDataWorkbookToFile(file);
                generatedFiles.add(file);
            });
        }
        catch (Exception e) {
            log.error(ErrorCodes.MIA_1700_MATRIX_VALIDATION_ERROR.getMessage(e.getMessage()));
            commandResponse.addError(e);
        }
        finally {
            this.getLastFileAndRemoveTemporaryFiles(generatedFiles, commandResponse, testDataWorkbook.getExcelFile());
            sqlResponse.setData(table);
            TableMarkerResult tableMarkerResult = new TableMarkerResult();
            Statuses rowsStatus = TestDataService.setValidationStatus(table, scenariosToExecute.size());
            tableMarkerResult.setTableRowCount(String.valueOf(scenariosToExecute.size()), String.valueOf(table.getData().size()), rowsStatus);
            sqlResponse.setTableMarkerResult(tableMarkerResult);
            commandResponse.setSqlResponse(sqlResponse);
            this.sqlService.saveSqlTableToFile(Collections.singletonList(sqlResponse));
        }
        return commandResponse;
    }

    @AtpJaegerLog
    public CommandResponse sql(Command command) {
        return this.executeCommandBiConsumer((scenarioMain, scenarioSec) -> this.testDataRepository.sqlScenario((Scenario)scenarioMain, (Scenario)scenarioSec, command));
    }

    @AtpJaegerLog
    public CommandResponse ssh(Command command) {
        return this.executeCommandBiConsumer((scenarioMain, scenarioSec) -> this.testDataRepository.sshScenario((Scenario)scenarioMain, (Scenario)scenarioSec, command));
    }

    @AtpJaegerLog
    public CommandResponse soap(Command command) {
        return this.executeCommandBiConsumer((scenarioMain, scenarioSec) -> this.testDataRepository.soapScenario((Scenario)scenarioMain, (Scenario)scenarioSec, command));
    }

    @AtpJaegerLog
    public CommandResponse rest(Command command) {
        return this.executeCommandBiConsumer((scenarioMain, scenarioSec) -> this.testDataRepository.restScenario((Scenario)scenarioMain, (Scenario)scenarioSec, command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResponse executeCommandBiConsumer(BiConsumer<Scenario, Scenario> executeCommand) {
        TestDataWorkbook testDataWorkbook = this.testDataRepository.getTestDataWorkbook();
        CommandResponse commandResponse = CommandResponse.getCommandResponseWithFilledRequestInfo();
        this.checkBeforeExecute();
        LinkedHashSet<String> scenariosToExecute = testDataWorkbook.getScenariosToExecute();
        LinkedList<String> generatedFiles = new LinkedList<String>();
        try {
            scenariosToExecute.forEach(sce -> {
                Scenario scenarioMain = this.findScenarioByName(testDataWorkbook.getMainSheet().getScenarios(), (String)sce, "Scenario '" + sce + "' not found on Main page");
                Scenario scenarioSec = this.findScenarioByName(testDataWorkbook.getTestDataSheet().getScenarios(), (String)sce, null);
                executeCommand.accept(scenarioMain, scenarioSec);
                String file = Utils.getFileNameWithTimestamp(testDataWorkbook.getExcelFile());
                this.writeTestDataWorkbookToFile(file);
                generatedFiles.add(file);
            });
        }
        catch (Exception e) {
            log.error("Exception during command execution: {}", (Object)e.getMessage());
            commandResponse.addError(e);
        }
        finally {
            commandResponse.getConnectionInfo().put("timestampResponse", Utils.getTimestamp());
            this.getLastFileAndRemoveTemporaryFiles(generatedFiles, commandResponse, testDataWorkbook.getExcelFile());
        }
        return commandResponse;
    }

    private void getLastFileAndRemoveTemporaryFiles(LinkedList<String> generatedFiles, CommandResponse commandResponse, String initialPath) {
        if (generatedFiles.size() > 0) {
            String lastFile = generatedFiles.getLast();
            commandResponse.addCommandOutput(new CommandOutput(lastFile, null, false, this.miaContext));
            generatedFiles.removeLast();
            try {
                FileUtils.copyFile(Paths.get(lastFile, new String[0]), Paths.get(initialPath, new String[0]));
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            for (String fileToRemove : generatedFiles) {
                FileUtils.removeFile(fileToRemove);
            }
        }
    }

    private void checkBeforeExecute() {
        TestDataWorkbook testDataWorkbook = this.testDataRepository.getTestDataWorkbook();
        if (testDataWorkbook == null) {
            throw new MatrixIncorrectParameterException("Test data");
        }
        if (testDataWorkbook.getMainSheet().getScenarios() == null) {
            throw new MatrixIncorrectParameterException("Scenarios");
        }
        if (testDataWorkbook.getScenariosToExecute() == null) {
            throw new MatrixIncorrectParameterException("Scenarios to validate");
        }
    }

    private void checkBeforeExecuteEvent(Command command) {
        if (command.getTestDataParams() == null) {
            throw new MatrixCommandIncorrectParameterException("Scenarios to validate");
        }
        if (Strings.isNullOrEmpty((String)command.getPathForUpload())) {
            throw new MatrixCommandIncorrectParameterException("pathForUpload");
        }
        if (command.getNamesOfFilesForGeneration() == null || command.getNamesOfFilesForGeneration().size() < 1) {
            throw new MatrixCommandIncorrectParameterException("namesOfFilesForGeneration");
        }
        if (Strings.isNullOrEmpty((String)command.getTestDataParams().getEventFileTemplate())) {
            throw new MatrixCommandIncorrectParameterException("eventFileTemplate");
        }
        if (Strings.isNullOrEmpty((String)command.getTestDataParams().getEventTemplate())) {
            throw new MatrixCommandIncorrectParameterException("eventTemplate");
        }
        if (Strings.isNullOrEmpty((String)command.getTestDataParams().getEventParameterInTemplate())) {
            throw new MatrixCommandIncorrectParameterException("eventParameterInTemplate");
        }
    }

    private Scenario findScenarioByName(LinkedList<Scenario> scenarios, String scenarioName, String error) {
        if (scenarios != null) {
            Optional<Scenario> scenario = scenarios.stream().filter(s -> s.getName().equals(scenarioName)).findFirst();
            if (!scenario.isPresent()) {
                if (Strings.isNullOrEmpty((String)error)) {
                    return null;
                }
                throw new MatrixScenarioNotFoundException(error);
            }
            return scenario.get();
        }
        return null;
    }

    public TestDataService(ShellRepository sshRepo, TestDataRepository testDataRepository, MiaContext miaContext, SqlExecutionHelperService sqlService, MiaFileService miaFileService) {
        this.sshRepo = sshRepo;
        this.testDataRepository = testDataRepository;
        this.miaContext = miaContext;
        this.sqlService = sqlService;
        this.miaFileService = miaFileService;
    }
}

