/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.file;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.util.Strings;
import org.bson.types.ObjectId;
import org.qubership.atp.mia.exceptions.gridfs.GridFsFileNotFoundException;
import org.qubership.atp.mia.exceptions.gridfs.GridFsGetFileFromDbException;
import org.qubership.atp.mia.exceptions.gridfs.GridfsSaveLogToDbException;
import org.qubership.atp.mia.model.file.FileMetaData;
import org.qubership.atp.mia.model.file.ProjectFile;
import org.qubership.atp.mia.model.file.ProjectFileType;
import org.qubership.atp.mia.model.impl.ExecutionResponse;
import org.qubership.atp.mia.model.impl.output.CommandOutput;
import org.qubership.atp.mia.repo.gridfs.GridFsRepository;
import org.qubership.atp.mia.service.MiaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GridFsService {
    private static final Logger log = LoggerFactory.getLogger(GridFsService.class);
    private final GridFsRepository fsRepository;
    private final MiaContext miaContext;

    public void cleanDb() {
        this.fsRepository.cleanDb();
    }

    public void cleanMongoProjectFiles(UUID projectId, List<String> excludeIds) {
        log.info("Cleaning project files in GridFs for {} with exclusion {}", (Object)projectId, excludeIds);
        this.fsRepository.findAndDeleteObsoleteProjectFiles(projectId, excludeIds);
    }

    public void cleanLogs(Integer cleanInterval) {
        Date oldestAllowedFileDate = DateUtils.addHours((Date)new Date(), (int)(-cleanInterval.intValue()));
        File targetDir = FileMetaData.PROJECT_FOLDER.toFile();
        if (targetDir.exists()) {
            Iterator filesToDelete = FileUtils.iterateFiles((File)targetDir, (IOFileFilter)new AgeFileFilter(oldestAllowedFileDate), (IOFileFilter)TrueFileFilter.INSTANCE);
            while (filesToDelete.hasNext()) {
                FileUtils.deleteQuietly((File)((File)filesToDelete.next()));
            }
            this.deleteEmptyDir(targetDir);
        }
    }

    public void deleteProjectFile(ProjectFile projectFile) {
        log.info("Delete file {} from GridFs", (Object)projectFile.getName());
        this.fsRepository.removeFile(new ObjectId(projectFile.getGridFsObjectId()));
    }

    public boolean existFile(ProjectFile projectFile) {
        return this.fsRepository.exist(projectFile);
    }

    public String getCollectionsSize() {
        return "Overall collection size: " + this.fsRepository.getCollectionsSize(null) + ";\nProject collection size: " + this.fsRepository.getCollectionsSize(this.miaContext.getProjectId());
    }

    public void rename(ProjectFile projectFile) {
        log.info("Update path in GridFs for file '{}' with ID '{}' in directory '{}'", new Object[]{projectFile.getName(), projectFile.getId(), projectFile.getDirectory() == null ? "MIA_ROOT_DIRECTORY" : projectFile.getDirectory().getName()});
        this.fsRepository.rename(projectFile);
    }

    public void restoreFile(File file) {
        FileMetaData fileMetaData = FileMetaData.define(this.miaContext.getProjectId(), file.toString());
        log.info("Restore file: {}.", (Object)fileMetaData.getFileName());
        try (InputStream is = this.fsRepository.get(fileMetaData).orElseThrow(() -> new FileNotFoundException(file.toString()));){
            file.getParentFile().mkdirs();
            FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
        }
        catch (IOException e) {
            throw new GridFsGetFileFromDbException(file.toString(), e);
        }
    }

    public Optional<GridFSFile> getFile(String gridFsObjectId) {
        return this.fsRepository.getById(gridFsObjectId);
    }

    public void saveLogResponseAfterExecution(ExecutionResponse response) {
        log.info("Save log response after execution to GridFs");
        if (response.getPrerequisites() != null) {
            log.info("Save prerequisites");
            response.getPrerequisites().forEach(p -> this.saveCommandOutput(p.getCommandOutputs()));
        }
        if (response.getCommandResponse() != null) {
            log.info("Save command");
            if (response.getCommandResponse().getCommandOutputs() != null) {
                this.saveCommandOutput(response.getCommandResponse().getCommandOutputs());
            } else if (response.getCommandResponse().getSqlResponse() != null) {
                String fileName = response.getCommandResponse().getSqlResponse().getInternalPathToFile();
                if (Strings.isNotEmpty((CharSequence)fileName)) {
                    this.uploadFile(FileMetaData.log(this.miaContext.getProjectId(), fileName), fileName);
                }
            } else {
                log.warn("No Command output file is found");
            }
        }
        if (response.getValidations() != null) {
            log.info("Save validations");
            response.getValidations().forEach(v -> {
                String fileName = v.getInternalPathToFile();
                if (Strings.isNotEmpty((CharSequence)fileName)) {
                    this.uploadFile(FileMetaData.log(this.miaContext.getProjectId(), fileName), fileName);
                } else {
                    log.error("Can't upload to GridFs: internal path not defined for validation {}", v);
                }
            });
        }
    }

    public ObjectId uploadFile(FileMetaData fileMetaData, String fullPathToFile) {
        return this.uploadFile(fileMetaData, Paths.get(fullPathToFile, new String[0]).toAbsolutePath().normalize().toFile());
    }

    public ObjectId uploadFile(FileMetaData fileMetaData, File fullPathToFile) {
        ObjectId objectId;
        log.info("Upload file {} to GridFs", (Object)fileMetaData);
        FileInputStream is = new FileInputStream(fullPathToFile);
        try {
            objectId = this.fsRepository.save(fileMetaData, is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new GridFsFileNotFoundException(fullPathToFile.toString(), e);
            }
            catch (IOException e) {
                throw new GridfsSaveLogToDbException(e);
            }
        }
        is.close();
        return objectId;
    }

    private void deleteEmptyDir(File directory) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    this.deleteEmptyDir(file);
                }
            }
            directory.delete();
        }
    }

    private void saveCommandOutput(List<CommandOutput> outputs) {
        if (outputs != null) {
            for (CommandOutput output : outputs) {
                String fileName = output.getInternalPathToFile();
                if (output.getMarkedContent().stream().anyMatch(markedContent -> markedContent.getText().contains("SSH download failed."))) {
                    log.error("Problem Occurred in process execution. Could not get file from server and Can't upload to GridFs. File path: {}", (Object)fileName);
                    continue;
                }
                if (Strings.isNotEmpty((CharSequence)fileName)) {
                    if (fileName.contains(ProjectFileType.MIA_FILE_TYPE_LOG.toString())) {
                        this.uploadFile(FileMetaData.log(this.miaContext.getProjectId(), fileName), fileName);
                        continue;
                    }
                    if (!fileName.contains(ProjectFileType.MIA_FILE_TYPE_UPLOAD.toString())) continue;
                    this.uploadFile(FileMetaData.upload(this.miaContext.getProjectId(), fileName), fileName);
                    continue;
                }
                log.error("Can't upload to GridFs: internal path not defined for output {}", (Object)output);
            }
        }
    }

    public byte[] getByteArrayFromGridFsFile(GridFSFile file) {
        return this.fsRepository.getFileContent(file);
    }

    public GridFsService(GridFsRepository fsRepository, MiaContext miaContext) {
        this.fsRepository = fsRepository;
        this.miaContext = miaContext;
    }
}

