/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.javers.core.Javers;
import org.javers.core.commit.CommitId;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.mia.exceptions.history.MiaHistoryRevisionRestoreException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.service.history.EntityHistoryService;
import org.qubership.atp.mia.service.history.RestoreHistoryService;
import org.qubership.atp.mia.service.history.impl.AbstractRestoreMapper;
import org.qubership.atp.mia.service.history.impl.ValidateReferenceExistsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRestoreHistoryService<E extends DateAuditorEntity>
implements RestoreHistoryService {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestoreHistoryService.class);
    protected final Javers javers;
    protected final EntityHistoryService<E> entityHistoryService;
    private final ValidateReferenceExistsService validateReferenceExistsService;
    protected final AbstractRestoreMapper modelMapper;

    @Override
    public Object restoreToRevision(UUID id, long revisionId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).withVersion(revisionId).withScopeDeepPlus().build();
        E actualObject = this.getObject(id);
        this.validateReferenceExistsService.validateEntity(actualObject);
        List shadows = this.javers.findShadows(query);
        if (CollectionUtils.isEmpty((Collection)shadows)) {
            log.error("No shadows found for entity '{}' with revision='{}' and uuid='{}'", new Object[]{this.getItemType(), revisionId, id});
            throw new MiaHistoryRevisionRestoreException();
        }
        Shadow objectShadow = (Shadow)shadows.iterator().next();
        Object restoredObject = this.restoreValues(objectShadow, actualObject);
        return this.saveRestoredObject((DateAuditorEntity)restoredObject);
    }

    public Object restoreToCommit(UUID id, CommitId commitId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, this.getEntityClass()).toCommitId(commitId).build();
        E actualObject = this.getObject(id);
        this.validateReferenceExistsService.validateEntity(actualObject);
        List shadows = this.javers.findShadows(query);
        if (!CollectionUtils.isEmpty((Collection)shadows)) {
            Shadow objectShadow = (Shadow)shadows.iterator().next();
            Object restoredObject = this.restoreValues(objectShadow, actualObject);
            return this.saveRestoredObject((DateAuditorEntity)restoredObject);
        }
        log.warn("No shadows found for entity '{}' with CommitId='{}' and uuid='{}'", new Object[]{this.getItemType(), commitId, id});
        return null;
    }

    protected Object restoreValues(Shadow<E> shadow, E actualObject) {
        DateAuditorEntity snapshot = (DateAuditorEntity)shadow.get();
        if (!actualObject.getClass().equals(snapshot.getClass())) {
            throw new MiaHistoryRevisionRestoreException();
        }
        this.copyValues(snapshot, actualObject);
        return actualObject;
    }

    public E getObject(UUID id) {
        return this.entityHistoryService.get(id);
    }

    public E saveRestoredObject(E object) {
        return this.entityHistoryService.restore(object);
    }

    protected abstract void copyValues(E var1, E var2);

    public AbstractRestoreHistoryService(Javers javers, EntityHistoryService<E> entityHistoryService, ValidateReferenceExistsService validateReferenceExistsService, AbstractRestoreMapper modelMapper) {
        this.javers = javers;
        this.entityHistoryService = entityHistoryService;
        this.validateReferenceExistsService = validateReferenceExistsService;
        this.modelMapper = modelMapper;
    }
}

