/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.List;
import java.util.Optional;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.qubership.atp.mia.service.history.RestoreHistoryService;
import org.qubership.atp.mia.service.history.RetrieveHistoryService;
import org.springframework.stereotype.Component;

@Component
public class HistoryServiceFactory {
    private final List<RestoreHistoryService> restoreHistoryServices;
    private final List<RetrieveHistoryService<? extends DateAuditorEntity>> retrieveHistoryServices;

    public Optional<RestoreHistoryService> getRestoreHistoryService(String itemType) {
        return this.restoreHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).findFirst();
    }

    public Optional<RetrieveHistoryService<? extends DateAuditorEntity>> getRetrieveHistoryService(String itemType) {
        return this.retrieveHistoryServices.stream().filter(service -> service.getItemType().toString().equalsIgnoreCase(itemType)).findFirst();
    }

    public HistoryServiceFactory(List<RestoreHistoryService> restoreHistoryServices, List<RetrieveHistoryService<? extends DateAuditorEntity>> retrieveHistoryServices) {
        this.restoreHistoryServices = restoreHistoryServices;
        this.retrieveHistoryServices = retrieveHistoryServices;
    }
}

