/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import org.modelmapper.ModelMapper;
import org.qubership.atp.mia.controllers.api.dto.HistoryItemTypeDto;
import org.qubership.atp.mia.controllers.api.dto.ProcessHistoryChangeDto;
import org.qubership.atp.mia.model.configuration.ProcessConfiguration;
import org.qubership.atp.mia.model.converters.ProcessSettingsConverter;
import org.qubership.atp.mia.service.history.impl.AbstractVersioningMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessVersioningMapper
extends AbstractVersioningMapper<ProcessConfiguration, ProcessHistoryChangeDto> {
    private static final Logger log = LoggerFactory.getLogger(ProcessVersioningMapper.class);
    private final ProcessSettingsConverter processSettingsConverter;

    ProcessVersioningMapper(ModelMapper mapper, ProcessSettingsConverter processSettingsConverter) {
        super(ProcessConfiguration.class, ProcessHistoryChangeDto.class, mapper);
        this.processSettingsConverter = processSettingsConverter;
    }

    @Override
    protected HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.PROCESS;
    }

    @Override
    public void mapSpecificFields(ProcessConfiguration source, ProcessHistoryChangeDto destination) {
        super.mapSpecificFields(source, destination);
        destination.id(source.getId());
        destination.setName(source.getName());
        if (source.getCompounds() != null) {
            destination.setInSections(source.getSections());
        }
        if (source.getCompounds() != null) {
            destination.setInCompounds(source.getCompounds());
        }
        destination.setProcessSettings(this.processSettingsConverter.convertToDatabaseColumn(source.getProcessSettings()));
    }
}

