/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.history.impl;

import java.util.Set;
import javax.validation.Validator;
import org.qubership.atp.mia.exceptions.history.MiaJaversReferenceInvalidException;
import org.qubership.atp.mia.model.DateAuditorEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ValidateReferenceExistsService<T extends DateAuditorEntity> {
    private static final Logger log = LoggerFactory.getLogger(ValidateReferenceExistsService.class);
    private final Validator validator;

    public ValidateReferenceExistsService(Validator validator) {
        this.validator = validator;
    }

    public void validateEntity(T entity) {
        Set violations = this.validator.validate(entity, new Class[0]);
        if (!violations.isEmpty()) {
            log.error("Validation failed for Javers entity: {}. Violations: {}", entity, (Object)violations);
            throw new MiaJaversReferenceInvalidException(violations);
        }
    }
}

