/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.service.monitoring;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.qubership.atp.mia.service.MiaContext;
import org.qubership.atp.mia.service.monitoring.MetricsAggregateService;
import org.springframework.stereotype.Service;

@Service
public class MetricsAggregateServiceImpl
implements MetricsAggregateService {
    private static final String PROCESSES_RUNNING_DIRECT = "atp.mia.processes.count";
    private static final String COMPOUNDS_RUNNING_DIRECT = "atp.mia.compounds.count";
    private static final String TEST_DATA_RUNNING_DIRECT = "atp.mia.test.data.count";
    private static final String EVENT_EXCEL_RUNNING_DIRECT = "atp.mia.event.excel.count";
    private static final String PROJECT = "project";
    private static final String REQUEST_CONTEXT_SIZE = "atp.mia.request.context.size";
    private static final String DOWNLOAD_FILE_SIZE = "atp.mia.download.file.size";
    private static final String SQL_QUERY_RECORDS_SIZE = "atp.mia.sql.query.records.size";
    private static final String REST_RESPONSE_SIZE = "atp.mia.rest.response.size";
    private static final String SOAP_RESPONSE_SIZE = "atp.mia.soap.response.size";
    private final Counter.Builder projectToProcessesRunningCounter = Counter.builder((String)"atp.mia.processes.count").description("total number of running processes");
    private final Counter.Builder projectToCompoundsRunningCounter = Counter.builder((String)"atp.mia.compounds.count").description("total number of running compounds");
    private final Counter.Builder projectToTestDataRunningCounter = Counter.builder((String)"atp.mia.test.data.count").description("total number of running test data");
    private final Counter.Builder projectToEventExcelCallsRunningCounter = Counter.builder((String)"atp.mia.event.excel.count").description("total number of running excel calls");
    private final Counter.Builder projectToRequestContentSize = Counter.builder((String)"atp.mia.request.context.size").description("content size per request");
    private final Counter.Builder projectToDownloadFileSize = Counter.builder((String)"atp.mia.download.file.size").description("Downloaded file size from Ssh Server");
    private final Counter.Builder projectToSqlQueryRecordsSize = Counter.builder((String)"atp.mia.sql.query.records.size").description("No of SQL Query records");
    private final Counter.Builder projectToRestResponseSize = Counter.builder((String)"atp.mia.rest.response.size").description("Rest response size");
    private final Counter.Builder projectToSoapResponseSize = Counter.builder((String)"atp.mia.soap.response.size").description("Soap response size");
    private final MeterRegistry meterRegistry;
    private final MiaContext miaContext;

    @Override
    public void processExecutionWasStarted() {
        this.projectToProcessesRunningCounter.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment();
    }

    @Override
    public void compoundExecutionWasStarted() {
        this.projectToCompoundsRunningCounter.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment();
    }

    @Override
    public void testDataExecutionWasStarted() {
        this.projectToTestDataRunningCounter.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment();
    }

    @Override
    public void eventFromExcelCallStarted() {
        this.projectToEventExcelCallsRunningCounter.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment();
    }

    @Override
    public void requestContextSize(int contextSize) {
        this.projectToRequestContentSize.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment((double)contextSize);
    }

    @Override
    public void requestSshDownloadFileSize(long fileSize) {
        this.projectToDownloadFileSize.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment((double)fileSize);
    }

    @Override
    public void sqlQueryRecordsSize(long numberOfRecords) {
        this.projectToSqlQueryRecordsSize.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment((double)numberOfRecords);
    }

    @Override
    public void restResponseSize(long responseSize) {
        this.projectToRestResponseSize.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment((double)responseSize);
    }

    @Override
    public void soapResponseSize(int responseSize) {
        this.projectToSoapResponseSize.tags(new String[]{PROJECT, this.miaContext.getProjectId().toString()}).register(this.meterRegistry).increment((double)responseSize);
    }

    public MetricsAggregateServiceImpl(MeterRegistry meterRegistry, MiaContext miaContext) {
        this.meterRegistry = meterRegistry;
        this.miaContext = miaContext;
    }
}

