/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.repository.MacrosRepository;
import org.qubership.atp.mia.service.execution.MacrosService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class AtpMacrosUtils {
    private static final Logger log = LoggerFactory.getLogger(AtpMacrosUtils.class);
    private static MacrosRepository macrosRepositoryStatic;
    private static MacrosService macrosServiceStatic;
    private static boolean macrosEnableStatic;
    private final MacrosFeignClient macrosFeignClient;
    private final MacrosService macrosService;
    private final MacrosDtoConvertService macrosDtoConvertService;
    @Value(value="${feign.atp.macros.enabled}")
    private boolean macrosEnable;

    public static String evaluateWithAtpMacros(String texToEvaluate, UUID projectId) {
        List<Macros> macros;
        Optional<Macros> macro;
        if (macrosEnableStatic && (macro = (macros = macrosServiceStatic.getMacros(projectId, macrosRepositoryStatic)).stream().filter(m -> texToEvaluate.contains(m.getName())).findFirst()).isPresent()) {
            return macrosRepositoryStatic.evaluate(texToEvaluate);
        }
        return texToEvaluate;
    }

    @PostConstruct
    public void init() {
        macrosRepositoryStatic = new MacrosRepository(this.macrosFeignClient, this.macrosDtoConvertService);
        macrosServiceStatic = this.macrosService;
        macrosEnableStatic = this.macrosEnable;
    }

    public AtpMacrosUtils(MacrosFeignClient macrosFeignClient, MacrosService macrosService, MacrosDtoConvertService macrosDtoConvertService) {
        this.macrosFeignClient = macrosFeignClient;
        this.macrosService = macrosService;
        this.macrosDtoConvertService = macrosDtoConvertService;
    }
}

