/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import javax.annotation.PostConstruct;
import org.qubership.atp.crypt.api.Decryptor;
import org.qubership.atp.crypt.api.Encryptor;
import org.qubership.atp.mia.exceptions.authorization.DecryptEncriptedDataException;
import org.qubership.atp.mia.exceptions.authorization.EncryptDataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CryptoUtils {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtils.class);
    private static Decryptor decryptorStatic;
    private static Encryptor encryptorStatic;
    private final Decryptor decryptor;
    private final Encryptor encryptor;

    public static String decryptValue(String textToDecrypt) {
        try {
            return decryptorStatic.decryptIfEncrypted(textToDecrypt);
        }
        catch (Exception e) {
            throw new DecryptEncriptedDataException(e);
        }
    }

    public static String encryptValue(String textToEncrypt) {
        try {
            return encryptorStatic.encrypt(textToEncrypt);
        }
        catch (Exception e) {
            throw new EncryptDataException(e);
        }
    }

    @PostConstruct
    public void init() {
        decryptorStatic = this.decryptor;
        encryptorStatic = this.encryptor;
    }

    public void initForTest(Decryptor decryptor, Encryptor encryptor) {
        decryptorStatic = decryptor;
        encryptorStatic = encryptor;
    }

    public CryptoUtils(Decryptor decryptor, Encryptor encryptor) {
        this.decryptor = decryptor;
        this.encryptor = encryptor;
    }
}

