/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.mia.utils;

import clover.com.google.common.base.Strings;
import clover.org.apache.commons.lang3.Range;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.ws.Holder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.qubership.atp.mia.model.impl.ExcelWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelParserHelper {
    private static final Logger log = LoggerFactory.getLogger(ExcelParserHelper.class);

    @Nullable
    public static XSSFCell getCellByHeaderNameInRow(@Nonnull String headerName, @Nonnull XSSFRow row) {
        return ExcelParserHelper.getCellByHeaderNameInRow(headerName, 0, row);
    }

    @Nullable
    public static XSSFCell getCellByHeaderNameInRow(@Nonnull String headerName, int headerRowNum, @Nonnull XSSFRow row) {
        Holder cellHolder = new Holder(null);
        row.forEach(cell -> {
            XSSFRow rowHeader = row.getSheet().getRow(headerRowNum);
            if (rowHeader.getCell(cell.getColumnIndex()) != null && rowHeader.getCell(cell.getColumnIndex()).getCellType() == CellType.STRING && rowHeader.getCell(cell.getColumnIndex()).getStringCellValue().equalsIgnoreCase(headerName)) {
                cellHolder.value = (XSSFCell)cell;
                return;
            }
        });
        return (XSSFCell)cellHolder.value;
    }

    public static XSSFCell getHeaderByCell(int headerRowNum, @Nonnull XSSFCell cell) {
        return cell.getRow().getSheet().getRow(headerRowNum).getCell(cell.getColumnIndex());
    }

    @Nullable
    public static XSSFCell getHeaderByPattern(@Nonnull String pattern, @Nonnull XSSFSheet sheet) {
        return ExcelParserHelper.getHeaderByPattern(pattern, 0, sheet);
    }

    @Nullable
    public static XSSFCell getHeaderByPattern(@Nonnull String pattern, Range<Integer> headerRowRange, @Nonnull XSSFSheet sheet) {
        XSSFCell cell;
        int rowId = (Integer)headerRowRange.getMinimum();
        while ((cell = ExcelParserHelper.getHeaderByPattern(pattern, rowId, sheet)) == null && ++rowId <= (Integer)headerRowRange.getMaximum()) {
        }
        return cell;
    }

    @Nullable
    public static XSSFCell getHeaderByPattern(@Nonnull String pattern, int headerRowNum, @Nonnull XSSFSheet sheet) {
        Holder cellHolder = new Holder(null);
        sheet.getRow(headerRowNum).forEach(c -> {
            XSSFCell cell = (XSSFCell)c;
            if (ExcelParserHelper.getCellValue(cell).matches(pattern)) {
                cellHolder.value = cell;
                return;
            }
        });
        return (XSSFCell)cellHolder.value;
    }

    @Nullable
    public static XSSFCell getHeaderByPatternInRange(@Nonnull String pattern, int headerRowNum, @Nonnull XSSFSheet sheet, @Nonnull Range<Integer> range) {
        Holder cellHolder = new Holder(null);
        sheet.getRow(headerRowNum).forEach(c -> {
            XSSFCell cell = (XSSFCell)c;
            if (range.contains((Object)cell.getColumnIndex()) && ExcelParserHelper.getCellValue(cell).matches(pattern)) {
                cellHolder.value = cell;
                return;
            }
        });
        return (XSSFCell)cellHolder.value;
    }

    @Nullable
    public static XSSFCell getCellByParentAndChildHeadersInRow(@Nonnull String parentHeaderName, int parentHeaderRowNum, @Nonnull String childHeaderName, int childHeaderRowNum, @Nonnull XSSFRow row) {
        XSSFCell header = ExcelParserHelper.getHeaderByPattern(parentHeaderName, parentHeaderRowNum, row.getSheet());
        if (header != null) {
            XSSFCell childHeaderCell = ExcelParserHelper.getHeaderByPatternInRange(childHeaderName, childHeaderRowNum, row.getSheet(), ExcelParserHelper.getCellRowRange(header));
            return row.getCell(childHeaderCell.getColumnIndex());
        }
        return null;
    }

    @Nullable
    public static XSSFCell getCellByPattern(@Nonnull String pattern, int columnNumber, @Nonnull XSSFSheet sheet) {
        XSSFRow row;
        XSSFCell cell;
        Iterator rowIterator = sheet.rowIterator();
        do {
            if (rowIterator.hasNext()) continue;
            return null;
        } while (!ExcelParserHelper.getCellValue(cell = (row = (XSSFRow)rowIterator.next()).getCell(columnNumber)).matches(pattern));
        return cell;
    }

    @Nullable
    public static XSSFCell getCell(int rowNumber, int columnNumber, @Nonnull XSSFSheet sheet) {
        Holder cell = new Holder(null);
        XSSFRow row = sheet.getRow(rowNumber);
        if (cell.value == null) {
            sheet.getMergedRegions().forEach(mergedRegion -> {
                if (mergedRegion.isInRange(rowNumber, columnNumber)) {
                    cell.value = sheet.getRow(mergedRegion.getFirstRow()).getCell(mergedRegion.getFirstColumn());
                }
            });
        }
        if (cell.value == null && row != null) {
            cell.value = row.getCell(columnNumber);
        }
        return (XSSFCell)cell.value;
    }

    @Nullable
    public static XSSFCell getCellAnyway(int rowNumber, int columnNumber, @Nonnull XSSFSheet sheet) {
        XSSFCell cell;
        XSSFRow row = sheet.getRow(rowNumber);
        if (row == null) {
            row = sheet.createRow(rowNumber);
        }
        if ((cell = row.getCell(columnNumber)) == null) {
            cell = row.createCell(columnNumber);
        }
        return cell;
    }

    @Nullable
    public static XSSFCell getCellByPatternInRange(@Nonnull String pattern, int columnNumber, @Nonnull Range<Integer> rowRange, @Nonnull XSSFSheet sheet) {
        XSSFCell cell = null;
        for (int rowId = ((Integer)rowRange.getMinimum()).intValue(); rowId <= (Integer)rowRange.getMaximum(); ++rowId) {
            XSSFCell curCell = sheet.getRow(rowId).getCell(columnNumber);
            if (!ExcelParserHelper.getCellValue(curCell).matches(pattern)) continue;
            cell = curCell;
            break;
        }
        return cell;
    }

    @Nonnull
    public static Set<XSSFCell> getAllCellsByPattern(@Nonnull String pattern, int columnNumber, @Nonnull XSSFSheet sheet) {
        Iterator rowIterator = sheet.rowIterator();
        LinkedHashSet<XSSFCell> cells = new LinkedHashSet<XSSFCell>();
        while (rowIterator.hasNext()) {
            String value;
            XSSFRow row = (XSSFRow)rowIterator.next();
            XSSFCell cell = row.getCell(columnNumber);
            if (cell == null || !(value = ExcelParserHelper.getCellValue(cell)).matches(pattern)) continue;
            cells.add(cell);
        }
        return cells;
    }

    @Nonnull
    public static Set<XSSFCell> getAllCellsByPatternInRange(@Nonnull String pattern, int columnNumber, @Nonnull Range<Integer> rowRange, @Nonnull XSSFSheet sheet) {
        LinkedHashSet<XSSFCell> cells = new LinkedHashSet<XSSFCell>();
        for (int rowId = ((Integer)rowRange.getMinimum()).intValue(); rowId <= (Integer)rowRange.getMaximum(); ++rowId) {
            XSSFCell curCell = ExcelParserHelper.getCell(rowId, columnNumber, sheet);
            if (!ExcelParserHelper.getCellValue(curCell).matches(pattern)) continue;
            cells.add(curCell);
        }
        return cells;
    }

    @Nonnull
    public static Set<XSSFCell> getAllCellsByPatternFromRow(@Nonnull String pattern, int columnNumber, int startRowNumber, @Nonnull XSSFSheet sheet) {
        LinkedHashSet<XSSFCell> cells = new LinkedHashSet<XSSFCell>();
        for (int rowId = startRowNumber; rowId <= sheet.getLastRowNum(); ++rowId) {
            XSSFCell curCell = ExcelParserHelper.getCell(rowId, columnNumber, sheet);
            if (!ExcelParserHelper.getCellValue(curCell).matches(pattern)) continue;
            cells.add(curCell);
        }
        return cells;
    }

    public static Range<Integer> getCellColumnRange(@Nonnull XSSFCell cell) {
        Range returnValue = Range.between((Comparable)Integer.valueOf(cell.getRowIndex()), (Comparable)Integer.valueOf(cell.getRowIndex()));
        XSSFSheet sheet = cell.getSheet();
        for (int mergedRegionsId = 0; mergedRegionsId < sheet.getNumMergedRegions(); ++mergedRegionsId) {
            CellRangeAddress mergedRegion = sheet.getMergedRegion(mergedRegionsId);
            if (!mergedRegion.isInRange(cell.getRowIndex(), cell.getColumnIndex())) continue;
            returnValue = Range.between((Comparable)Integer.valueOf(mergedRegion.getFirstRow()), (Comparable)Integer.valueOf(mergedRegion.getLastRow()));
            break;
        }
        return returnValue;
    }

    @Nonnull
    public static Range<Integer> getCellRowRange(@Nonnull XSSFCell cell) {
        Holder range = new Holder((Object)Range.between((Comparable)Integer.valueOf(cell.getColumnIndex()), (Comparable)Integer.valueOf(cell.getColumnIndex())));
        XSSFSheet sheet = cell.getSheet();
        sheet.getMergedRegions().forEach(mergedRegion -> {
            if (mergedRegion.isInRange(cell.getRowIndex(), cell.getColumnIndex())) {
                range.value = Range.between((Comparable)Integer.valueOf(mergedRegion.getFirstColumn()), (Comparable)Integer.valueOf(mergedRegion.getLastColumn()));
                return;
            }
        });
        return (Range)range.value;
    }

    @Nonnull
    public static ExcelWorkbook getWorkBook(@Nonnull String path) {
        try {
            return new ExcelWorkbook(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File is not found or can't read: " + path, e);
        }
    }

    @Nonnull
    public static XSSFSheet getSheet(@Nonnull XSSFWorkbook workbook, @Nullable String sheetName) throws IllegalArgumentException {
        XSSFSheet sheet;
        if (workbook.getNumberOfSheets() > 0) {
            if (Strings.isNullOrEmpty((String)sheetName)) {
                sheet = workbook.getSheetAt(0);
            } else {
                try {
                    sheet = workbook.getSheet(sheetName);
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException("Error reading sheet " + sheetName);
                }
            }
        } else {
            throw new IllegalArgumentException("No sheet in Excel file");
        }
        return sheet;
    }

    @Nonnull
    public static XSSFSheet getSheet(@Nonnull ExcelWorkbook workbook, @Nullable String sheetName) throws IllegalArgumentException {
        return ExcelParserHelper.getSheet(workbook.getWorkbook(), sheetName);
    }

    @Nonnull
    public static XSSFSheet getSheet(Path path, @Nullable String sheetName) throws IllegalArgumentException {
        return ExcelParserHelper.getSheet(ExcelParserHelper.getWorkBook(path.toString()).getWorkbook(), sheetName);
    }

    @Nonnull
    public static String getCellValue(@Nullable Cell cell) {
        return ExcelParserHelper.getCellValue((XSSFCell)cell);
    }

    @Nonnull
    public static String getCellValue(@Nullable XSSFCell cell) {
        if (cell != null) {
            try {
                Holder holderCell = new Holder((Object)cell);
                XSSFSheet sheet = cell.getSheet();
                sheet.getMergedRegions().forEach(mergedRegion -> {
                    if (mergedRegion.isInRange(cell.getRowIndex(), cell.getColumnIndex())) {
                        holderCell.value = ExcelParserHelper.getCell(mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), sheet);
                    }
                });
                return ExcelParserHelper.convertCellValue((Cell)holderCell.value, ((XSSFCell)holderCell.value).getCellType()).trim();
            }
            catch (Exception e) {
                log.error("Error getting cell value [{},{}]: {}", new Object[]{cell.getRowIndex(), cell.getColumnIndex(), e.getMessage()});
            }
        }
        return "";
    }

    private static String convertCellValue(Cell cell, CellType cellType) {
        String value = "";
        switch (cellType) {
            case NUMERIC: {
                value = ExcelParserHelper.decimalFormat(cell.getNumericCellValue());
                if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/YYYY");
                value = sdf.format(cell.getDateCellValue());
                break;
            }
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case FORMULA: {
                value = ExcelParserHelper.convertCellValue(cell, cell.getCachedFormulaResultType());
                break;
            }
        }
        return value;
    }

    public static String decimalFormat(Double value) {
        DecimalFormat format = new DecimalFormat("###.#####");
        return format.format(value);
    }
}

